/*
 * Decompiled with CFR 0.152.
 */
package net.replaceitem.symbolchat.gui.widget;

import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_6379;
import net.minecraft.class_6382;
import net.minecraft.class_6383;
import net.minecraft.class_8029;
import net.replaceitem.symbolchat.SearchUtil;
import net.replaceitem.symbolchat.SymbolChat;
import net.replaceitem.symbolchat.SymbolInsertable;
import net.replaceitem.symbolchat.SymbolSuggestable;
import net.replaceitem.symbolchat.gui.container.NonScrollableContainerWidget;
import net.replaceitem.symbolchat.gui.widget.symbolButton.PasteSymbolButtonWidget;
import net.replaceitem.symbolchat.gui.widget.symbolButton.SymbolButtonWidget;
import org.jetbrains.annotations.Nullable;

public class SymbolSuggestor
extends NonScrollableContainerWidget
implements PasteSymbolButtonWidget.Context {
    private final class_437 screen;
    private final SymbolInsertable symbolInsertable;
    private final SymbolSuggestable suggestable;
    @Nullable
    private String previousSearchTerm = null;
    public static final int HEIGHT = 14;

    public SymbolSuggestor(class_437 screen, SymbolInsertable symbolInsertable, SymbolSuggestable suggestable) {
        super(0, 0, 0, 14);
        this.screen = screen;
        this.symbolInsertable = symbolInsertable;
        this.suggestable = suggestable;
        this.field_22764 = false;
    }

    @Override
    public void onSymbolClicked(String symbol) {
        this.symbolInsertable.insertSymbol(symbol);
    }

    @Override
    public void refresh() {
        class_8029 cursorPosition = this.suggestable.getCursorPosition();
        this.method_46419(cursorPosition.comp_1194() - 14 - 3);
        String search = this.suggestable.getSuggestionTerm();
        int fittingSymbols = Math.floorDiv(this.screen.field_22789, 13);
        int shownSymbols = Math.min(fittingSymbols, (Integer)SymbolChat.config.maxSymbolSuggestions.get());
        if (!Objects.equals(this.previousSearchTerm, search)) {
            this.previousSearchTerm = search;
            this.method_25396().clear();
            if (search != null) {
                Stream<String> searchStream = search.isBlank() ? SymbolChat.symbolManager.getFavoriteSymbols() : SearchUtil.performSearch(SymbolChat.symbolManager.streamAllSymbols(), search);
                List<String> symbols = searchStream.limit(shownSymbols).toList();
                this.field_22758 = 1 + 13 * symbols.size();
                this.method_46421(class_3532.method_15340((int)this.method_46426(), (int)0, (int)(this.screen.field_22789 - this.field_22758)));
                for (int i = 0; i < symbols.size(); ++i) {
                    this.method_25396().add(new PasteSymbolButtonWidget(this, this.method_46426() + 1 + i * 13, this.method_46427() + 1, this, symbols.get(i)){

                        @Override
                        protected boolean isHighlighted() {
                            return this.method_25367();
                        }
                    });
                }
            }
        }
        if (!this.field_22764 && !this.method_25396().isEmpty()) {
            this.method_46421(cursorPosition.comp_1193());
        }
        this.field_22764 = !this.method_25396().isEmpty();
    }

    @Override
    protected void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
        context.method_25294(this.method_46426(), this.method_46427(), this.method_55442(), this.method_55443(), ((Integer)SymbolChat.config.hudColor.get()).intValue());
        super.method_48579(context, mouseX, mouseY, delta);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        class_364 class_3642;
        if (!this.field_22764) {
            return false;
        }
        if (keyCode == 258) {
            PasteSymbolButtonWidget focused;
            class_364 class_3643 = this.method_25399();
            if (class_3643 instanceof PasteSymbolButtonWidget) {
                PasteSymbolButtonWidget pasteSymbolButtonWidget;
                focused = pasteSymbolButtonWidget = (PasteSymbolButtonWidget)class_3643;
            } else if (!this.method_25396().isEmpty() && (class_3643 = this.method_25396().getFirst()) instanceof PasteSymbolButtonWidget) {
                PasteSymbolButtonWidget symbolButtonWidget;
                focused = symbolButtonWidget = (PasteSymbolButtonWidget)class_3643;
            } else {
                return false;
            }
            focused.onClick(0);
            this.hide();
            return true;
        }
        if (keyCode == 265) {
            if (this.method_25399() == null && !this.method_25396().isEmpty()) {
                this.method_25395((class_364)this.method_25396().getFirst());
            }
            return true;
        }
        if (keyCode == 262 && (class_3642 = this.method_25399()) instanceof PasteSymbolButtonWidget) {
            PasteSymbolButtonWidget pasteSymbolButtonWidget = (PasteSymbolButtonWidget)class_3642;
            this.method_25395((class_364)this.method_25396().get(Math.min(this.method_25396().indexOf((Object)pasteSymbolButtonWidget) + 1, this.method_25396().size() - 1)));
            return true;
        }
        if (keyCode == 263 && (class_3642 = this.method_25399()) instanceof PasteSymbolButtonWidget) {
            PasteSymbolButtonWidget pasteSymbolButtonWidget = (PasteSymbolButtonWidget)class_3642;
            this.method_25395((class_364)this.method_25396().get(Math.max(this.method_25396().indexOf((Object)pasteSymbolButtonWidget) - 1, 0)));
            return true;
        }
        if ((keyCode == 264 || keyCode == 256) && this.method_25399() != null) {
            this.method_25395(null);
            return true;
        }
        if (keyCode == 257 && this.method_25399() != null) {
            class_3642 = this.method_25399();
            if (class_3642 instanceof SymbolButtonWidget) {
                SymbolButtonWidget symbolButtonWidget = (SymbolButtonWidget)class_3642;
                symbolButtonWidget.onClick(0);
            }
            this.hide();
            return true;
        }
        return false;
    }

    private void hide() {
        this.method_25395(null);
        this.field_22764 = false;
    }

    public class_6379.class_6380 method_37018() {
        return class_6379.class_6380.field_33784;
    }

    @Override
    protected void method_47399(class_6382 builder) {
        class_364 class_3642 = this.method_25399();
        if (class_3642 instanceof class_6383) {
            class_6383 narratable = (class_6383)class_3642;
            narratable.method_37020(builder);
        }
    }
}

