/*
 * Decompiled with CFR 0.152.
 */
package net.replaceitem.symbolchat.gui.widget;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_4185;
import net.minecraft.class_6381;
import net.minecraft.class_6382;
import net.minecraft.class_6383;
import net.minecraft.class_8030;
import net.replaceitem.symbolchat.SymbolChat;
import net.replaceitem.symbolchat.gui.container.NonScrollableContainerWidget;
import net.replaceitem.symbolchat.gui.container.ScrollableGridContainer;
import net.replaceitem.symbolchat.gui.container.SmoothScrollableContainerWidget;
import org.jetbrains.annotations.Nullable;

public class DropDownWidget<T>
extends NonScrollableContainerWidget
implements class_4068,
class_364,
class_6383 {
    public static final int DROPDOWN_HEIGHT = 150;
    public final List<DropDownElementWidget> elements = new ArrayList<DropDownElementWidget>();
    private final Button buttonWidget;
    private final ScrollableGridContainer scrollableGridWidget;
    public int selected;
    public boolean expanded = false;

    public DropDownWidget(int x, int y, int width, int height, List<T> elementList, @Nullable T defaultSelection, boolean upward) {
        super(x, y, width, height);
        this.buttonWidget = new Button(x, y, width, height);
        this.scrollableGridWidget = new ScrollableGridContainer(this, this.method_46426() + 1, upward ? this.method_46427() - 1 - 150 : this.method_55443() + 1, this.field_22758 - 2, 150, 1){

            @Override
            protected void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
                super.method_48579(context, mouseX, mouseY, delta);
            }
        };
        this.scrollableGridWidget.setScrollbarStyle(SmoothScrollableContainerWidget.ScrollbarStyle.SLIM);
        this.scrollableGridWidget.setSmoothScrolling(true);
        this.scrollableGridWidget.field_22764 = this.expanded;
        for (int i = 0; i < elementList.size(); ++i) {
            DropDownElementWidget element = new DropDownElementWidget(0, 0, this.field_22758 - 2 - this.scrollableGridWidget.getScrollbarThumbWidth(), this.field_22759, elementList.get(i), i);
            this.elements.add(element);
            this.scrollableGridWidget.add(element);
        }
        this.scrollableGridWidget.refreshPositions();
        this.addChildren((class_339)this.buttonWidget);
        this.addChildren((class_339)this.scrollableGridWidget);
        this.selected = defaultSelection == null ? 0 : Math.max(elementList.indexOf(defaultSelection), 0);
    }

    private void toggleVisible() {
        this.scrollableGridWidget.field_22764 = this.expanded = !this.expanded;
    }

    private class_8030 getExpandedArea() {
        return new class_8030(this.scrollableGridWidget.method_46426() - 1, this.scrollableGridWidget.method_46427() - 1, this.scrollableGridWidget.method_25368() + 2, this.scrollableGridWidget.method_25364() + 2);
    }

    @Override
    protected void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
        class_8030 expandedArea = this.getExpandedArea();
        if (this.expanded) {
            context.method_25294(expandedArea.method_49620(), expandedArea.method_49618(), expandedArea.method_49621(), expandedArea.method_49619(), ((Integer)SymbolChat.config.buttonColor.get()).intValue());
        }
        super.method_48579(context, mouseX, mouseY, delta);
    }

    public boolean method_25405(double mouseX, double mouseY) {
        return super.method_25405(mouseX, mouseY) || this.expanded && this.getExpandedArea().method_58137((int)mouseX, (int)mouseY);
    }

    public void changeSelected(int index) {
        this.selected = index;
        if (this.expanded) {
            this.toggleVisible();
        }
        this.onSelection(index, this.elements.get(index).getElement());
    }

    public void onSelection(int index, T element) {
    }

    public T getSelection() {
        return this.elements.get(this.selected).getElement();
    }

    class Button
    extends class_4185 {
        protected Button(int x, int y, int width, int height) {
            super(x, y, width, height, (class_2561)class_2561.method_43473(), button -> DropDownWidget.this.toggleVisible(), field_40754);
        }

        private int getBackgroundColor() {
            return this.method_49606() ? (Integer)SymbolChat.config.buttonActiveColor.get() : (Integer)SymbolChat.config.buttonColor.get();
        }

        public class_2561 method_25369() {
            return DropDownWidget.this.elements.get(DropDownWidget.this.selected).method_25369();
        }

        protected void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
            class_310 minecraftClient = class_310.method_1551();
            int color = this.method_49606() ? 0xFFFFFF : 0xA0A0A0;
            context.method_25294(this.method_46426(), this.method_46427(), this.method_55442(), this.method_55443(), this.getBackgroundColor());
            this.method_48589(context, minecraftClient.field_1772, color | class_3532.method_15386((float)(this.field_22765 * 255.0f)) << 24);
        }
    }

    public class DropDownElementWidget
    extends class_339
    implements class_4068,
    class_364,
    class_6383 {
        private final T element;
        private final int index;

        public DropDownElementWidget(int x, int y, int width, int height, T element, int index) {
            super(x, y, width, height, (class_2561)class_2561.method_43470((String)element.toString()));
            this.element = element;
            this.index = index;
        }

        private int getBackgroundColor() {
            return this.method_49606() ? (Integer)SymbolChat.config.buttonActiveColor.get() : (Integer)SymbolChat.config.buttonColor.get();
        }

        public void method_48579(class_332 drawContext, int mouseX, int mouseY, float delta) {
            if (this.field_22764) {
                drawContext.method_25294(this.method_46426(), this.method_46427(), this.method_46426() + this.field_22758, this.method_46427() + this.field_22759, this.getBackgroundColor());
                class_327 textRenderer = class_310.method_1551().field_1772;
                int z = this.method_49606() ? 0xFFFFFF : 0xA0A0A0;
                drawContext.method_27534(textRenderer, this.method_25369(), this.method_46426() + this.field_22758 / 2, this.method_46427() + (this.field_22759 - 8) / 2, z | class_3532.method_15386((float)(this.field_22765 * 255.0f)) << 24);
            }
        }

        public void method_25348(double mouseX, double mouseY) {
            DropDownWidget.this.changeSelected(this.index);
        }

        public void method_47399(class_6382 builder) {
            this.method_37021(builder);
            builder.method_37033(class_6381.field_33790, "Dropdown element: " + this.element.toString());
        }

        public T getElement() {
            return this.element;
        }
    }
}

