/*
 * Decompiled with CFR 0.152.
 */
package net.replaceitem.symbolchat.config;

import com.google.gson.JsonObject;
import java.time.Duration;
import java.util.List;
import java.util.regex.Pattern;
import net.replaceitem.reconfigure.api.Bindable;
import net.replaceitem.reconfigure.api.ConfigTab;
import net.replaceitem.reconfigure.api.Property;
import net.replaceitem.reconfigure.api.property.BooleanPropertyBuilder;
import net.replaceitem.reconfigure.api.property.EnumPropertyBuilder;
import net.replaceitem.reconfigure.api.property.IntPropertyBuilder;
import net.replaceitem.reconfigure.api.property.StringPropertyBuilder;
import net.replaceitem.reconfigure.api.serializer.JsonSerializerBuilder;
import net.replaceitem.reconfigure.api.serializer.Serializers;
import net.replaceitem.reconfigure.api.widget.CheckboxWidgetBuilder;
import net.replaceitem.reconfigure.api.widget.CyclingButtonWidgetBuilder;
import net.replaceitem.reconfigure.config.widget.builder.TextFieldWidgetBuilderImpl;

public class Config {
    public final net.replaceitem.reconfigure.api.Config config = net.replaceitem.reconfigure.api.Config.builder((String)"symbol-chat").serializer(((JsonSerializerBuilder)Serializers.buildJson().preLoad(Config::updateConfig)).build()).build();
    public final ConfigTab tab = this.config.createDefaultTab().build();
    private final Void general = this.tab.createHeadline("general");
    public final Property<Boolean> keepPanelOpen = this.tab.createBooleanProperty("keep_panel_open").asCheckbox().build();
    public final Property<Boolean> keepFontSelected = ((BooleanPropertyBuilder)this.tab.createBooleanProperty("keep_font_selected").defaultValue((Object)true)).asCheckbox().build();
    public final Property<String> favoriteSymbols = ((TextFieldWidgetBuilderImpl)this.tab.createStringProperty("favorite_symbols").asTextField().tooltip()).build();
    public final Property<List<String>> customKaomojis = this.tab.createListProperty("custom_kaomojis").asChipList().build();
    public final Property<Integer> maxSymbolSuggestions = ((IntPropertyBuilder)((IntPropertyBuilder)this.tab.createIntegerProperty("max_symbol_suggestions").defaultValue((Object)5)).range((Number)0, (Number)50)).asSlider().build();
    public final Property<SymbolTooltipMode> symbolTooltipMode = ((CyclingButtonWidgetBuilder)((EnumPropertyBuilder)this.tab.createEnumProperty("symbol_tooltip_mode", SymbolTooltipMode.class).defaultValue((Object)SymbolTooltipMode.DELAYED)).asCyclingButton().tooltip()).build();
    public final Property<String> chatSuggestionRegex = ((TextFieldWidgetBuilderImpl)((StringPropertyBuilder)this.tab.createStringProperty("chat_suggestion_regex").defaultValue((Object)"^(/(msg|tell|w|say|me|teammsg|tm) |[^/]).*")).asTextField().tooltip()).build();
    public final Property<String> fontConversionRegex = ((TextFieldWidgetBuilderImpl)((StringPropertyBuilder)this.tab.createStringProperty("font_conversion_regex").defaultValue((Object)"^[^/].*")).asTextField().tooltip()).build();
    private final Void hudLayoutHeadline = this.tab.createHeadline("hud_layout");
    public final Property<Boolean> hideFontButton = this.tab.createBooleanProperty("hide_font_button").asCheckbox().build();
    public final Property<Boolean> hideSettingsButton = ((CheckboxWidgetBuilder)this.tab.createBooleanProperty("hide_settings_button").asCheckbox().tooltip()).build();
    public final Property<Boolean> hideTableButton = ((CheckboxWidgetBuilder)this.tab.createBooleanProperty("hide_table_button").asCheckbox().tooltip()).build();
    public final Property<Integer> symbolPanelHeight = ((IntPropertyBuilder)((IntPropertyBuilder)this.tab.createIntegerProperty("symbol_panel_height").defaultValue((Object)200)).range((Number)100, (Number)500)).asSlider().build();
    public final Property<HudCorner> hudPosition = ((CyclingButtonWidgetBuilder)((EnumPropertyBuilder)this.tab.createEnumProperty("hud_position", HudCorner.class).defaultValue((Object)HudCorner.TOP_RIGHT)).asCyclingButton().tooltip()).build();
    public final Property<HudCorner> symbolButtonPosition = ((CyclingButtonWidgetBuilder)((EnumPropertyBuilder)this.tab.createEnumProperty("symbol_button_position", HudCorner.class).defaultValue((Object)HudCorner.BOTTOM_RIGHT)).asCyclingButton().tooltip()).build();
    private final Void colorsHeadline = this.tab.createHeadline("colors");
    public final Property<Integer> hudColor = ((IntPropertyBuilder)this.tab.createIntegerProperty("hud_color").defaultValue((Object)Integer.MIN_VALUE)).asColorPicker().build();
    public final Property<Integer> buttonColor = ((IntPropertyBuilder)this.tab.createIntegerProperty("button_color").defaultValue((Object)-1610612736)).asColorPicker().build();
    public final Property<Integer> buttonActiveColor = ((IntPropertyBuilder)this.tab.createIntegerProperty("button_active_color").defaultValue((Object)-1608507360)).asColorPicker().build();
    public final Property<Integer> favoriteColor = ((IntPropertyBuilder)this.tab.createIntegerProperty("favorite_color").defaultValue((Object)-256)).asColorPicker().build();
    public final Property<Integer> buttonTextColor = ((IntPropertyBuilder)this.tab.createIntegerProperty("button_text_color").defaultValue((Object)-6250336)).asColorPicker().build();
    public final Property<Integer> buttonTextHoverColor = ((IntPropertyBuilder)this.tab.createIntegerProperty("button_text_hover_color").defaultValue((Object)-1)).asColorPicker().build();
    private final Void unicodeTableHeadline = this.tab.createHeadline("unicode_table");
    public final Property<Boolean> unicodeTableShowBlocks = ((BooleanPropertyBuilder)this.tab.createBooleanProperty("unicode_table_show_blocks").defaultValue((Object)false)).asCheckbox().build();
    public final Property<Boolean> unicodeTableTextShadow = ((BooleanPropertyBuilder)this.tab.createBooleanProperty("unicode_table_text_shadow").defaultValue((Object)true)).asCheckbox().build();
    public final Property<Boolean> unicodeTableHideMissingGlyphs = ((BooleanPropertyBuilder)this.tab.createBooleanProperty("unicode_table_missing_glyphs").defaultValue((Object)false)).asCheckbox().build();
    public final Property<String> selectedFont = ((StringPropertyBuilder)this.tab.createStringProperty("selected_font").defaultValue((Object)"")).buildWithoutWidget();
    public final Bindable<Pattern> chatSuggestionPattern = this.chatSuggestionRegex.map(Pattern::compile);
    public final Bindable<Pattern> fontConversionPattern = this.fontConversionRegex.map(Pattern::compile);

    public void save() {
        this.config.save();
    }

    public void load() {
        this.config.load();
    }

    private static void updateConfig(JsonObject object) {
        if (object.has("custom_symbols") && !object.has("favorite_symbols")) {
            object.add("favorite_symbols", object.get("custom_symbols"));
        }
    }

    public static enum SymbolTooltipMode {
        OFF(Duration.ofSeconds(Integer.MAX_VALUE)),
        ON(Duration.ZERO),
        DELAYED(Duration.ofMillis(500L));

        private final Duration delay;

        public Duration getDelay() {
            return this.delay;
        }

        private SymbolTooltipMode(Duration delay) {
            this.delay = delay;
        }
    }

    public static enum HudCorner {
        TOP_LEFT(HudVerticalSide.TOP, HudSide.LEFT),
        TOP_RIGHT(HudVerticalSide.TOP, HudSide.RIGHT),
        BOTTOM_RIGHT(HudVerticalSide.BOTTOM, HudSide.RIGHT),
        BOTTOM_LEFT(HudVerticalSide.BOTTOM, HudSide.LEFT);

        private final HudVerticalSide vertical;
        private final HudSide horizontal;

        private HudCorner(HudVerticalSide vertical, HudSide horizontal) {
            this.horizontal = horizontal;
            this.vertical = vertical;
        }

        public HudVerticalSide getVertical() {
            return this.vertical;
        }

        public HudSide getHorizontal() {
            return this.horizontal;
        }
    }

    public static enum HudVerticalSide {
        TOP,
        BOTTOM;

    }

    public static enum HudSide {
        LEFT,
        RIGHT;

    }
}

