/*
 * Decompiled with CFR 0.152.
 */
package net.replaceitem.symbolchat;

import java.util.function.IntPredicate;
import java.util.function.IntUnaryOperator;
import java.util.stream.IntStream;
import net.minecraft.class_3532;
import net.replaceitem.symbolchat.Util;

public class UnicodeSearch {
    private final IntStream stream;

    private UnicodeSearch(IntStream stream) {
        this.stream = stream;
    }

    public static UnicodeSearch ofPage(int page) {
        int start = class_3532.method_15340((int)(page << 16), (int)0, (int)1114110);
        int end = class_3532.method_15340((int)(page + 1 << 16), (int)0, (int)1114110);
        return new UnicodeSearch(IntStream.range(start, end));
    }

    public static UnicodeSearch ofAll() {
        return new UnicodeSearch(IntStream.rangeClosed(0, 0x10FFFF));
    }

    public UnicodeSearch search(String searchTerm) {
        if (searchTerm.isBlank()) {
            return this;
        }
        return new UnicodeSearch(this.stream.filter(UnicodeSearch.getSearchFilter(searchTerm)));
    }

    public UnicodeSearch filterWidth(int width, IntUnaryOperator widthGetter) {
        return new UnicodeSearch(this.stream.filter(cp -> widthGetter.applyAsInt(cp) == width));
    }

    public UnicodeSearch filter(IntPredicate filter) {
        return new UnicodeSearch(this.stream.filter(filter));
    }

    public int[] collect() {
        return this.stream.toArray();
    }

    private static IntPredicate getSearchFilter(String searchTerm) {
        searchTerm = searchTerm.toLowerCase();
        String[] searchTerms = searchTerm.trim().split("\\s+");
        return cp -> UnicodeSearch.isRelevant(cp, searchTerms);
    }

    private static boolean isRelevant(int codepoint, String[] searchTerms) {
        String name = Util.getCodepointName(codepoint);
        for (String s : searchTerms) {
            if (name.contains(s)) continue;
            return false;
        }
        return true;
    }
}

