/*
 * Decompiled with CFR 0.152.
 */
package com.iamkaf.liteminer.tags;

import com.iamkaf.liteminer.Liteminer;
import com.iamkaf.liteminer.tags.LiteminerTags;
import dev.architectury.event.events.common.LifecycleEvent;
import java.util.Optional;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_6862;
import net.minecraft.class_6885;
import net.minecraft.class_7923;

public class TagHelper {
    private static boolean initialized = false;

    public static void init() {
        LifecycleEvent.SERVER_LEVEL_LOAD.register(TagHelper::report);
    }

    public static boolean isExcludedBlock(class_2680 block) {
        return TagHelper.isOr(block, LiteminerTags.Blocks.EXCLUDED_BLOCKS, LiteminerTags.Compat.EXCLUDED_BLOCKS);
    }

    public static boolean isWhitelistedBlock(class_2680 block) {
        return TagHelper.isOr(block, LiteminerTags.Blocks.BLOCK_WHITELIST, LiteminerTags.Compat.BLOCK_WHITELIST);
    }

    public static boolean isBlockWhitelistEnabled() {
        return TagHelper.isBlockTagPopulated(LiteminerTags.Blocks.BLOCK_WHITELIST) || TagHelper.isBlockTagPopulated(LiteminerTags.Compat.BLOCK_WHITELIST);
    }

    public static boolean isExcludedTool(class_1799 stack) {
        return TagHelper.isOr(stack, LiteminerTags.Items.EXCLUDED_TOOLS, LiteminerTags.Compat.EXCLUDED_TOOLS);
    }

    public static boolean isIncludedTool(class_1799 stack) {
        return TagHelper.isOr(stack, LiteminerTags.Items.INCLUDED_TOOLS, LiteminerTags.Compat.INCLUDED_TOOLS);
    }

    private static boolean isBlockTagPopulated(class_6862<class_2248> tag) {
        Optional optional = class_7923.field_41175.method_46733(tag);
        return optional.isPresent() && ((class_6885.class_6888)optional.get()).method_40247() > 0;
    }

    @SafeVarargs
    private static boolean isOr(class_2680 block, class_6862<class_2248> ... tags) {
        for (class_6862<class_2248> tag : tags) {
            if (!block.method_26164(tag)) continue;
            return true;
        }
        return false;
    }

    @SafeVarargs
    private static boolean isOr(class_1799 stack, class_6862<class_1792> ... tags) {
        for (class_6862<class_1792> tag : tags) {
            if (!stack.method_31573(tag)) continue;
            return true;
        }
        return false;
    }

    public static void report(class_3218 serverLevel) {
        if (initialized) {
            return;
        }
        initialized = true;
        Liteminer.LOGGER.info("Loading Liteminer Tags...");
        class_7923.field_41175.method_46733(LiteminerTags.Blocks.BLOCK_WHITELIST).ifPresent(holders -> Liteminer.LOGGER.info("Found " + holders.method_40247() + " blocks [" + String.valueOf(LiteminerTags.Blocks.BLOCK_WHITELIST.comp_327()) + "]"));
        class_7923.field_41175.method_46733(LiteminerTags.Blocks.EXCLUDED_BLOCKS).ifPresent(holders -> Liteminer.LOGGER.info("Found " + holders.method_40247() + " blocks [" + String.valueOf(LiteminerTags.Blocks.EXCLUDED_BLOCKS.comp_327()) + "]"));
        class_7923.field_41178.method_46733(LiteminerTags.Items.EXCLUDED_TOOLS).ifPresent(holders -> Liteminer.LOGGER.info("Found " + holders.method_40247() + " items [" + String.valueOf(LiteminerTags.Items.EXCLUDED_TOOLS.comp_327()) + "]"));
        class_7923.field_41178.method_46733(LiteminerTags.Items.INCLUDED_TOOLS).ifPresent(holders -> Liteminer.LOGGER.info("Found " + holders.method_40247() + " items [" + String.valueOf(LiteminerTags.Items.INCLUDED_TOOLS.comp_327()) + "]"));
    }
}

