/*
 * Decompiled with CFR 0.152.
 */
package com.iamkaf.liteminer;

import com.iamkaf.liteminer.Liteminer;
import com.iamkaf.liteminer.config.KeyMode;
import com.iamkaf.liteminer.config.LiteminerClientConfig;
import com.iamkaf.liteminer.networking.LiteminerNetwork;
import com.iamkaf.liteminer.rendering.HUD;
import com.iamkaf.liteminer.shapes.Cycler;
import com.iamkaf.liteminer.shapes.Walker;
import dev.architectury.event.events.client.ClientGuiEvent;
import dev.architectury.event.events.client.ClientRawInputEvent;
import dev.architectury.event.events.client.ClientTickEvent;
import dev.architectury.registry.client.keymappings.KeyMappingRegistry;
import java.util.HashSet;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class LiteminerClient {
    public static final int PACKET_DELAY = 125;
    public static final class_304 KEY_MAPPING = new class_304("key.liteminer.veinmine", class_3675.class_307.field_1668, 96, "key.categories.liteminer");
    public static final LiteminerClientConfig CONFIG;
    public static final ModConfigSpec CONFIG_SPEC;
    public static HashSet<class_2338> selectedBlocks;
    public static Cycler<Walker> shapes;
    private static boolean currentState;
    private static long lastChange;

    public static void init() {
        KeyMappingRegistry.register((class_304)KEY_MAPPING);
        ClientTickEvent.CLIENT_POST.register(LiteminerClient::onPostTick);
        ClientGuiEvent.RENDER_HUD.register(HUD::onRenderHUD);
        ClientRawInputEvent.MOUSE_SCROLLED.register(HUD::onMouseScroll);
    }

    public static void onPostTick(class_310 minecraft) {
        if (System.currentTimeMillis() - LiteminerClient.getLastChange() < 125L) {
            return;
        }
        switch ((KeyMode)((Object)LiteminerClient.CONFIG.keyMode.get())) {
            case HOLD: {
                boolean newState = KEY_MAPPING.method_1434();
                if (newState == LiteminerClient.isVeinMining()) {
                    return;
                }
                new LiteminerNetwork.Messages.C2SVeinmineKeybindChange(newState, shapes.getCurrentIndex()).sendToServer();
                currentState = newState;
                break;
            }
            case TOGGLE: {
                if (!KEY_MAPPING.method_1436()) break;
                boolean newState = !LiteminerClient.isVeinMining();
                new LiteminerNetwork.Messages.C2SVeinmineKeybindChange(newState, shapes.getCurrentIndex()).sendToServer();
                currentState = newState;
            }
        }
    }

    public static boolean isVeinMining() {
        return currentState;
    }

    public static long getLastChange() {
        return lastChange;
    }

    public static void setLastChange(long lastChange) {
        LiteminerClient.lastChange = lastChange;
    }

    public static boolean isTargetingABlock() {
        class_239 result = class_310.method_1551().field_1765;
        return result != null && result.method_17783() == class_239.class_240.field_1332;
    }

    static {
        selectedBlocks = HashSet.newHashSet(0);
        shapes = new Cycler<Walker>(Liteminer.WALKERS);
        currentState = false;
        lastChange = System.currentTimeMillis();
        Pair pair = new ModConfigSpec.Builder().configure(LiteminerClientConfig::new);
        CONFIG = (LiteminerClientConfig)pair.getLeft();
        CONFIG_SPEC = (ModConfigSpec)pair.getRight();
    }
}

