/*
 * Decompiled with CFR 0.152.
 */
package com.iamkaf.liteminer;

import com.iamkaf.liteminer.LiteminerPlayerState;
import com.iamkaf.liteminer.config.LiteminerConfig;
import com.iamkaf.liteminer.event.Events;
import com.iamkaf.liteminer.networking.LiteminerNetwork;
import com.iamkaf.liteminer.shapes.ShapelessWalker;
import com.iamkaf.liteminer.shapes.StaircaseDownWalker;
import com.iamkaf.liteminer.shapes.StaircaseUpWalker;
import com.iamkaf.liteminer.shapes.ThreeByThreeWalker;
import com.iamkaf.liteminer.shapes.TunnelWalker;
import com.iamkaf.liteminer.shapes.Walker;
import com.iamkaf.liteminer.tags.TagHelper;
import com.mojang.logging.LogUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;

public final class Liteminer {
    public static final String MOD_ID = "liteminer";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final LiteminerConfig CONFIG;
    public static final ModConfigSpec CONFIG_SPEC;
    public static final List<Walker> WALKERS;
    public static Liteminer instance;
    public Map<UUID, LiteminerPlayerState> playerStateMap = new HashMap<UUID, LiteminerPlayerState>();

    public Liteminer() {
        instance = this;
    }

    public static void init() {
        LOGGER.info("Litemining, from poppies to deepslate.");
        LiteminerNetwork.init();
        Events.init();
        TagHelper.init();
    }

    public static class_2960 resource(String path) {
        return class_2960.method_60655((String)MOD_ID, (String)path);
    }

    public static float getScaledBreakSpeedModifier(int blockCount) {
        float modifier = ((Double)Liteminer.CONFIG.harvestTimePerBlockModifier.get()).floatValue();
        float blockBreakLimit = ((Integer)Liteminer.CONFIG.blockBreakLimit.get()).floatValue();
        return 1.0f - (float)blockCount / blockBreakLimit * modifier * 0.1f * 0.95f;
    }

    public LiteminerPlayerState getPlayerState(class_3222 player) {
        return this.playerStateMap.computeIfAbsent(player.method_5667(), LiteminerPlayerState::new);
    }

    public void onKeymappingStateChange(class_3222 player, boolean keybindState, int shape) {
        LiteminerPlayerState playerState = this.getPlayerState(player);
        playerState.setKeymappingState(keybindState);
        playerState.setShape(shape);
    }

    public float onBreakSpeed(class_3222 player, float originalSpeed) {
        LiteminerPlayerState playerState = this.getPlayerState(player);
        boolean isVeinMining = playerState.getKeymappingState();
        if (isVeinMining) {
            class_3218 level = player.method_51469();
            int blockCount = WALKERS.get(playerState.getShape()).walk((class_1937)level, (class_1657)player, ShapelessWalker.raytrace((class_1937)level, (class_1657)player).method_17777()).size();
            return Liteminer.getScaledBreakSpeedModifier(blockCount);
        }
        return 1.0f;
    }

    static {
        WALKERS = List.of(new ShapelessWalker(), new TunnelWalker(), new StaircaseUpWalker(), new StaircaseDownWalker(), new ThreeByThreeWalker());
        Pair pair = new ModConfigSpec.Builder().configure(LiteminerConfig::new);
        CONFIG = (LiteminerConfig)pair.getLeft();
        CONFIG_SPEC = (ModConfigSpec)pair.getRight();
    }
}

