/*
 * Decompiled with CFR 0.152.
 */
package com.github.breadmoirai.oneclickcrafting.client;

import com.github.breadmoirai.oneclickcrafting.config.OneClickCraftingConfig;
import java.util.Map;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.screen.v1.ScreenEvents;
import net.fabricmc.fabric.api.client.screen.v1.ScreenKeyboardEvents;
import net.minecraft.class_10260;
import net.minecraft.class_10297;
import net.minecraft.class_10298;
import net.minecraft.class_10363;
import net.minecraft.class_1657;
import net.minecraft.class_1713;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import net.minecraft.class_437;
import net.minecraft.class_465;
import net.minecraft.class_479;
import net.minecraft.class_490;
import net.minecraft.class_507;
import net.minecraft.class_516;
import net.minecraft.class_638;
import net.minecraft.class_746;
import net.minecraft.class_8494;

@Environment(value=EnvType.CLIENT)
public class OneClickCraftingClient
implements ClientModInitializer {
    private static OneClickCraftingClient INSTANCE;
    public class_1799 lastCraft;
    private boolean isDropping;
    private boolean isShiftDropping;
    private boolean startedDropCrafting;
    private int lastButton;
    private OneClickCraftingConfig config;
    private class_304 toggleHoldKey;
    private class_304 repeatLastKey;

    public static OneClickCraftingClient getInstance() {
        return INSTANCE;
    }

    public void onInitializeClient() {
        INSTANCE = this;
        OneClickCraftingConfig.loadModConfig();
        this.config = OneClickCraftingConfig.getInstance();
        this.toggleHoldKey = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.oneclickcrafting.toggle_hold", class_3675.class_307.field_1668, class_3675.field_16237.method_1444(), "category.oneclickcrafting.keybindings"));
        this.repeatLastKey = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.oneclickcrafting.repeat_last", class_3675.class_307.field_1668, class_3675.field_16237.method_1444(), "category.oneclickcrafting.keybindings"));
        ScreenEvents.BEFORE_INIT.register((client, screen, scaledWidth, scaledHeight) -> {
            if (screen instanceof class_490 || screen instanceof class_479) {
                ScreenKeyboardEvents.afterKeyPress((class_437)screen).register((screen2, key, scancode, modifiers) -> {
                    class_10260 recipeBookScreen = (class_10260)screen;
                    class_507 recipeBook = ((class_10260)screen).field_54474;
                    if (this.isKeybindingPressed(this.repeatLastKey) && !class_8494.method_51255((int)key) && recipeBook.field_53833 != null && recipeBook.field_53832 != null) {
                        recipeBook.method_62889(recipeBook.field_53833, recipeBook.field_53832);
                    }
                });
                ScreenEvents.remove((class_437)screen).register(screen1 -> this.reset());
            }
        });
        this.reset();
    }

    public void setLastButton(int lastButton) {
        this.lastButton = lastButton;
    }

    public void recipeClicked(class_516 results, class_10298 recipe) {
        if (!this.isEnabled()) {
            this.reset();
            return;
        }
        this.isDropping = this.config.isDropEnable() && this.isDropPressed();
        this.isShiftDropping = this.isDropping && class_437.method_25442();
        class_310 client = class_310.method_1551();
        class_638 world = client.field_1687;
        if (world == null) {
            return;
        }
        class_746 player = client.field_1724;
        if (player == null) {
            return;
        }
        Map recipes = player.method_3130().field_54810;
        this.lastCraft = (class_1799)((class_10297)recipes.get(recipe)).comp_3263().comp_3258().method_64738(class_10363.method_65008((class_1937)world)).getFirst();
    }

    private void reset() {
        this.isDropping = false;
        this.isShiftDropping = false;
        this.lastCraft = null;
        this.startedDropCrafting = false;
        this.lastButton = -1;
    }

    private boolean isEnabled() {
        if (!this.isKeybindingPressed(this.repeatLastKey)) {
            if (this.lastButton == 0 && !this.config.isEnableLeftClick()) {
                return false;
            }
            if (this.lastButton == 1 && !this.config.isEnableRightClick()) {
                return false;
            }
            if (this.lastButton == -1) {
                return false;
            }
        }
        boolean alwaysOn = this.config.isAlwaysOn();
        if (this.config.isCtrlHold() && class_437.method_25441()) {
            return !alwaysOn;
        }
        if (this.config.isAltHold() && class_437.method_25443()) {
            return !alwaysOn;
        }
        if (!this.toggleHoldKey.method_1415() && this.isToggleHoldPressed()) {
            return !alwaysOn;
        }
        return alwaysOn;
    }

    private boolean isToggleHoldPressed() {
        return this.isKeybindingPressed(this.toggleHoldKey);
    }

    private boolean isDropPressed() {
        return this.isKeybindingPressed(class_310.method_1551().field_1690.field_1869);
    }

    private boolean isKeybindingPressed(class_304 keyBinding) {
        int code = keyBinding.field_1655.method_1444();
        if (code == class_3675.field_16237.method_1444()) {
            return false;
        }
        return class_3675.method_15987((long)class_310.method_1551().method_22683().method_4490(), (int)code);
    }

    public void onResultSlotUpdated(class_1799 itemStack) {
        if (this.lastCraft == null) {
            return;
        }
        if (itemStack.method_7909() == class_1802.field_8162) {
            if (this.startedDropCrafting) {
                this.reset();
            }
            return;
        }
        if (!class_1799.method_7984((class_1799)itemStack, (class_1799)this.lastCraft)) {
            return;
        }
        class_310 client = class_310.method_1551();
        if (client.field_1761 == null) {
            return;
        }
        if (!(client.field_1755 instanceof class_465)) {
            return;
        }
        int syncId = ((class_465)client.field_1755).method_17577().field_7763;
        if (this.isDropping) {
            client.field_1761.method_2906(syncId, 0, 0, class_1713.field_7795, (class_1657)client.field_1724);
            if (this.isShiftDropping) {
                this.startedDropCrafting = true;
                this.isShiftDropping = false;
            }
        } else {
            client.field_1761.method_2906(syncId, 0, 0, class_1713.field_7794, (class_1657)client.field_1724);
            this.lastCraft = null;
        }
    }
}

