/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.wormhole.targetdevice;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.supermartijn642.core.TextComponents;
import com.supermartijn642.core.item.BaseItem;
import com.supermartijn642.core.item.ItemProperties;
import com.supermartijn642.wormhole.Wormhole;
import com.supermartijn642.wormhole.WormholeClient;
import com.supermartijn642.wormhole.portal.PortalTarget;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1761;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_9331;

public class TargetDeviceItem
extends BaseItem {
    public static class_9331<List<PortalTarget>> TARGETS = class_9331.method_57873().method_57881(RecordCodecBuilder.create(instance -> instance.group((App)class_5321.method_39154((class_5321)class_7924.field_41223).fieldOf("dimension").forGetter(t -> t.dimension), (App)Codec.INT.fieldOf("x").forGetter(t -> t.x), (App)Codec.INT.fieldOf("y").forGetter(t -> t.y), (App)Codec.INT.fieldOf("z").forGetter(t -> t.z), (App)Codec.FLOAT.fieldOf("yaw").forGetter(t -> Float.valueOf(t.yaw)), (App)Codec.STRING.fieldOf("name").forGetter(t -> t.name), (App)class_1767.field_41600.optionalFieldOf("color").forGetter(t -> Optional.ofNullable(t.color))).apply((Applicative)instance, (dim, x, y, z, yaw, name, color) -> new PortalTarget((class_5321<class_1937>)dim, (int)x, (int)y, (int)z, yaw.floatValue(), (String)name, color.orElse(null)))).listOf()).method_57882(class_9139.method_56906((class_9139)class_5321.method_56038((class_5321)class_7924.field_41223), t -> t.dimension, (class_9139)class_2338.field_48404, t -> new class_2338(t.x, t.y, t.z), (class_9139)class_9135.field_48552, t -> Float.valueOf(t.yaw), (class_9139)class_9135.field_48554, t -> t.name, (class_9139)class_9135.method_56382((class_9139)class_1767.field_49259), t -> Optional.ofNullable(t.color), (dim, pos, yaw, name, color) -> new PortalTarget((class_5321<class_1937>)dim, pos.method_10263(), pos.method_10264(), pos.method_10260(), yaw.floatValue(), (String)name, color.orElse(null))).method_56433(class_9135.method_56363())).method_57880();
    private final Supplier<Integer> maxTargetCount;

    public TargetDeviceItem(Supplier<Integer> maxTargetCount) {
        super(ItemProperties.create().maxStackSize(1).group((class_1761)Wormhole.ITEM_GROUP));
        this.maxTargetCount = maxTargetCount;
    }

    public BaseItem.ItemUseResult interact(class_1799 stack, class_1657 player, class_1268 hand, class_1937 level) {
        if (level.field_9236) {
            WormholeClient.openTargetDeviceScreen(hand, player.method_24515(), Math.round(player.method_36454() / 90.0f) * 90);
        }
        return BaseItem.ItemUseResult.consume((class_1799)player.method_5998(hand));
    }

    protected void appendItemInformation(class_1799 stack, Consumer<class_2561> info, boolean advanced) {
        info.accept((class_2561)TextComponents.translation((String)"wormhole.target_device.info").color(class_124.field_1075).get());
        List<PortalTarget> targets = TargetDeviceItem.getTargets(stack);
        int capacity = TargetDeviceItem.getMaxTargetCount(stack);
        info.accept((class_2561)TextComponents.translation((String)"wormhole.target_device.info.targets", (Object[])new Object[]{targets.size(), capacity}).color(class_124.field_1054).get());
    }

    public static List<PortalTarget> getTargets(class_1799 stack) {
        return stack.method_57826(TARGETS) ? Collections.unmodifiableList((List)stack.method_58694(TARGETS)) : Collections.emptyList();
    }

    public static void setTargets(class_1799 stack, List<PortalTarget> targets) {
        if (targets == null || targets.isEmpty()) {
            stack.method_57381(TARGETS);
        } else {
            stack.method_57379(TARGETS, targets);
        }
    }

    public static void addTarget(class_1799 stack, PortalTarget target) {
        ArrayList<PortalTarget> list = new ArrayList<PortalTarget>(TargetDeviceItem.getTargets(stack));
        list.add(target);
        TargetDeviceItem.setTargets(stack, list);
    }

    public static void removeTarget(class_1799 stack, int index) {
        if (index < 0) {
            return;
        }
        List<PortalTarget> list = TargetDeviceItem.getTargets(stack);
        if (index >= list.size()) {
            return;
        }
        list = new ArrayList<PortalTarget>(list);
        list.remove(index);
        TargetDeviceItem.setTargets(stack, list);
    }

    public static void moveTarget(class_1799 stack, int index, boolean up) {
        if (index < 0) {
            return;
        }
        List<PortalTarget> list = TargetDeviceItem.getTargets(stack);
        if (index >= list.size()) {
            return;
        }
        if (up ? index == 0 : index == list.size() - 1) {
            return;
        }
        list = new ArrayList<PortalTarget>(list);
        PortalTarget target = list.remove(index);
        list.add(index + (up ? -1 : 1), target);
        TargetDeviceItem.setTargets(stack, list);
    }

    public static void changeTargetName(class_1799 stack, int index, String name) {
        if (index < 0) {
            return;
        }
        List<PortalTarget> list = TargetDeviceItem.getTargets(stack);
        if (index >= list.size()) {
            return;
        }
        list.get((int)index).name = name;
        TargetDeviceItem.setTargets(stack, list);
    }

    public static int getMaxTargetCount(class_1799 stack) {
        return stack.method_7909() instanceof TargetDeviceItem ? ((TargetDeviceItem)stack.method_7909()).maxTargetCount.get() : -1;
    }
}

