/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.wormhole.targetcell;

import com.supermartijn642.wormhole.portal.ITargetCellEntity;
import com.supermartijn642.wormhole.portal.PortalGroupBlockEntity;
import com.supermartijn642.wormhole.portal.PortalTarget;
import com.supermartijn642.wormhole.targetcell.TargetCellBlock;
import com.supermartijn642.wormhole.targetcell.TargetCellType;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_2338;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;

public class TargetCellBlockEntity
extends PortalGroupBlockEntity
implements ITargetCellEntity {
    public final TargetCellType type;
    private final List<PortalTarget> targets = new ArrayList<PortalTarget>();
    private int ticks = 20;

    public TargetCellBlockEntity(TargetCellType type, class_2338 pos, class_2680 state) {
        super((class_2591<?>)type.getBlockEntityType(), pos, state);
        this.type = type;
        for (int i = 0; i < type.getCapacity(); ++i) {
            this.targets.add(null);
        }
    }

    @Override
    public void update() {
        super.update();
        ++this.ticks;
        if (this.ticks >= 20) {
            int targetCount = Math.min(this.getNonNullTargetCount(), this.type.getVisualCapacity());
            if ((Integer)this.method_11010().method_11654((class_2769)TargetCellBlock.VISUAL_TARGETS) != targetCount) {
                this.field_11863.method_8501(this.field_11867, (class_2680)this.method_11010().method_11657((class_2769)TargetCellBlock.VISUAL_TARGETS, (Comparable)Integer.valueOf(targetCount)));
                this.ticks = 0;
            }
        }
    }

    @Override
    public int getTargetCapacity() {
        return this.type.getCapacity();
    }

    @Override
    public PortalTarget getTarget(int index) {
        return this.targets.get(index);
    }

    @Override
    public void setTarget(int index, PortalTarget target) {
        this.targets.set(index, target);
        this.dataChanged();
    }

    @Override
    public List<PortalTarget> getTargets() {
        return this.targets;
    }

    @Override
    public int getNonNullTargetCount() {
        int count = 0;
        for (PortalTarget target : this.targets) {
            if (target == null) continue;
            ++count;
        }
        return count;
    }

    @Override
    protected void writeData(class_11372 output) {
        super.writeData(output);
        class_11372 targetsTag = output.method_71461("targets");
        for (int i = 0; i < this.targets.size(); ++i) {
            if (this.targets.get(i) == null) continue;
            this.targets.get(i).write(targetsTag.method_71461("target" + i));
        }
    }

    @Override
    protected void readData(class_11368 input) {
        super.readData(input);
        this.targets.clear();
        class_11368 targetsTag = input.method_71434("targets");
        for (int i = 0; i < this.getTargetCapacity(); ++i) {
            this.targets.add(targetsTag.method_71420("target" + i).map(PortalTarget::read).orElse(null));
        }
    }

    public static class AdvancedTargetCellBlockEntity
    extends TargetCellBlockEntity {
        public AdvancedTargetCellBlockEntity(class_2338 pos, class_2680 state) {
            super(TargetCellType.ADVANCED, pos, state);
        }
    }

    public static class BasicTargetCellBlockEntity
    extends TargetCellBlockEntity {
        public BasicTargetCellBlockEntity(class_2338 pos, class_2680 state) {
            super(TargetCellType.BASIC, pos, state);
        }
    }
}

