/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.wormhole.portal.screen;

import com.supermartijn642.core.EnergyFormat;
import com.supermartijn642.core.TextComponents;
import com.supermartijn642.core.gui.GuiGraphicsHelper;
import com.supermartijn642.core.gui.widget.Widget;
import com.supermartijn642.core.gui.widget.WidgetRenderContext;
import com.supermartijn642.core.gui.widget.premade.ButtonWidget;
import com.supermartijn642.core.network.BasePacket;
import com.supermartijn642.wormhole.Wormhole;
import com.supermartijn642.wormhole.WormholeClient;
import com.supermartijn642.wormhole.portal.PortalGroup;
import com.supermartijn642.wormhole.portal.PortalTarget;
import com.supermartijn642.wormhole.portal.packets.PortalActivatePacket;
import com.supermartijn642.wormhole.portal.packets.PortalDeactivatePacket;
import com.supermartijn642.wormhole.portal.screen.PortalGroupScreen;
import com.supermartijn642.wormhole.portal.screen.PortalRendererHelper;
import com.supermartijn642.wormhole.portal.screen.ScreenBlockRenderer;
import com.supermartijn642.wormhole.screen.EnergyBarWidget;
import com.supermartijn642.wormhole.screen.WormholeColoredButton;
import java.util.function.Supplier;
import net.minecraft.class_124;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_5348;

public class PortalOverviewScreen
extends PortalGroupScreen {
    public static final class_2960 BACKGROUND = class_2960.method_60655((String)"wormhole", (String)"gui/portal_overview_screen");
    public static final class_2960 LOCATION_ICON = class_2960.method_60655((String)"wormhole", (String)"gui/select_target_screen/location_icon");
    public static final class_2960 ENERGY_ICON = class_2960.method_60655((String)"wormhole", (String)"gui/select_target_screen/lightning_icon");
    public static final class_2960 TELEPORT_ICON = class_2960.method_60655((String)"wormhole", (String)"gui/select_target_screen/teleport_icon");
    public static final class_2960 STAR_ICON = class_2960.method_60655((String)"wormhole", (String)"gui/select_target_screen/star_icon");
    public static final class_2960 DIMENSION_ICON = class_2960.method_60655((String)"wormhole", (String)"gui/select_target_screen/dimension_icon");
    public static final class_2960 CHECKMARK_ICON = class_2960.method_60655((String)"wormhole", (String)"gui/select_target_screen/checkmark_icon");
    public static final class_2960 CROSS_ICON = class_2960.method_60655((String)"wormhole", (String)"gui/select_target_screen/cross_icon");
    public static final class_2960 WARNING_ICON = class_2960.method_60655((String)"wormhole", (String)"gui/select_target_screen/warning_icon");
    public static final class_2960 SEPARATOR = class_2960.method_60655((String)"wormhole", (String)"gui/select_target_screen/separator");
    private static final int WIDTH = 280;
    private static final int HEIGHT = 185;
    private WormholeColoredButton activateButton;

    public PortalOverviewScreen(class_2338 pos) {
        super(280, 185, pos);
    }

    protected class_2561 getNarrationMessage(PortalGroup object) {
        return TextComponents.translation((String)"wormhole.portal.gui.title").get();
    }

    protected void addWidgets(PortalGroup group) {
        this.activateButton = (WormholeColoredButton)this.addWidget((Widget)new WormholeColoredButton(45, 159, 60, 15, (class_2561)TextComponents.empty().get(), () -> Wormhole.CHANNEL.sendToServer((BasePacket)(((PortalGroup)this.object).isActive() ? new PortalDeactivatePacket((PortalGroup)this.object) : new PortalActivatePacket((PortalGroup)this.object)))));
        Supplier<Integer> energy = () -> ((PortalGroup)this.object).getStoredEnergy();
        Supplier<Integer> capacity = () -> ((PortalGroup)this.object).getEnergyCapacity();
        this.addWidget((Widget)new EnergyBarWidget(244, 55, 30, 82, energy, capacity));
        this.addWidget((Widget)new ButtonWidget(151, 159, 82, 13, (class_2561)TextComponents.translation((String)"wormhole.portal.gui.change_target").get(), () -> WormholeClient.openPortalTargetScreen(this.pos)));
    }

    protected void update(PortalGroup group) {
        super.update((Object)((PortalGroup)this.object));
        this.activateButton.setText((class_2561)TextComponents.translation((String)(group.isActive() ? "wormhole.portal.gui.deactivate" : "wormhole.portal.gui.activate")).get());
        if (group.isActive()) {
            this.activateButton.setColorRed();
        } else {
            this.activateButton.setColorGreen();
        }
    }

    protected void renderBackground(WidgetRenderContext context, GuiGraphicsHelper graphics, int mouseX, int mouseY, PortalGroup object) {
        graphics.submitSprite(BACKGROUND, 0.0f, 0.0f, (float)this.width(), (float)this.height());
        super.renderBackground(context, graphics, mouseX, mouseY, (Object)object);
    }

    protected void render(WidgetRenderContext context, GuiGraphicsHelper graphics, int mouseX, int mouseY, PortalGroup group) {
        super.render(context, graphics, mouseX, mouseY, (Object)group);
        graphics.submitText((class_5348)TextComponents.translation((String)"wormhole.portal.gui.title").get(), 72.5f, 3.0f, p -> p.color(Integer.MAX_VALUE).centerHorizontally());
        PortalTarget target = group.getActiveTarget();
        this.renderInfo(graphics, group.getStoredEnergy(), group.getIdleEnergyCost(), group.getTeleportEnergyCost(), target);
    }

    private void renderInfo(GuiGraphicsHelper graphics, int storedEnergy, int idleCost, int teleportCost, PortalTarget target) {
        PortalStatus status = target == null ? PortalStatus.NO_TARGET : (storedEnergy == 0 ? PortalStatus.NO_ENERGY : (storedEnergy < idleCost ? PortalStatus.NOT_ENOUGH_ENERGY : PortalStatus.OK));
        graphics.submitText((class_5348)TextComponents.translation((String)"wormhole.portal.gui.information").get(), 192.0f, 31.0f, p -> p.color(Integer.MAX_VALUE).centerHorizontally());
        graphics.submitSprite(SEPARATOR, 154.0f, 41.0f, 77.0f, 1.0f);
        graphics.submitSprite(status.getIcon(), 151.0f, 47.0f, 9.0f, 9.0f);
        graphics.submitText((class_5348)status.getStatus(), 162.0f, 48.0f, p -> p.color(Integer.MAX_VALUE));
        graphics.submitSprite(ENERGY_ICON, 151.0f, 59.0f, 9.0f, 9.0f);
        graphics.submitText(EnergyFormat.formatEnergyPerTick((int)idleCost), 162.0f, 60.0f, p -> p.color(Integer.MAX_VALUE));
        graphics.submitSprite(TELEPORT_ICON, 150.0f, 70.0f, 11.0f, 11.0f);
        graphics.submitText(target == null ? "--" : EnergyFormat.formatEnergyWithUnit((int)teleportCost), 162.0f, 72.0f, p -> p.color(Integer.MAX_VALUE));
        graphics.submitSprite(SEPARATOR, 154.0f, 85.0f, 77.0f, 1.0f);
        graphics.submitSprite(STAR_ICON, 151.0f, 91.0f, 9.0f, 9.0f);
        graphics.submitText(target == null ? "--" : target.name, 162.0f, 92.0f, p -> p.color(Integer.MAX_VALUE));
        if (target != null) {
            graphics.submitSprite(LOCATION_ICON, 151.0f, 103.0f, 9.0f, 9.0f);
            graphics.submitText("(" + target.x + ", " + target.y + ", " + target.z + ")", 162.0f, 104.0f, p -> p.color(Integer.MAX_VALUE));
            Object block = target.dimension.equals((Object)class_1937.field_25179) ? class_2246.field_10194 : (target.dimension.equals((Object)class_1937.field_25180) ? class_2246.field_10515 : (target.dimension.equals((Object)class_1937.field_25181) ? class_2246.field_10471 : null));
            if (block == null) {
                graphics.submitSprite(DIMENSION_ICON, 151.0f, 115.0f, 9.0f, 9.0f);
            } else {
                graphics.submitCustomRendering(149, 113, 13, 13, arg_0 -> PortalOverviewScreen.lambda$renderInfo$11((class_2248)block, arg_0));
            }
            graphics.submitText((class_5348)target.getDimensionDisplayName(), 162.0f, 116.0f, p -> p.color(Integer.MAX_VALUE));
        }
    }

    protected void renderForeground(WidgetRenderContext context, GuiGraphicsHelper graphics, int mouseX, int mouseY, PortalGroup group) {
        super.renderForeground(context, graphics, mouseX, mouseY, (Object)group);
        graphics.submitCustomRendering(this.x + 8, this.y + 19, 132, 132, poseStack -> PortalRendererHelper.drawPortal(poseStack, group.shape, 0.0f, 0.0f, 132.0f, 132.0f));
    }

    protected void renderTooltips(WidgetRenderContext context, GuiGraphicsHelper graphics, int mouseX, int mouseY, PortalGroup group) {
        if (mouseX >= 150 && mouseX <= 161 && mouseY >= 46 && mouseY <= 57) {
            graphics.submitTooltipForTopStratum(c -> c.text(new class_2561[]{TextComponents.translation((String)"wormhole.portal.gui.status").get()}), (float)mouseX, (float)mouseY);
        } else if (mouseX >= 150 && mouseX <= 161 && mouseY >= 58 && mouseY <= 69) {
            graphics.submitTooltipForTopStratum(c -> c.text(new class_2561[]{TextComponents.translation((String)"wormhole.portal.gui.idle_cost").get()}), (float)mouseX, (float)mouseY);
        } else if (mouseX >= 150 && mouseX <= 161 && mouseY >= 70 && mouseY <= 81) {
            graphics.submitTooltipForTopStratum(c -> c.text(new class_2561[]{TextComponents.translation((String)"wormhole.portal.gui.teleport_cost").get()}), (float)mouseX, (float)mouseY);
        } else if (mouseX >= 150 && mouseX <= 161 && mouseY >= 90 && mouseY <= 101) {
            graphics.submitTooltipForTopStratum(c -> c.text(new class_2561[]{TextComponents.translation((String)"wormhole.portal.gui.target").get()}), (float)mouseX, (float)mouseY);
        } else if (mouseX >= 150 && mouseX <= 161 && mouseY >= 102 && mouseY <= 113) {
            graphics.submitTooltipForTopStratum(c -> c.text(new class_2561[]{TextComponents.translation((String)"wormhole.portal.gui.target_location").get()}), (float)mouseX, (float)mouseY);
        } else if (mouseX >= 150 && mouseX <= 161 && mouseY >= 114 && mouseY <= 125) {
            graphics.submitTooltipForTopStratum(c -> c.text(new class_2561[]{TextComponents.translation((String)"wormhole.portal.gui.target_dimension").get()}), (float)mouseX, (float)mouseY);
        }
        super.renderTooltips(context, graphics, mouseX, mouseY, (Object)group);
    }

    private static /* synthetic */ void lambda$renderInfo$11(class_2248 block, class_4587 poseStack) {
        ScreenBlockRenderer.drawBlock(poseStack, block, 6.5, 6.5, 5.5, 45.0f, 40.0f);
    }

    private static enum PortalStatus {
        OK("ok", class_124.field_1060, CHECKMARK_ICON),
        NOT_ENOUGH_ENERGY("not_enough_energy", class_124.field_1061, CROSS_ICON),
        NO_ENERGY("no_energy", class_124.field_1061, CROSS_ICON),
        NO_TARGET("no_target", class_124.field_1065, WARNING_ICON),
        NO_DIMENSIONAL_CORE("no_dimensional_core", class_124.field_1061, CROSS_ICON);

        private final String status;
        private final class_124 color;
        private final class_2960 icon;

        private PortalStatus(String status, class_124 color, class_2960 icon) {
            this.status = status;
            this.color = color;
            this.icon = icon;
        }

        public class_2561 getStatus() {
            return TextComponents.translation((String)("wormhole.portal.gui.status." + this.status)).color(this.color).get();
        }

        public class_2960 getIcon() {
            return this.icon;
        }
    }
}

