/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.wormhole.portal;

import com.google.common.collect.Lists;
import com.supermartijn642.wormhole.PortalBlock;
import com.supermartijn642.wormhole.StabilizerBlockEntity;
import com.supermartijn642.wormhole.Wormhole;
import com.supermartijn642.wormhole.WormholeConfig;
import com.supermartijn642.wormhole.portal.IEnergyCellEntity;
import com.supermartijn642.wormhole.portal.IPortalGroupEntity;
import com.supermartijn642.wormhole.portal.ITargetCellEntity;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.class_1767;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3612;

public class PortalShape {
    public static final Map<class_2350.class_2351, List<class_2338>> DIRECT_OFFSETS = new EnumMap<class_2350.class_2351, List<class_2338>>(class_2350.class_2351.class);
    private static final Map<class_2350.class_2351, List<class_2338>> INDIRECT_OFFSETS = new EnumMap<class_2350.class_2351, List<class_2338>>(class_2350.class_2351.class);
    private static final Map<class_2350.class_2351, List<class_2338>> ALL_OFFSETS = new EnumMap<class_2350.class_2351, List<class_2338>>(class_2350.class_2351.class);
    public final class_2350.class_2351 axis;
    public final List<class_2338> area = new ArrayList<class_2338>();
    public final List<class_2338> frame = new ArrayList<class_2338>();
    public final List<class_2338> stabilizers = new ArrayList<class_2338>();
    public final List<class_2338> energyCells = new ArrayList<class_2338>();
    public final List<class_2338> targetCells = new ArrayList<class_2338>();
    public final double span;
    public final class_2338 minCorner;
    public final class_2338 maxCorner;

    public static PortalShape find(class_1922 level, class_2338 center) {
        for (class_2350.class_2351 axis : class_2350.class_2351.values()) {
            PortalShape shape = PortalShape.find(level, center, axis);
            if (shape == null) continue;
            return shape;
        }
        return null;
    }

    private static PortalShape find(class_1922 level, class_2338 center, class_2350.class_2351 axis) {
        for (class_2338 offset : ALL_OFFSETS.get(axis)) {
            PortalShape shape;
            class_2248 offsetBlock = level.method_8320(center.method_10081((class_2382)offset)).method_26204();
            if (!offsetBlock.method_9564().method_26215() && offsetBlock != class_2246.field_10382 || (shape = PortalShape.findArea(level, center.method_10081((class_2382)offset), axis)) == null) continue;
            return shape;
        }
        return null;
    }

    private static PortalShape findArea(class_1922 level, class_2338 start, class_2350.class_2351 axis) {
        LinkedList<class_2338> next = new LinkedList<class_2338>();
        LinkedList<class_2338> current = new LinkedList<class_2338>();
        current.add(start);
        ArrayList<class_2338> done = new ArrayList<class_2338>();
        ArrayList<class_2338> frame = new ArrayList<class_2338>();
        ArrayList<class_2338> corners = new ArrayList<class_2338>();
        ArrayList<class_2338> stabilizers = new ArrayList<class_2338>();
        ArrayList<class_2338> energyCells = new ArrayList<class_2338>();
        ArrayList<class_2338> targetCells = new ArrayList<class_2338>();
        while (!current.isEmpty()) {
            for (class_2338 pos : current) {
                int frames = 0;
                for (class_2338 offset : DIRECT_OFFSETS.get(axis)) {
                    class_2338 offPos = pos.method_10081((class_2382)offset);
                    class_2680 state = level.method_8320(offPos);
                    class_2586 entity = level.method_8321(offPos);
                    if (state.method_26215() || state.method_26204() == class_2246.field_10382) {
                        if (done.contains(offPos) || current.contains(offPos) || next.contains(offPos)) continue;
                        next.add(offPos);
                        continue;
                    }
                    if (entity instanceof IPortalGroupEntity && !((IPortalGroupEntity)entity).hasGroup()) {
                        if (!frame.contains(offPos)) {
                            frame.add(offPos);
                            if (entity instanceof StabilizerBlockEntity) {
                                stabilizers.add(offPos);
                            }
                            if (entity instanceof IEnergyCellEntity) {
                                energyCells.add(offPos);
                            }
                            if (entity instanceof ITargetCellEntity) {
                                targetCells.add(offPos);
                            }
                        }
                        ++frames;
                        continue;
                    }
                    return null;
                }
                if (frames < 2) continue;
                corners.add(pos);
            }
            if (done.size() + current.size() + next.size() > WormholeConfig.maxPortalSize.get()) {
                return null;
            }
            done.addAll(current);
            current.clear();
            current.addAll(next);
            next.clear();
        }
        if (WormholeConfig.requireCorners.get().booleanValue()) {
            if (!PortalShape.validateCorners(level, done, frame, corners, stabilizers, energyCells, targetCells, axis)) {
                return null;
            }
        } else {
            PortalShape.collectCorners(level, done, frame, corners, stabilizers, energyCells, targetCells, axis);
        }
        if (stabilizers.size() == 0) {
            return null;
        }
        return new PortalShape(axis, done, frame, stabilizers, energyCells, targetCells);
    }

    private static void collectCorners(class_1922 level, List<class_2338> area, List<class_2338> frame, List<class_2338> corners, List<class_2338> stabilizers, List<class_2338> energyCells, List<class_2338> targetCells, class_2350.class_2351 axis) {
        class_2338 dir1pos = axis == class_2350.class_2351.field_11052 ? class_2338.field_10980.method_10078() : class_2338.field_10980.method_10084();
        class_2338 dir1neg = axis == class_2350.class_2351.field_11052 ? class_2338.field_10980.method_10067() : class_2338.field_10980.method_10074();
        class_2338 dir2pos = axis == class_2350.class_2351.field_11051 ? class_2338.field_10980.method_10078() : class_2338.field_10980.method_10095();
        class_2338 dir2neg = axis == class_2350.class_2351.field_11051 ? class_2338.field_10980.method_10067() : class_2338.field_10980.method_10072();
        for (class_2338 corner : corners) {
            PortalShape.collectCorner(level, area, frame, stabilizers, energyCells, targetCells, corner, dir1pos, dir2pos);
            PortalShape.collectCorner(level, area, frame, stabilizers, energyCells, targetCells, corner, dir1pos, dir2neg);
            PortalShape.collectCorner(level, area, frame, stabilizers, energyCells, targetCells, corner, dir1neg, dir2pos);
            PortalShape.collectCorner(level, area, frame, stabilizers, energyCells, targetCells, corner, dir1neg, dir2neg);
        }
    }

    private static boolean validateCorners(class_1922 level, List<class_2338> area, List<class_2338> frame, List<class_2338> corners, List<class_2338> stabilizers, List<class_2338> energyCells, List<class_2338> targetCells, class_2350.class_2351 axis) {
        class_2338 dir1pos = axis == class_2350.class_2351.field_11052 ? class_2338.field_10980.method_10078() : class_2338.field_10980.method_10084();
        class_2338 dir1neg = axis == class_2350.class_2351.field_11052 ? class_2338.field_10980.method_10067() : class_2338.field_10980.method_10074();
        class_2338 dir2pos = axis == class_2350.class_2351.field_11051 ? class_2338.field_10980.method_10078() : class_2338.field_10980.method_10095();
        class_2338 dir2neg = axis == class_2350.class_2351.field_11051 ? class_2338.field_10980.method_10067() : class_2338.field_10980.method_10072();
        for (class_2338 corner : corners) {
            if (!PortalShape.collectCorner(level, area, frame, stabilizers, energyCells, targetCells, corner, dir1pos, dir2pos)) {
                return false;
            }
            if (!PortalShape.collectCorner(level, area, frame, stabilizers, energyCells, targetCells, corner, dir1pos, dir2neg)) {
                return false;
            }
            if (!PortalShape.collectCorner(level, area, frame, stabilizers, energyCells, targetCells, corner, dir1neg, dir2pos)) {
                return false;
            }
            if (PortalShape.collectCorner(level, area, frame, stabilizers, energyCells, targetCells, corner, dir1neg, dir2neg)) continue;
            return false;
        }
        return true;
    }

    private static boolean collectCorner(class_1922 level, List<class_2338> area, List<class_2338> frame, List<class_2338> stabilizers, List<class_2338> energyCells, List<class_2338> targetCells, class_2338 corner, class_2338 dir1, class_2338 dir2) {
        if (frame.contains(corner.method_10081((class_2382)dir1)) && frame.contains(corner.method_10081((class_2382)dir2))) {
            class_2338 pos = corner.method_10081((class_2382)dir1).method_10081((class_2382)dir2);
            class_2586 entity = level.method_8321(pos);
            if (entity instanceof IPortalGroupEntity ? ((IPortalGroupEntity)entity).hasGroup() : !area.contains(pos)) {
                return false;
            }
            if (!frame.contains(pos)) {
                frame.add(pos);
                if (entity instanceof StabilizerBlockEntity) {
                    stabilizers.add(pos);
                }
                if (entity instanceof IEnergyCellEntity) {
                    energyCells.add(pos);
                }
                if (entity instanceof ITargetCellEntity) {
                    targetCells.add(pos);
                }
            }
        }
        return true;
    }

    public PortalShape(class_2350.class_2351 axis, List<class_2338> area, List<class_2338> frame, List<class_2338> stabilizers, List<class_2338> energyCells, List<class_2338> targetCells) {
        this.axis = axis;
        this.area.addAll(area);
        this.frame.addAll(frame);
        this.stabilizers.addAll(stabilizers);
        this.energyCells.addAll(energyCells);
        this.targetCells.addAll(targetCells);
        double span = 0.0;
        int minX = frame.get(0).method_10263();
        int minY = frame.get(0).method_10264();
        int minZ = frame.get(0).method_10260();
        int maxX = frame.get(0).method_10263();
        int maxY = frame.get(0).method_10264();
        int maxZ = frame.get(0).method_10260();
        for (int i = 0; i < frame.size(); ++i) {
            class_2338 pos1 = frame.get(i);
            for (int j = i + 1; j < frame.size(); ++j) {
                class_2338 pos2 = frame.get(j);
                double distance = pos1.method_10262((class_2382)pos2);
                if (!(distance > span)) continue;
                span = distance;
            }
            if (pos1.method_10263() < minX) {
                minX = pos1.method_10263();
            }
            if (pos1.method_10264() < minY) {
                minY = pos1.method_10264();
            }
            if (pos1.method_10260() < minZ) {
                minZ = pos1.method_10260();
            }
            if (pos1.method_10263() > maxX) {
                maxX = pos1.method_10263();
            }
            if (pos1.method_10264() > maxY) {
                maxY = pos1.method_10264();
            }
            if (pos1.method_10260() <= maxZ) continue;
            maxZ = pos1.method_10260();
        }
        this.span = Math.sqrt((maxX - minX + 1) * (maxX - minX + 1) + (maxY - minY + 1) * (maxY - minY + 1) + (maxZ - minZ + 1) * (maxZ - minZ + 1));
        this.minCorner = new class_2338(minX, minY, minZ);
        this.maxCorner = new class_2338(maxX, maxY, maxZ);
    }

    public PortalShape(class_2487 tag) {
        this.axis = tag.method_10558("axis").map(class_2350.class_2351::valueOf).or(() -> tag.method_10550("axis").filter(i -> i >= 0 && i < class_2350.class_2351.values().length).map(i -> class_2350.class_2351.values()[i])).orElse(class_2350.class_2351.field_11048);
        int[] area = tag.method_10561("area").orElseGet(() -> new int[0]);
        for (int i = 0; i < area.length / 3; ++i) {
            this.area.add(new class_2338(area[i * 3], area[i * 3 + 1], area[i * 3 + 2]));
        }
        int[] frame = tag.method_10561("frame").orElseGet(() -> new int[0]);
        for (int i = 0; i < frame.length / 3; ++i) {
            this.frame.add(new class_2338(frame[i * 3], frame[i * 3 + 1], frame[i * 3 + 2]));
        }
        int[] stabilizers = tag.method_10561("stabilizers").orElseGet(() -> new int[0]);
        for (int i = 0; i < stabilizers.length / 3; ++i) {
            this.stabilizers.add(new class_2338(stabilizers[i * 3], stabilizers[i * 3 + 1], stabilizers[i * 3 + 2]));
        }
        int[] energyCells = tag.method_10561("energyCells").orElseGet(() -> new int[0]);
        for (int i = 0; i < energyCells.length / 3; ++i) {
            this.energyCells.add(new class_2338(energyCells[i * 3], energyCells[i * 3 + 1], energyCells[i * 3 + 2]));
        }
        int[] targetCells = tag.method_10561("targetCells").orElseGet(() -> new int[0]);
        for (int i = 0; i < targetCells.length / 3; ++i) {
            this.targetCells.add(new class_2338(targetCells[i * 3], targetCells[i * 3 + 1], targetCells[i * 3 + 2]));
        }
        this.span = tag.method_68563("span", 1.0);
        this.minCorner = new class_2338(tag.method_68083("minCornerX", 0), tag.method_68083("minCornerY", 0), tag.method_68083("minCornerZ", 0));
        this.maxCorner = new class_2338(tag.method_68083("maxCornerX", 1), tag.method_68083("maxCornerY", 1), tag.method_68083("maxCornerZ", 1));
    }

    public void createPortals(class_1937 level, class_1767 color) {
        if (color == null) {
            color = class_1767.values()[new Random().nextInt(class_1767.values().length)];
        }
        for (class_2338 pos : this.area) {
            class_2680 state = level.method_8320(pos);
            if (state.method_26204() instanceof PortalBlock && state.method_11654(PortalBlock.AXIS_PROPERTY) == this.axis && state.method_11654(PortalBlock.COLOR_PROPERTY) == color) continue;
            boolean waterlogged = level.method_8316(pos).method_15772() == class_3612.field_15910;
            level.method_8501(pos, (class_2680)((class_2680)((class_2680)Wormhole.portal.method_9564().method_11657(PortalBlock.AXIS_PROPERTY, (Comparable)this.axis)).method_11657(PortalBlock.COLOR_PROPERTY, (Comparable)color)).method_11657((class_2769)PortalBlock.WATERLOGGED, (Comparable)Boolean.valueOf(waterlogged)));
        }
    }

    public void destroyPortals(class_1937 world) {
        for (class_2338 pos : this.area) {
            class_2680 state = world.method_8320(pos);
            if (!(state.method_26204() instanceof PortalBlock)) continue;
            if (((Boolean)state.method_11654((class_2769)PortalBlock.WATERLOGGED)).booleanValue()) {
                world.method_8501(pos, class_2246.field_10382.method_9564());
                continue;
            }
            world.method_8501(pos, class_2246.field_10124.method_9564());
        }
    }

    public boolean validateFrame(class_1922 world) {
        for (class_2338 pos : this.frame) {
            if (world.method_8320(pos).method_26204() instanceof IPortalGroupEntity) continue;
            return false;
        }
        return true;
    }

    public boolean validatePortal(class_1922 world) {
        for (class_2338 pos : this.area) {
            class_2680 state = world.method_8320(pos);
            if (state.method_26204() instanceof PortalBlock && state.method_11654(PortalBlock.AXIS_PROPERTY) == this.axis || state.method_26215() || state.method_26204() == class_2246.field_10382) continue;
            return false;
        }
        return true;
    }

    public class_2487 write() {
        class_2487 tag = new class_2487();
        tag.method_10569("axis", this.axis.ordinal());
        int[] areaData = new int[this.area.size() * 3];
        for (int i = 0; i < this.area.size(); ++i) {
            areaData[i * 3] = this.area.get(i).method_10263();
            areaData[i * 3 + 1] = this.area.get(i).method_10264();
            areaData[i * 3 + 2] = this.area.get(i).method_10260();
        }
        tag.method_10539("area", areaData);
        int[] frameData = new int[this.frame.size() * 3];
        for (int i = 0; i < this.frame.size(); ++i) {
            frameData[i * 3] = this.frame.get(i).method_10263();
            frameData[i * 3 + 1] = this.frame.get(i).method_10264();
            frameData[i * 3 + 2] = this.frame.get(i).method_10260();
        }
        tag.method_10539("frame", frameData);
        int[] stabilizersData = new int[this.stabilizers.size() * 3];
        for (int i = 0; i < this.stabilizers.size(); ++i) {
            stabilizersData[i * 3] = this.stabilizers.get(i).method_10263();
            stabilizersData[i * 3 + 1] = this.stabilizers.get(i).method_10264();
            stabilizersData[i * 3 + 2] = this.stabilizers.get(i).method_10260();
        }
        tag.method_10539("stabilizers", stabilizersData);
        int[] energyCellsData = new int[this.energyCells.size() * 3];
        for (int i = 0; i < this.energyCells.size(); ++i) {
            energyCellsData[i * 3] = this.energyCells.get(i).method_10263();
            energyCellsData[i * 3 + 1] = this.energyCells.get(i).method_10264();
            energyCellsData[i * 3 + 2] = this.energyCells.get(i).method_10260();
        }
        tag.method_10539("energyCells", energyCellsData);
        int[] targetCellsData = new int[this.targetCells.size() * 3];
        for (int i = 0; i < this.targetCells.size(); ++i) {
            targetCellsData[i * 3] = this.targetCells.get(i).method_10263();
            targetCellsData[i * 3 + 1] = this.targetCells.get(i).method_10264();
            targetCellsData[i * 3 + 2] = this.targetCells.get(i).method_10260();
        }
        tag.method_10539("targetCells", targetCellsData);
        tag.method_10549("span", this.span);
        tag.method_10569("minCornerX", this.minCorner.method_10263());
        tag.method_10569("minCornerY", this.minCorner.method_10264());
        tag.method_10569("minCornerZ", this.minCorner.method_10260());
        tag.method_10569("maxCornerX", this.maxCorner.method_10263());
        tag.method_10569("maxCornerY", this.maxCorner.method_10264());
        tag.method_10569("maxCornerZ", this.maxCorner.method_10260());
        return tag;
    }

    public static PortalShape read(class_2487 tag) {
        return new PortalShape(tag);
    }

    static {
        DIRECT_OFFSETS.put(class_2350.class_2351.field_11048, Lists.newArrayList((Object[])new class_2338[]{class_2338.field_10980.method_10084(), class_2338.field_10980.method_10074(), class_2338.field_10980.method_10095(), class_2338.field_10980.method_10072()}));
        DIRECT_OFFSETS.put(class_2350.class_2351.field_11052, Lists.newArrayList((Object[])new class_2338[]{class_2338.field_10980.method_10095(), class_2338.field_10980.method_10078(), class_2338.field_10980.method_10072(), class_2338.field_10980.method_10067()}));
        DIRECT_OFFSETS.put(class_2350.class_2351.field_11051, Lists.newArrayList((Object[])new class_2338[]{class_2338.field_10980.method_10084(), class_2338.field_10980.method_10074(), class_2338.field_10980.method_10078(), class_2338.field_10980.method_10067()}));
        INDIRECT_OFFSETS.put(class_2350.class_2351.field_11048, Lists.newArrayList((Object[])new class_2338[]{class_2338.field_10980.method_10084().method_10095(), class_2338.field_10980.method_10084().method_10072(), class_2338.field_10980.method_10074().method_10095(), class_2338.field_10980.method_10074().method_10072()}));
        INDIRECT_OFFSETS.put(class_2350.class_2351.field_11052, Lists.newArrayList((Object[])new class_2338[]{class_2338.field_10980.method_10095().method_10078(), class_2338.field_10980.method_10095().method_10067(), class_2338.field_10980.method_10072().method_10078(), class_2338.field_10980.method_10072().method_10067()}));
        INDIRECT_OFFSETS.put(class_2350.class_2351.field_11051, Lists.newArrayList((Object[])new class_2338[]{class_2338.field_10980.method_10084().method_10078(), class_2338.field_10980.method_10084().method_10067(), class_2338.field_10980.method_10074().method_10078(), class_2338.field_10980.method_10074().method_10067()}));
        for (class_2350.class_2351 axis : class_2350.class_2351.values()) {
            ArrayList pos = new ArrayList();
            pos.addAll(DIRECT_OFFSETS.get(axis));
            pos.addAll(INDIRECT_OFFSETS.get(axis));
            ALL_OFFSETS.put(axis, pos);
        }
    }
}

