/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.wormhole.portal;

import com.supermartijn642.wormhole.PortalGroupCapability;
import com.supermartijn642.wormhole.TeleportHelper;
import com.supermartijn642.wormhole.WormholeConfig;
import com.supermartijn642.wormhole.portal.IEnergyCellEntity;
import com.supermartijn642.wormhole.portal.ITargetCellEntity;
import com.supermartijn642.wormhole.portal.PortalShape;
import com.supermartijn642.wormhole.portal.PortalTarget;
import java.util.Iterator;
import net.minecraft.class_1297;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2586;

public class PortalGroup {
    public final PortalShape shape;
    public final class_1937 level;
    public boolean canTick = false;
    private int activeTarget = 0;
    private boolean activated;

    public PortalGroup(class_1937 level, PortalShape shape) {
        this.level = level;
        this.shape = shape;
    }

    public PortalGroup(class_1937 level, class_2487 tag) {
        this.level = level;
        this.shape = PortalShape.read(tag.method_68568("shape"));
        this.activeTarget = tag.method_68083("activeTarget", 0);
        this.activated = tag.method_68566("activated", false);
    }

    public void tick() {
        if (!this.canTick) {
            return;
        }
        this.canTick = false;
        if (this.activated && WormholeConfig.requirePower.get().booleanValue()) {
            if (this.getStoredEnergy() < this.getIdleEnergyCost()) {
                this.deactivate();
            } else {
                this.drainEnergy(this.getIdleEnergyCost());
            }
        }
    }

    public void setTarget(int index, PortalTarget target) {
        int total = 0;
        for (class_2338 pos : this.shape.targetCells) {
            class_2586 entity = this.level.method_8321(pos);
            if (!(entity instanceof ITargetCellEntity)) continue;
            int capacity = ((ITargetCellEntity)entity).getTargetCapacity();
            if (total + capacity > index) {
                ((ITargetCellEntity)entity).setTarget(index - total, target);
                break;
            }
            total += capacity;
        }
        if (this.activated && index == this.activeTarget) {
            if (target == null) {
                this.deactivate();
            } else {
                this.shape.createPortals(this.level, target.color);
            }
        }
    }

    public void clearTarget(int index) {
        this.setTarget(index, null);
    }

    public void moveTarget(int index, boolean up) {
        if (up ? index == 0 : index == this.getTotalTargetCapacity() - 1) {
            return;
        }
        int lowIndex = up ? index - 1 : index;
        int highIndex = up ? index : index + 1;
        ITargetCellEntity lowEntity = null;
        int lowEntityIndex = 0;
        ITargetCellEntity highEntity = null;
        int highEntityIndex = 0;
        int total = 0;
        for (class_2338 pos : this.shape.targetCells) {
            class_2586 entity = this.level.method_8321(pos);
            if (!(entity instanceof ITargetCellEntity)) continue;
            int capacity = ((ITargetCellEntity)entity).getTargetCapacity();
            if (lowEntity == null && total + capacity > lowIndex) {
                lowEntity = (ITargetCellEntity)entity;
                lowEntityIndex = lowIndex - total;
            }
            if (highEntity == null && total + capacity > highIndex) {
                highEntity = (ITargetCellEntity)entity;
                highEntityIndex = highIndex - total;
            }
            total += capacity;
        }
        if (lowEntity == null || highEntity == null) {
            return;
        }
        PortalTarget lowTarget = lowEntity.getTarget(lowEntityIndex);
        lowEntity.setTarget(lowEntityIndex, highEntity.getTarget(highEntityIndex));
        highEntity.setTarget(highEntityIndex, lowTarget);
        if (lowIndex == this.activeTarget) {
            ++this.activeTarget;
            this.updateGroup();
        } else if (highIndex == this.activeTarget) {
            --this.activeTarget;
            this.updateGroup();
        }
    }

    public void setActiveTarget(int index) {
        if (index != this.activeTarget) {
            this.activeTarget = index;
            if (this.activated) {
                PortalTarget target = this.getActiveTarget();
                if (target == null) {
                    this.deactivate();
                } else {
                    this.shape.createPortals(this.level, this.getActiveTarget().color);
                }
            }
            this.updateGroup();
        }
    }

    public PortalTarget getActiveTarget() {
        return this.getTarget(this.activeTarget);
    }

    public int getActiveTargetIndex() {
        return this.activeTarget;
    }

    public int getTotalTargetCapacity() {
        int total = 0;
        for (class_2338 pos : this.shape.targetCells) {
            class_2586 entity = this.level.method_8321(pos);
            if (!(entity instanceof ITargetCellEntity)) continue;
            total += ((ITargetCellEntity)entity).getTargetCapacity();
        }
        return total;
    }

    public PortalTarget getTarget(int index) {
        if (index < 0) {
            return null;
        }
        int total = 0;
        for (class_2338 pos : this.shape.targetCells) {
            class_2586 entity = this.level.method_8321(pos);
            if (!(entity instanceof ITargetCellEntity)) continue;
            int capacity = ((ITargetCellEntity)entity).getTargetCapacity();
            if (total + capacity > index) {
                return ((ITargetCellEntity)entity).getTarget(index - total);
            }
            total += capacity;
        }
        return null;
    }

    public boolean hasTargetSpaceLeft() {
        for (int i = 0; i < this.getTotalTargetCapacity(); ++i) {
            if (this.getTarget(i) != null) continue;
            return true;
        }
        return false;
    }

    public void addTarget(PortalTarget target) {
        for (int i = 0; i < this.getTotalTargetCapacity(); ++i) {
            if (this.getTarget(i) != null) continue;
            this.setTarget(i, target);
            return;
        }
    }

    public int getEnergyCapacity() {
        int total = 0;
        for (class_2338 pos : this.shape.energyCells) {
            class_2586 entity = this.level.method_8321(pos);
            if (!(entity instanceof IEnergyCellEntity)) continue;
            total += ((IEnergyCellEntity)entity).getMaxEnergyStored(true);
        }
        return total;
    }

    public int getStoredEnergy() {
        int total = 0;
        for (class_2338 pos : this.shape.energyCells) {
            class_2586 entity = this.level.method_8321(pos);
            if (!(entity instanceof IEnergyCellEntity)) continue;
            total += ((IEnergyCellEntity)entity).getEnergyStored(true);
        }
        return total;
    }

    public void drainEnergy(int energy) {
        for (class_2338 pos : this.shape.energyCells) {
            class_2586 entity = this.level.method_8321(pos);
            if (!(entity instanceof IEnergyCellEntity)) continue;
            energy -= ((IEnergyCellEntity)entity).extractEnergy(energy, false, true);
        }
    }

    public int receiveEnergy(int energy, boolean simulate) {
        class_2338 pos;
        class_2586 entity;
        int received = 0;
        Iterator<class_2338> iterator = this.shape.energyCells.iterator();
        while (iterator.hasNext() && (!((entity = this.level.method_8321(pos = iterator.next())) instanceof IEnergyCellEntity) || (received += ((IEnergyCellEntity)entity).receiveEnergy(energy - received, simulate, true)) < energy)) {
        }
        return received;
    }

    public void activate() {
        if (!(this.activated || this.getActiveTarget() == null || !this.shape.validatePortal((class_1922)this.level) || WormholeConfig.requirePower.get().booleanValue() && this.getStoredEnergy() < this.getIdleEnergyCost())) {
            this.shape.createPortals(this.level, this.getActiveTarget().color);
            this.activated = true;
            this.updateGroup();
        }
    }

    public void deactivate() {
        if (this.activated) {
            this.shape.destroyPortals(this.level);
            this.activated = false;
            this.updateGroup();
        }
    }

    public boolean isActive() {
        return this.activated;
    }

    public void teleport(class_1297 entity) {
        PortalTarget target = this.getActiveTarget();
        if (!this.activated || target == null || !TeleportHelper.canTeleport(entity, target)) {
            return;
        }
        if (WormholeConfig.requirePower.get().booleanValue()) {
            int cost;
            int energy = this.getStoredEnergy();
            if (energy < (cost = this.getTeleportEnergyCost())) {
                this.drainEnergy(energy);
                return;
            }
            this.drainEnergy(cost);
        }
        TeleportHelper.queTeleport(entity, target);
    }

    public int getTeleportEnergyCost() {
        PortalTarget target = this.getActiveTarget();
        if (target == null) {
            return 0;
        }
        return PortalGroup.getTeleportCostToTarget(this.level, this.getCenterPos(), target);
    }

    public int getIdleEnergyCost() {
        return WormholeConfig.idlePowerDrain.get() + (int)Math.round((double)this.shape.area.size() * WormholeConfig.sizePowerDrain.get());
    }

    public void destroy() {
        this.deactivate();
        PortalGroupCapability.get(this.level).remove(this);
    }

    public class_2487 write() {
        class_2487 tag = new class_2487();
        tag.method_10566("shape", (class_2520)this.shape.write());
        tag.method_10569("activeTarget", this.activeTarget);
        tag.method_10556("activated", this.activated);
        return tag;
    }

    private void updateGroup() {
        PortalGroupCapability.get(this.level).updateGroup(this);
    }

    public class_2338 getCenterPos() {
        return new class_2338((this.shape.minCorner.method_10263() + this.shape.maxCorner.method_10263()) / 2, (this.shape.minCorner.method_10264() + this.shape.maxCorner.method_10264()) / 2, (this.shape.minCorner.method_10260() + this.shape.maxCorner.method_10260()) / 2);
    }

    public static int getTeleportCostToTarget(class_1937 world, class_2338 portalCenter, PortalTarget target) {
        return WormholeConfig.travelPowerDrain.get() + (target.dimension.equals((Object)world.method_27983()) ? (int)Math.round(Math.pow(portalCenter.method_10262((class_2382)target.getPos()), 0.25) * WormholeConfig.distancePowerDrain.get()) : WormholeConfig.dimensionPowerDrain.get());
    }
}

