/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.wormhole.generator;

import com.mojang.serialization.Codec;
import com.supermartijn642.core.CommonUtils;
import com.supermartijn642.core.block.BaseBlockEntity;
import com.supermartijn642.core.block.BaseBlockEntityType;
import com.supermartijn642.core.block.TickableBlockEntity;
import com.supermartijn642.wormhole.energycell.EnergyHolder;
import com.supermartijn642.wormhole.portal.IPortalGroupEntity;
import com.supermartijn642.wormhole.portal.PortalGroup;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import team.reborn.energy.api.EnergyStorage;

public class GeneratorBlockEntity
extends BaseBlockEntity
implements TickableBlockEntity,
EnergyHolder {
    private static final int BLOCKS_PER_TICK = 5;
    protected int energy;
    protected final int energyCapacity;
    private final int energyRange;
    private final int energyTransferLimit;
    private final Set<class_2338> portalBlocks = new LinkedHashSet<class_2338>();
    private final HashMap<class_2338, class_2350> energyBlocks = new HashMap();
    private int searchX;
    private int searchY;
    private int searchZ;

    public GeneratorBlockEntity(BaseBlockEntityType<?> blockEntityType, class_2338 pos, class_2680 state, int energyCapacity, int energyRange, int energyTransferLimit) {
        super(blockEntityType, pos, state);
        this.energyCapacity = energyCapacity;
        this.energyRange = energyRange;
        this.energyTransferLimit = energyTransferLimit;
        this.searchY = this.searchZ = -energyRange;
        this.searchX = this.searchZ;
    }

    public void update() {
        if (!this.field_11863.field_9236) {
            for (int i = 0; i < 5; ++i) {
                class_2338 pos = this.field_11867.method_10069(this.searchX, this.searchY, this.searchZ);
                if (!pos.equals((Object)this.field_11867)) {
                    class_2586 entity = this.field_11863.method_8321(pos);
                    if (entity instanceof IPortalGroupEntity && ((IPortalGroupEntity)entity).hasGroup()) {
                        if (!this.portalBlocks.contains(pos) || this.energyBlocks.containsKey(pos)) {
                            this.portalBlocks.add(pos);
                            this.energyBlocks.remove(pos);
                            this.dataChanged();
                        }
                    } else {
                        boolean bl = entity instanceof EnergyHolder && ((EnergyHolder)entity).canReceive();
                        class_2350 inputSide = class_2350.field_11036;
                        if (!bl && entity != null && CommonUtils.isModLoaded((String)"team_reborn_energy")) {
                            class_2680 state = entity.method_11010();
                            for (class_2350 side : class_2350.values()) {
                                EnergyStorage storage = (EnergyStorage)EnergyStorage.SIDED.find(this.field_11863, pos, state, entity, (Object)side);
                                if (storage == null || !storage.supportsInsertion()) continue;
                                bl = true;
                                inputSide = side;
                                break;
                            }
                        }
                        if (bl && this.energyBlocks.get(pos) != inputSide) {
                            this.energyBlocks.put(pos, inputSide);
                            this.dataChanged();
                        } else if (!bl && this.energyBlocks.containsKey(pos)) {
                            this.energyBlocks.remove(pos);
                            this.dataChanged();
                        }
                        if (this.portalBlocks.contains(pos)) {
                            this.portalBlocks.remove(pos);
                            this.dataChanged();
                        }
                    }
                }
                ++this.searchX;
                if (this.searchX <= this.energyRange) continue;
                this.searchX = -this.energyRange;
                ++this.searchZ;
                if (this.searchZ <= this.energyRange) continue;
                this.searchZ = -this.energyRange;
                ++this.searchY;
                if (this.searchY <= this.energyRange) continue;
                this.searchY = -this.energyRange;
            }
            if (this.energy <= 0) {
                return;
            }
            int toTransfer = Math.min(this.energyTransferLimit, this.energy);
            HashSet<class_2338> toRemove = new HashSet<class_2338>();
            for (class_2338 class_23382 : this.portalBlocks) {
                class_2586 entity = this.field_11863.method_8321(class_23382);
                if (entity instanceof IPortalGroupEntity && ((IPortalGroupEntity)entity).hasGroup()) {
                    PortalGroup group = ((IPortalGroupEntity)entity).getGroup();
                    int transferred = group.receiveEnergy(toTransfer, false);
                    toTransfer -= transferred;
                    this.energy -= transferred;
                    this.dataChanged();
                    if (this.energy != 0) continue;
                    return;
                }
                toRemove.add(class_23382);
            }
            if (!toRemove.isEmpty()) {
                this.portalBlocks.removeAll(toRemove);
                toRemove.clear();
                this.dataChanged();
            }
            for (Map.Entry entry : this.energyBlocks.entrySet()) {
                class_2680 state;
                EnergyStorage storage;
                class_2338 pos = (class_2338)entry.getKey();
                class_2586 entity = this.field_11863.method_8321(pos);
                if (entity instanceof EnergyHolder) {
                    int transferred = ((EnergyHolder)entity).receiveEnergy(toTransfer, false);
                    toTransfer -= transferred;
                    this.energy -= transferred;
                    this.dataChanged();
                    if (this.energy != 0) continue;
                    return;
                }
                boolean isEnergyHolder = false;
                if (entity != null && CommonUtils.isModLoaded((String)"team_reborn_energy") && (storage = (EnergyStorage)EnergyStorage.SIDED.find(this.field_11863, pos, state = entity.method_11010(), entity, (Object)((class_2350)entry.getValue()))) != null && storage.supportsInsertion()) {
                    try (Transaction transaction = Transaction.openOuter();){
                        int transferred = (int)storage.insert((long)toTransfer, (TransactionContext)transaction);
                        this.energy -= transferred;
                        transaction.commit();
                        this.dataChanged();
                        if (this.energy == 0) {
                            return;
                        }
                    }
                    isEnergyHolder = true;
                }
                if (isEnergyHolder) continue;
                toRemove.add(pos);
            }
            if (!toRemove.isEmpty()) {
                toRemove.forEach(this.energyBlocks::remove);
                this.dataChanged();
            }
        }
    }

    public Set<class_2338> getChargingPortalBlocks() {
        return this.portalBlocks;
    }

    public Set<class_2338> getChargingEnergyBlocks() {
        return this.energyBlocks.keySet();
    }

    protected void writeData(class_11372 output) {
        output.method_71465("energy", this.energy);
        class_2338 self = this.field_11867;
        output.method_71465("searchX", this.searchX - self.method_10263());
        output.method_71465("searchY", this.searchY - self.method_10264());
        output.method_71465("searchZ", this.searchZ - self.method_10260());
        this.portalBlocks.stream().map(pos -> pos.method_10059((class_2382)self)).mapToLong(class_2338::method_10063).forEach(arg_0 -> ((class_11372.class_11373)output.method_71467("portalBlocks", (Codec)Codec.LONG)).method_71484(arg_0));
        int[] energyBlocks = new int[this.energyBlocks.size() * 4];
        int index = 0;
        for (Map.Entry<class_2338, class_2350> entry : this.energyBlocks.entrySet()) {
            energyBlocks[index++] = entry.getKey().method_10263() - self.method_10263();
            energyBlocks[index++] = entry.getKey().method_10264() - self.method_10264();
            energyBlocks[index++] = entry.getKey().method_10260() - self.method_10260();
            energyBlocks[index++] = entry.getValue().method_10146();
        }
        output.method_71473("energyBlocks", energyBlocks);
    }

    protected void writeItemStackData(class_11372 output) {
        super.writeItemStackData(output);
        output.method_71478("searchX");
        output.method_71478("searchY");
        output.method_71478("searchZ");
        output.method_71478("portalBlocks");
        output.method_71478("energyBlocks");
    }

    protected void readData(class_11368 input) {
        this.energy = input.method_71424("energy", 0);
        class_2338 self = this.field_11867;
        this.searchX = Math.min(Math.max(input.method_71424("searchX", 0) + self.method_10263(), -this.energyRange), this.energyRange);
        this.searchY = Math.min(Math.max(input.method_71424("searchY", 0) + self.method_10264(), -this.energyRange), this.energyRange);
        this.searchZ = Math.min(Math.max(input.method_71424("searchZ", 0) + self.method_10260(), -this.energyRange), this.energyRange);
        this.portalBlocks.clear();
        input.method_71437("portalBlocks", (Codec)Codec.LONG).method_71456().map(class_2338::method_10092).forEach(this.portalBlocks::add);
        this.energyBlocks.clear();
        int[] energyBlocks = input.method_71442("energyBlocks").orElseGet(() -> new int[0]);
        int i = 0;
        while (i < energyBlocks.length / 4 * 4) {
            this.energyBlocks.put(new class_2338(energyBlocks[i++] + self.method_10263(), energyBlocks[i++] + self.method_10264(), energyBlocks[i++] + self.method_10260()), class_2350.method_10143((int)energyBlocks[i++]));
        }
    }

    @Override
    public int receiveEnergy(int maxReceive, boolean simulate) {
        return 0;
    }

    @Override
    public int extractEnergy(int maxExtract, boolean simulate) {
        int extracted = Math.min(Math.min(this.energy, this.energyTransferLimit), maxExtract);
        if (extracted > 0 && !simulate) {
            this.energy -= extracted;
            this.dataChanged();
        }
        return Math.max(extracted, 0);
    }

    @Override
    public int getEnergyStored() {
        return this.energy;
    }

    @Override
    public void setEnergyStored(int energy) {
        this.energy = energy;
        this.dataChanged();
    }

    @Override
    public int getMaxEnergyStored() {
        return this.energyCapacity;
    }

    @Override
    public boolean canReceive() {
        return false;
    }
}

