/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.wormhole.generator;

import com.supermartijn642.wormhole.Wormhole;
import com.supermartijn642.wormhole.WormholeConfig;
import com.supermartijn642.wormhole.generator.CoalGeneratorBlock;
import com.supermartijn642.wormhole.generator.GeneratorBlockEntity;
import java.util.Map;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.item.base.SingleStackStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2769;

public class CoalGeneratorBlockEntity
extends GeneratorBlockEntity {
    private final Storage<ItemVariant> itemCapability = new SingleStackStorage(){

        protected boolean canInsert(ItemVariant itemVariant) {
            return CoalGeneratorBlockEntity.this.isItemValid(itemVariant.toStack());
        }

        protected boolean canExtract(ItemVariant itemVariant) {
            return false;
        }

        protected class_1799 getStack() {
            return CoalGeneratorBlockEntity.this.getStack();
        }

        protected void setStack(class_1799 stack) {
            CoalGeneratorBlockEntity.this.setStack(stack);
        }
    };
    private Map<class_1792, Integer> burnTimes;
    private int burnTime = 0;
    private int totalBurnTime = 0;
    private class_1799 stack = class_1799.field_8037;

    public CoalGeneratorBlockEntity(class_2338 pos, class_2680 state) {
        super(Wormhole.coal_generator_tile, pos, state, WormholeConfig.coalGeneratorCapacity.get(), WormholeConfig.coalGeneratorRange.get(), WormholeConfig.coalGeneratorPower.get() * 2);
    }

    @Override
    public void update() {
        super.update();
        if (this.energy < this.energyCapacity) {
            if (this.burnTime > 0) {
                --this.burnTime;
                this.energy += WormholeConfig.coalGeneratorPower.get().intValue();
                if (this.energy > this.energyCapacity) {
                    this.energy = this.energyCapacity;
                }
                if (this.burnTime == 0) {
                    this.totalBurnTime = 0;
                    this.burnItem();
                }
                this.dataChanged();
            } else {
                this.burnItem();
            }
        }
    }

    private void burnItem() {
        int burnTime;
        int n = burnTime = this.stack.method_7960() ? 0 : this.getBurnTime(this.stack);
        if (burnTime > 0) {
            this.burnTime = this.totalBurnTime = burnTime;
            if (this.stack.method_7947() == 1) {
                class_1799 remainder = this.stack.getRecipeRemainder();
                this.stack = remainder == null ? class_1799.field_8037 : remainder;
            } else {
                this.stack.method_7934(1);
            }
            this.dataChanged();
        }
        class_2680 state = this.field_11863.method_8320(this.field_11867);
        boolean lit = (Boolean)this.method_11010().method_11654((class_2769)CoalGeneratorBlock.LIT);
        if (lit != this.burnTime > 0) {
            this.field_11863.method_8501(this.field_11867, (class_2680)state.method_11657((class_2769)CoalGeneratorBlock.LIT, (Comparable)Boolean.valueOf(!lit)));
        }
    }

    public Storage<ItemVariant> getItemCapability() {
        return this.itemCapability;
    }

    @Override
    protected void writeData(class_11372 output) {
        super.writeData(output);
        output.method_71465("burnTime", this.burnTime);
        output.method_71465("totalBurnTime", this.totalBurnTime);
        if (!this.stack.method_7960()) {
            output.method_71468("stack", class_1799.field_24671, (Object)this.stack);
        }
    }

    @Override
    protected void readData(class_11368 input) {
        super.readData(input);
        this.burnTime = input.method_71424("burnTime", 0);
        this.totalBurnTime = input.method_71424("totalBurnTime", 0);
        this.stack = input.method_71426("stack", class_1799.field_24671).orElse(class_1799.field_8037);
    }

    public float getProgress() {
        return this.totalBurnTime == 0 ? 0.0f : (float)this.burnTime / (float)this.totalBurnTime;
    }

    public class_1799 getStack() {
        return this.stack;
    }

    public void setStack(class_1799 stack) {
        this.stack = stack;
        this.dataChanged();
    }

    public boolean isItemValid(class_1799 stack) {
        return this.getBurnTime(stack) > 0;
    }

    private int getBurnTime(class_1799 stack) {
        return (int)Math.floor((double)this.field_11863.method_61269().method_61755(stack) / 2.5);
    }
}

