/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.wormhole.energycell;

import com.supermartijn642.wormhole.energycell.EnergyHolder;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.fabricmc.fabric.api.transfer.v1.transaction.base.SnapshotParticipant;
import team.reborn.energy.api.EnergyStorage;

public class EnergyHolderEnergyStorageWrapper
extends SnapshotParticipant<Integer>
implements EnergyStorage {
    private final EnergyHolder holder;

    public EnergyHolderEnergyStorageWrapper(EnergyHolder holder) {
        this.holder = holder;
    }

    protected Integer createSnapshot() {
        return this.holder.getEnergyStored();
    }

    protected void readSnapshot(Integer snapshot) {
        this.holder.setEnergyStored(snapshot);
    }

    public boolean supportsInsertion() {
        return this.holder.canReceive();
    }

    public long insert(long maxAmount, TransactionContext transaction) {
        this.updateSnapshots(transaction);
        return this.holder.receiveEnergy((int)maxAmount, false);
    }

    public boolean supportsExtraction() {
        return this.holder.canExtract();
    }

    public long extract(long maxAmount, TransactionContext transaction) {
        this.updateSnapshots(transaction);
        return this.holder.extractEnergy((int)maxAmount, false);
    }

    public long getAmount() {
        return this.holder.getEnergyStored();
    }

    public long getCapacity() {
        return this.holder.getMaxEnergyStored();
    }
}

