/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.wormhole.energycell;

import com.supermartijn642.core.block.BaseBlockEntityType;
import com.supermartijn642.wormhole.Wormhole;
import com.supermartijn642.wormhole.WormholeConfig;
import com.supermartijn642.wormhole.energycell.EnergyCellBlock;
import com.supermartijn642.wormhole.energycell.EnergyCellBlockEntity;
import java.util.Locale;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.minecraft.class_2338;
import net.minecraft.class_2680;

public enum EnergyCellType {
    BASIC(WormholeConfig.basicEnergyCellCapacity, () -> Wormhole.basic_energy_cell, () -> Wormhole.basic_energy_cell_tile, EnergyCellBlockEntity.BasicEnergyCellBlockEntity::new),
    ADVANCED(WormholeConfig.advancedEnergyCellCapacity, () -> Wormhole.advanced_energy_cell, () -> Wormhole.advanced_energy_cell_tile, EnergyCellBlockEntity.AdvancedEnergyCellBlockEntity::new),
    CREATIVE(() -> 100000000, () -> Wormhole.creative_energy_cell, () -> Wormhole.creative_energy_cell_tile, EnergyCellBlockEntity.CreativeEnergyCellBlockEntity::new);

    private final Supplier<Integer> capacity;
    private final Supplier<EnergyCellBlock> block;
    private final Supplier<BaseBlockEntityType<? extends EnergyCellBlockEntity>> entityType;
    private final BiFunction<class_2338, class_2680, EnergyCellBlockEntity> entitySupplier;

    private EnergyCellType(Supplier<Integer> capacity, Supplier<EnergyCellBlock> block, Supplier<BaseBlockEntityType<? extends EnergyCellBlockEntity>> entityType, BiFunction<class_2338, class_2680, EnergyCellBlockEntity> entitySupplier) {
        this.capacity = capacity;
        this.block = block;
        this.entityType = entityType;
        this.entitySupplier = entitySupplier;
    }

    public String getRegistryName() {
        return this.name().toLowerCase(Locale.ROOT) + "_energy_cell";
    }

    public int getCapacity() {
        return this.capacity.get();
    }

    public EnergyCellBlockEntity createTile(class_2338 pos, class_2680 state) {
        return this.entitySupplier.apply(pos, state);
    }

    public EnergyCellBlock getBlock() {
        return this.block.get();
    }

    public BaseBlockEntityType<? extends EnergyCellBlockEntity> getBlockEntityType() {
        return this.entityType.get();
    }
}

