/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.wormhole.energycell;

import com.supermartijn642.core.CommonUtils;
import com.supermartijn642.wormhole.energycell.EnergyCellBlock;
import com.supermartijn642.wormhole.energycell.EnergyCellType;
import com.supermartijn642.wormhole.portal.IEnergyCellEntity;
import com.supermartijn642.wormhole.portal.PortalGroupBlockEntity;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import team.reborn.energy.api.EnergyStorage;

public class EnergyCellBlockEntity
extends PortalGroupBlockEntity
implements IEnergyCellEntity {
    protected final EnergyCellType type;
    protected int energy = 0;
    private int ticks = 40;

    public EnergyCellBlockEntity(EnergyCellType type, class_2338 pos, class_2680 state) {
        super((class_2591<?>)type.getBlockEntityType(), pos, state);
        this.type = type;
    }

    @Override
    public void update() {
        super.update();
        ++this.ticks;
        if (this.ticks >= 40) {
            int fillLevel;
            int maxEnergy = this.getMaxEnergyStored(true);
            int n = fillLevel = maxEnergy > 0 ? (int)Math.ceil((double)this.getEnergyStored(true) / (double)maxEnergy * 15.0) : 0;
            if ((Integer)this.method_11010().method_11654((class_2769)EnergyCellBlock.ENERGY_LEVEL) != fillLevel) {
                this.field_11863.method_8501(this.field_11867, (class_2680)this.method_11010().method_11657((class_2769)EnergyCellBlock.ENERGY_LEVEL, (Comparable)Integer.valueOf(fillLevel)));
                this.ticks = 0;
            }
        }
    }

    @Override
    public int receiveEnergy(int maxReceive, boolean simulate, boolean fromGroup) {
        if (!fromGroup && this.hasGroup()) {
            return this.getGroup().receiveEnergy(maxReceive, simulate);
        }
        if (maxReceive < 0) {
            return -this.extractEnergy(-maxReceive, simulate);
        }
        int absorb = Math.min(this.getMaxEnergyStored(true) - this.energy, maxReceive);
        if (!simulate) {
            this.energy += absorb;
            if (absorb > 0) {
                this.dataChanged();
            }
        }
        return absorb;
    }

    @Override
    public int extractEnergy(int maxExtract, boolean simulate, boolean fromGroup) {
        if (maxExtract < 0) {
            return -this.receiveEnergy(-maxExtract, simulate);
        }
        int drain = Math.min(this.energy, maxExtract);
        if (!simulate) {
            this.energy -= drain;
            if (drain > 0) {
                this.dataChanged();
            }
        }
        return drain;
    }

    @Override
    public int getEnergyStored(boolean fromGroup) {
        if (!fromGroup && this.hasGroup()) {
            return this.getGroup().getStoredEnergy();
        }
        return Math.min(this.energy, this.getMaxEnergyStored(true));
    }

    @Override
    public void setEnergyStored(int energy) {
        this.energy = energy;
    }

    @Override
    public int getMaxEnergyStored(boolean fromGroup) {
        if (!fromGroup && this.hasGroup()) {
            return this.getGroup().getEnergyCapacity();
        }
        return this.type.getCapacity();
    }

    @Override
    public boolean canExtract() {
        return false;
    }

    @Override
    public boolean canReceive() {
        return true;
    }

    @Override
    protected void writeData(class_11372 output) {
        super.writeData(output);
        output.method_71465("energy", this.energy);
    }

    @Override
    protected void readData(class_11368 input) {
        super.readData(input);
        this.energy = input.method_71424("energy", 0);
    }

    public static class CreativeEnergyCellBlockEntity
    extends EnergyCellBlockEntity {
        public CreativeEnergyCellBlockEntity(class_2338 pos, class_2680 state) {
            super(EnergyCellType.CREATIVE, pos, state);
        }

        @Override
        public int receiveEnergy(int maxReceive, boolean simulate, boolean fromGroup) {
            return 0;
        }

        @Override
        public int extractEnergy(int maxExtract, boolean simulate, boolean fromGroup) {
            return maxExtract;
        }

        @Override
        public int getEnergyStored(boolean fromGroup) {
            return this.getMaxEnergyStored();
        }

        @Override
        public void setEnergyStored(int energy) {
        }

        @Override
        public int getMaxEnergyStored(boolean fromGroup) {
            return this.type.getCapacity();
        }

        @Override
        public boolean canExtract() {
            return true;
        }

        @Override
        public void update() {
            super.update();
            if (CommonUtils.isModLoaded((String)"team_reborn_energy")) {
                for (class_2350 direction : class_2350.values()) {
                    EnergyStorage storage = (EnergyStorage)EnergyStorage.SIDED.find(this.field_11863, this.field_11867.method_10093(direction), (Object)direction.method_10153());
                    if (storage == null || !storage.supportsInsertion()) continue;
                    try (Transaction transaction = Transaction.openOuter();){
                        storage.insert((long)this.getMaxEnergyStored(true), (TransactionContext)transaction);
                    }
                }
            }
        }
    }

    public static class AdvancedEnergyCellBlockEntity
    extends EnergyCellBlockEntity {
        public AdvancedEnergyCellBlockEntity(class_2338 pos, class_2680 state) {
            super(EnergyCellType.ADVANCED, pos, state);
        }
    }

    public static class BasicEnergyCellBlockEntity
    extends EnergyCellBlockEntity {
        public BasicEnergyCellBlockEntity(class_2338 pos, class_2680 state) {
            super(EnergyCellType.BASIC, pos, state);
        }
    }
}

