/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.wormhole;

import com.supermartijn642.core.block.BaseBlock;
import com.supermartijn642.core.block.BaseBlockEntityType;
import com.supermartijn642.core.gui.BaseContainerType;
import com.supermartijn642.core.item.BaseBlockItem;
import com.supermartijn642.core.item.BaseItem;
import com.supermartijn642.core.item.CreativeItemGroup;
import com.supermartijn642.core.item.ItemProperties;
import com.supermartijn642.core.network.PacketChannel;
import com.supermartijn642.core.registry.GeneratorRegistrationHandler;
import com.supermartijn642.core.registry.RegistrationHandler;
import com.supermartijn642.core.registry.RegistryEntryAcceptor;
import com.supermartijn642.wormhole.NBTRecipe;
import com.supermartijn642.wormhole.PortalBlock;
import com.supermartijn642.wormhole.PortalBlockEntity;
import com.supermartijn642.wormhole.PortalGroupCapability;
import com.supermartijn642.wormhole.StabilizerBlock;
import com.supermartijn642.wormhole.StabilizerBlockEntity;
import com.supermartijn642.wormhole.WormholeAPIProviders;
import com.supermartijn642.wormhole.WormholeConfig;
import com.supermartijn642.wormhole.data.WormholeAtlasSourceGenerator;
import com.supermartijn642.wormhole.data.WormholeBlockStateGenerator;
import com.supermartijn642.wormhole.data.WormholeItemInfoGenerator;
import com.supermartijn642.wormhole.data.WormholeLanguageGenerator;
import com.supermartijn642.wormhole.data.WormholeLootTableGenerator;
import com.supermartijn642.wormhole.data.WormholeModelGenerator;
import com.supermartijn642.wormhole.data.WormholeRecipeGenerator;
import com.supermartijn642.wormhole.data.WormholeTagGenerator;
import com.supermartijn642.wormhole.energycell.EnergyCellBlock;
import com.supermartijn642.wormhole.energycell.EnergyCellBlockEntity;
import com.supermartijn642.wormhole.energycell.EnergyCellType;
import com.supermartijn642.wormhole.generator.CoalGeneratorBlock;
import com.supermartijn642.wormhole.generator.CoalGeneratorBlockEntity;
import com.supermartijn642.wormhole.generator.CoalGeneratorContainer;
import com.supermartijn642.wormhole.packet.UpdateGroupPacket;
import com.supermartijn642.wormhole.packet.UpdateGroupsPacket;
import com.supermartijn642.wormhole.portal.PortalGroupBlock;
import com.supermartijn642.wormhole.portal.PortalGroupBlockEntity;
import com.supermartijn642.wormhole.portal.packets.PortalActivatePacket;
import com.supermartijn642.wormhole.portal.packets.PortalAddTargetPacket;
import com.supermartijn642.wormhole.portal.packets.PortalClearTargetPacket;
import com.supermartijn642.wormhole.portal.packets.PortalColorTargetPacket;
import com.supermartijn642.wormhole.portal.packets.PortalDeactivatePacket;
import com.supermartijn642.wormhole.portal.packets.PortalMoveTargetPacket;
import com.supermartijn642.wormhole.portal.packets.PortalNameTargetPacket;
import com.supermartijn642.wormhole.portal.packets.PortalSelectTargetPacket;
import com.supermartijn642.wormhole.targetcell.TargetCellBlock;
import com.supermartijn642.wormhole.targetcell.TargetCellBlockEntity;
import com.supermartijn642.wormhole.targetcell.TargetCellType;
import com.supermartijn642.wormhole.targetdevice.TargetDeviceItem;
import com.supermartijn642.wormhole.targetdevice.packets.TargetDeviceAddPacket;
import com.supermartijn642.wormhole.targetdevice.packets.TargetDeviceMovePacket;
import com.supermartijn642.wormhole.targetdevice.packets.TargetDeviceNamePacket;
import com.supermartijn642.wormhole.targetdevice.packets.TargetDeviceRemovePacket;
import net.fabricmc.api.ModInitializer;
import net.minecraft.class_1657;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2591;
import net.minecraft.class_2680;

public class Wormhole
implements ModInitializer {
    public static final PacketChannel CHANNEL = PacketChannel.create((String)"wormhole");
    @RegistryEntryAcceptor(namespace="wormhole", identifier="portal_frame", registry=RegistryEntryAcceptor.Registry.BLOCKS)
    public static BaseBlock portal_frame;
    @RegistryEntryAcceptor(namespace="wormhole", identifier="portal", registry=RegistryEntryAcceptor.Registry.BLOCKS)
    public static BaseBlock portal;
    @RegistryEntryAcceptor(namespace="wormhole", identifier="portal_stabilizer", registry=RegistryEntryAcceptor.Registry.BLOCKS)
    public static BaseBlock portal_stabilizer;
    @RegistryEntryAcceptor(namespace="wormhole", identifier="basic_energy_cell", registry=RegistryEntryAcceptor.Registry.BLOCKS)
    public static EnergyCellBlock basic_energy_cell;
    @RegistryEntryAcceptor(namespace="wormhole", identifier="advanced_energy_cell", registry=RegistryEntryAcceptor.Registry.BLOCKS)
    public static EnergyCellBlock advanced_energy_cell;
    @RegistryEntryAcceptor(namespace="wormhole", identifier="creative_energy_cell", registry=RegistryEntryAcceptor.Registry.BLOCKS)
    public static EnergyCellBlock creative_energy_cell;
    @RegistryEntryAcceptor(namespace="wormhole", identifier="target_device", registry=RegistryEntryAcceptor.Registry.ITEMS)
    public static BaseItem target_device;
    @RegistryEntryAcceptor(namespace="wormhole", identifier="advanced_target_device", registry=RegistryEntryAcceptor.Registry.ITEMS)
    public static BaseItem advanced_target_device;
    @RegistryEntryAcceptor(namespace="wormhole", identifier="basic_target_cell", registry=RegistryEntryAcceptor.Registry.BLOCKS)
    public static TargetCellBlock basic_target_cell;
    @RegistryEntryAcceptor(namespace="wormhole", identifier="advanced_target_cell", registry=RegistryEntryAcceptor.Registry.BLOCKS)
    public static TargetCellBlock advanced_target_cell;
    @RegistryEntryAcceptor(namespace="wormhole", identifier="coal_generator", registry=RegistryEntryAcceptor.Registry.BLOCKS)
    public static CoalGeneratorBlock coal_generator;
    @RegistryEntryAcceptor(namespace="wormhole", identifier="portal_frame_tile", registry=RegistryEntryAcceptor.Registry.BLOCK_ENTITY_TYPES)
    public static BaseBlockEntityType<?> portal_frame_tile;
    @RegistryEntryAcceptor(namespace="wormhole", identifier="portal_tile", registry=RegistryEntryAcceptor.Registry.BLOCK_ENTITY_TYPES)
    public static BaseBlockEntityType<?> portal_tile;
    @RegistryEntryAcceptor(namespace="wormhole", identifier="stabilizer_tile", registry=RegistryEntryAcceptor.Registry.BLOCK_ENTITY_TYPES)
    public static BaseBlockEntityType<StabilizerBlockEntity> stabilizer_tile;
    @RegistryEntryAcceptor(namespace="wormhole", identifier="basic_energy_cell_tile", registry=RegistryEntryAcceptor.Registry.BLOCK_ENTITY_TYPES)
    public static BaseBlockEntityType<EnergyCellBlockEntity> basic_energy_cell_tile;
    @RegistryEntryAcceptor(namespace="wormhole", identifier="advanced_energy_cell_tile", registry=RegistryEntryAcceptor.Registry.BLOCK_ENTITY_TYPES)
    public static BaseBlockEntityType<EnergyCellBlockEntity> advanced_energy_cell_tile;
    @RegistryEntryAcceptor(namespace="wormhole", identifier="creative_energy_cell_tile", registry=RegistryEntryAcceptor.Registry.BLOCK_ENTITY_TYPES)
    public static BaseBlockEntityType<EnergyCellBlockEntity> creative_energy_cell_tile;
    @RegistryEntryAcceptor(namespace="wormhole", identifier="basic_target_cell_tile", registry=RegistryEntryAcceptor.Registry.BLOCK_ENTITY_TYPES)
    public static BaseBlockEntityType<TargetCellBlockEntity> basic_target_cell_tile;
    @RegistryEntryAcceptor(namespace="wormhole", identifier="advanced_target_cell_tile", registry=RegistryEntryAcceptor.Registry.BLOCK_ENTITY_TYPES)
    public static BaseBlockEntityType<TargetCellBlockEntity> advanced_target_cell_tile;
    @RegistryEntryAcceptor(namespace="wormhole", identifier="coal_generator_tile", registry=RegistryEntryAcceptor.Registry.BLOCK_ENTITY_TYPES)
    public static BaseBlockEntityType<CoalGeneratorBlockEntity> coal_generator_tile;
    @RegistryEntryAcceptor(namespace="wormhole", identifier="coal_generator_container", registry=RegistryEntryAcceptor.Registry.MENU_TYPES)
    public static BaseContainerType<CoalGeneratorContainer> coal_generator_container;
    public static final CreativeItemGroup ITEM_GROUP;

    public void onInitialize() {
        CHANNEL.registerMessage(TargetDeviceAddPacket.class, TargetDeviceAddPacket::new, true);
        CHANNEL.registerMessage(TargetDeviceMovePacket.class, TargetDeviceMovePacket::new, true);
        CHANNEL.registerMessage(TargetDeviceRemovePacket.class, TargetDeviceRemovePacket::new, true);
        CHANNEL.registerMessage(TargetDeviceNamePacket.class, TargetDeviceNamePacket::new, true);
        CHANNEL.registerMessage(PortalAddTargetPacket.class, PortalAddTargetPacket::new, true);
        CHANNEL.registerMessage(PortalClearTargetPacket.class, PortalClearTargetPacket::new, true);
        CHANNEL.registerMessage(PortalMoveTargetPacket.class, PortalMoveTargetPacket::new, true);
        CHANNEL.registerMessage(PortalNameTargetPacket.class, PortalNameTargetPacket::new, true);
        CHANNEL.registerMessage(PortalSelectTargetPacket.class, PortalSelectTargetPacket::new, true);
        CHANNEL.registerMessage(UpdateGroupPacket.class, UpdateGroupPacket::new, true);
        CHANNEL.registerMessage(UpdateGroupsPacket.class, UpdateGroupsPacket::new, true);
        CHANNEL.registerMessage(PortalColorTargetPacket.class, PortalColorTargetPacket::new, true);
        CHANNEL.registerMessage(PortalActivatePacket.class, PortalActivatePacket::new, true);
        CHANNEL.registerMessage(PortalDeactivatePacket.class, PortalDeactivatePacket::new, true);
        PortalGroupCapability.registerListeners();
        Wormhole.register();
        Wormhole.registerGenerators();
    }

    private static void register() {
        RegistrationHandler handler = RegistrationHandler.get((String)"wormhole");
        handler.registerBlock("portal_frame", () -> new PortalGroupBlock(() -> portal_frame_tile));
        handler.registerBlockEntityType("portal_frame_tile", () -> BaseBlockEntityType.create((pos, state) -> new PortalGroupBlockEntity((class_2591<?>)portal_frame_tile, (class_2338)pos, (class_2680)state), (class_2248[])new class_2248[]{portal_frame}));
        handler.registerItem("portal_frame", () -> new BaseBlockItem((class_2248)portal_frame, ItemProperties.create().group((class_1761)ITEM_GROUP)));
        handler.registerBlock("portal", PortalBlock::new);
        handler.registerBlockEntityType("portal_tile", () -> BaseBlockEntityType.create(PortalBlockEntity::new, (class_2248[])new class_2248[]{portal}));
        handler.registerItem("portal", () -> new BaseBlockItem((class_2248)portal, ItemProperties.create()));
        handler.registerBlock("portal_stabilizer", StabilizerBlock::new);
        handler.registerBlockEntityType("stabilizer_tile", () -> BaseBlockEntityType.create(StabilizerBlockEntity::new, (class_2248[])new class_2248[]{portal_stabilizer}));
        handler.registerItem("portal_stabilizer", () -> new BaseBlockItem((class_2248)portal_stabilizer, ItemProperties.create().group((class_1761)ITEM_GROUP)));
        for (EnergyCellType energyCellType : EnergyCellType.values()) {
            handler.registerBlock(energyCellType.getRegistryName(), () -> new EnergyCellBlock(energyCellType));
            handler.registerBlockEntityType(energyCellType.getRegistryName() + "_tile", () -> BaseBlockEntityType.create(energyCellType::createTile, (class_2248[])new class_2248[]{energyCellType.getBlock()}));
            handler.registerItem(energyCellType.getRegistryName(), () -> new BaseBlockItem((class_2248)energyCellType.getBlock(), ItemProperties.create().group((class_1761)ITEM_GROUP)));
        }
        for (Enum enum_ : TargetCellType.values()) {
            handler.registerBlock(((TargetCellType)enum_).getRegistryName(), () -> Wormhole.lambda$register$13((TargetCellType)enum_));
            handler.registerBlockEntityType(((TargetCellType)enum_).getRegistryName() + "_tile", () -> Wormhole.lambda$register$14((TargetCellType)enum_));
            handler.registerItem(((TargetCellType)enum_).getRegistryName(), () -> Wormhole.lambda$register$15((TargetCellType)enum_));
        }
        handler.registerBlock("coal_generator", CoalGeneratorBlock::new);
        handler.registerBlockEntityType("coal_generator_tile", () -> BaseBlockEntityType.create(CoalGeneratorBlockEntity::new, (class_2248[])new class_2248[]{coal_generator}));
        handler.registerItem("coal_generator", () -> new BaseBlockItem((class_2248)coal_generator, ItemProperties.create().group((class_1761)ITEM_GROUP)));
        handler.registerMenuType("coal_generator_container", () -> BaseContainerType.create((container, data) -> data.method_10807(container.getBlockEntityPos()), (player, data) -> new CoalGeneratorContainer((class_1657)player, data.method_10811())));
        handler.registerItem("target_device", () -> new TargetDeviceItem(WormholeConfig.basicDeviceTargetCount));
        handler.registerItem("advanced_target_device", () -> new TargetDeviceItem(WormholeConfig.advancedDeviceTargetCount));
        handler.registerDataComponentType("target_device_targets", TargetDeviceItem.TARGETS);
        handler.registerRecipeSerializer("nbtrecipe", NBTRecipe.SERIALIZER);
        handler.registerBlockEntityTypeCallback(helper -> WormholeAPIProviders.registerAPIProviders());
    }

    private static void registerGenerators() {
        GeneratorRegistrationHandler handler = GeneratorRegistrationHandler.get((String)"wormhole");
        handler.addGenerator(WormholeModelGenerator::new);
        handler.addGenerator(WormholeBlockStateGenerator::new);
        handler.addGenerator(WormholeLanguageGenerator::new);
        handler.addGenerator(WormholeLootTableGenerator::new);
        handler.addGenerator(WormholeRecipeGenerator::new);
        handler.addGenerator(WormholeTagGenerator::new);
        handler.addGenerator(WormholeAtlasSourceGenerator::new);
        handler.addGenerator(WormholeItemInfoGenerator::new);
    }

    private static /* synthetic */ class_1792 lambda$register$15(TargetCellType type) {
        return new BaseBlockItem((class_2248)type.getBlock(), ItemProperties.create().group((class_1761)ITEM_GROUP));
    }

    private static /* synthetic */ class_2591 lambda$register$14(TargetCellType type) {
        return BaseBlockEntityType.create(type::createTile, (class_2248[])new class_2248[]{type.getBlock()});
    }

    private static /* synthetic */ class_2248 lambda$register$13(TargetCellType type) {
        return new TargetCellBlock(type);
    }

    static {
        ITEM_GROUP = CreativeItemGroup.create((String)"wormhole", () -> advanced_target_device).sortAlphabetically();
    }
}

