/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.wormhole;

import com.supermartijn642.wormhole.portal.PortalTarget;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2596;
import net.minecraft.class_2632;
import net.minecraft.class_2696;
import net.minecraft.class_2724;
import net.minecraft.class_2752;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3324;
import net.minecraft.class_3730;
import net.minecraft.class_3738;
import net.minecraft.class_5217;

public class TeleportHelper {
    private static final int TELEPORT_COOLDOWN = 40;

    public static boolean queTeleport(class_1297 entity, PortalTarget target) {
        if (!TeleportHelper.canTeleport(entity, target)) {
            return false;
        }
        for (class_1297 passenger : entity.method_5736()) {
            if (!(passenger instanceof class_1657)) continue;
            return false;
        }
        class_1297 lowestEntity = entity.method_5668();
        if (!entity.method_37908().field_9236) {
            lowestEntity.method_37908().method_8503().method_63588((Runnable)new class_3738(0, () -> TeleportHelper.teleportEntityAndPassengers(lowestEntity, null, target)));
            TeleportHelper.markEntityAndPassengers(lowestEntity);
        }
        return true;
    }

    public static boolean canTeleport(class_1297 entity, PortalTarget target) {
        if (entity.method_37908().field_9236 || !target.getLevel(entity.method_5682()).isPresent()) {
            return false;
        }
        if (entity.method_5765()) {
            return TeleportHelper.canTeleport(entity.method_5668(), target);
        }
        for (class_1297 rider : entity.method_5736()) {
            if (!rider.method_30230()) continue;
            return false;
        }
        return !entity.method_30230();
    }

    private static void markEntityAndPassengers(class_1297 entity) {
        entity.field_6018 = 40;
        entity.method_5685().forEach(TeleportHelper::markEntityAndPassengers);
    }

    private static void teleportEntityAndPassengers(class_1297 entity, class_1297 entityBeingRidden, PortalTarget target) {
        if (entity.method_37908().field_9236 || !target.getLevel(entity.method_5682()).isPresent()) {
            return;
        }
        Optional<class_3218> targetLevel = target.getLevel(entity.method_5682()).filter(class_3218.class::isInstance).map(class_3218.class::cast);
        if (!targetLevel.isPresent()) {
            return;
        }
        List passengers = entity.method_5685();
        entity.method_5772();
        class_1297 newEntity = TeleportHelper.teleportEntity(entity, targetLevel.get(), target);
        if (entityBeingRidden != null) {
            newEntity.method_5804(entityBeingRidden);
            if (newEntity instanceof class_3222) {
                ((class_3222)newEntity).field_13987.method_14364((class_2596)new class_2752(entityBeingRidden));
            }
        }
        passengers.forEach(e -> TeleportHelper.teleportEntityAndPassengers(e, newEntity, target));
    }

    private static class_1297 teleportEntity(class_1297 entity, class_3218 targetLevel, PortalTarget target) {
        if (targetLevel == entity.method_37908()) {
            if (entity instanceof class_3222) {
                entity.method_48105(targetLevel, (double)target.x + 0.5, (double)target.y + 0.1, (double)target.z + 0.5, Set.of(), target.yaw, 0.0f, true);
            } else {
                entity.method_5859((double)target.x + 0.5, (double)target.y + 0.1, (double)target.z + 0.5);
            }
            entity.method_5847(target.yaw);
            entity.method_18799(class_243.field_1353);
            entity.field_6017 = 0.0;
            entity.method_24830(true);
        } else if (entity instanceof class_3222) {
            class_3222 player = (class_3222)entity;
            player.field_13985 = true;
            class_5217 levelData = targetLevel.method_8401();
            player.field_13987.method_14364((class_2596)new class_2724(player.method_52374(targetLevel), 3));
            player.field_13987.method_14364((class_2596)new class_2632(levelData.method_207(), levelData.method_197()));
            class_3324 playerList = player.method_5682().method_3760();
            playerList.method_14576(player);
            class_3218 oldLevel = player.method_51469();
            oldLevel.method_18770(player, class_1297.class_5529.field_27002);
            player.method_31482();
            if (targetLevel.method_27983() == class_1937.field_25180) {
                player.field_13994 = new class_243((double)target.x + 0.5, (double)target.y + 0.1, (double)target.z + 0.5);
            }
            player.method_51468(targetLevel);
            player.field_13987.method_14363((double)target.x + 0.5, (double)target.y + 0.1, (double)target.z + 0.5, target.yaw, 0.0f);
            player.field_13987.method_14372();
            targetLevel.method_18769((class_1297)player);
            player.method_18783(oldLevel);
            player.field_13987.method_14364((class_2596)new class_2696(player.method_31549()));
            playerList.method_14606(player, targetLevel);
            playerList.method_14594(player);
            playerList.method_60598(player);
            player.field_13978 = -1;
            player.field_13997 = -1.0f;
            player.field_13979 = -1;
        } else {
            class_1297 newEntity = entity.method_5864().method_5883((class_1937)targetLevel, class_3730.field_52445);
            if (newEntity != null) {
                newEntity.method_5878(entity);
                newEntity.method_5808((double)target.x + 0.5, (double)target.y + 0.1, (double)target.z + 0.5, target.yaw, 0.0f);
                newEntity.method_5847(target.yaw);
                newEntity.method_18799(class_243.field_1353);
                newEntity.field_6017 = 0.0;
                newEntity.method_24830(true);
                entity.method_31745(class_1297.class_5529.field_27002);
                targetLevel.method_18769(newEntity);
                return newEntity;
            }
        }
        return entity;
    }
}

