/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.wormhole;

import com.supermartijn642.core.TextComponents;
import com.supermartijn642.wormhole.PortalGroupCapability;
import com.supermartijn642.wormhole.StabilizerBlock;
import com.supermartijn642.wormhole.Wormhole;
import com.supermartijn642.wormhole.WormholeClient;
import com.supermartijn642.wormhole.WormholeConfig;
import com.supermartijn642.wormhole.portal.IEnergyCellEntity;
import com.supermartijn642.wormhole.portal.ITargetCellEntity;
import com.supermartijn642.wormhole.portal.PortalGroupBlockEntity;
import com.supermartijn642.wormhole.portal.PortalShape;
import com.supermartijn642.wormhole.portal.PortalTarget;
import com.supermartijn642.wormhole.targetdevice.TargetDeviceItem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;

public class StabilizerBlockEntity
extends PortalGroupBlockEntity
implements ITargetCellEntity,
IEnergyCellEntity {
    private final List<PortalTarget> targets = new ArrayList<PortalTarget>();
    private int energy = 0;

    public StabilizerBlockEntity(class_2338 pos, class_2680 state) {
        super((class_2591<?>)Wormhole.stabilizer_tile, pos, state);
        for (int i = 0; i < this.getTargetCapacity(); ++i) {
            this.targets.add(null);
        }
    }

    @Override
    public void update() {
        super.update();
        if (!this.field_11863.field_9236 && this.method_11010().method_26204() instanceof StabilizerBlock && this.hasGroup() != ((Boolean)this.method_11010().method_11654((class_2769)StabilizerBlock.ON_PROPERTY)).booleanValue()) {
            this.field_11863.method_8652(this.field_11867, (class_2680)Wormhole.portal_stabilizer.method_9564().method_11657((class_2769)StabilizerBlock.ON_PROPERTY, (Comparable)Boolean.valueOf(this.hasGroup())), 2);
        }
    }

    public boolean activate(class_1657 player) {
        if (this.hasGroup()) {
            class_1799 stack = player.method_5998(class_1268.field_5808);
            if (!(stack.method_7909() instanceof TargetDeviceItem)) {
                stack = player.method_5998(class_1268.field_5810);
            }
            if (stack.method_7909() instanceof TargetDeviceItem) {
                if (this.field_11863.field_9236) {
                    WormholeClient.openPortalTargetScreen(this.field_11867);
                }
            } else if (this.field_11863.field_9236) {
                WormholeClient.openPortalOverviewScreen(this.field_11867);
            }
        } else if (!this.field_11863.field_9236) {
            PortalShape shape = PortalShape.find((class_1922)this.field_11863, this.field_11867);
            if (shape == null) {
                player.method_7353((class_2561)TextComponents.translation((String)"wormhole.portal_stabilizer.error").color(class_124.field_1061).get(), true);
            } else {
                PortalGroupCapability.get(this.field_11863).add(shape);
                player.method_7353((class_2561)TextComponents.translation((String)"wormhole.portal_stabilizer.success").color(class_124.field_1054).get(), true);
            }
        }
        return true;
    }

    @Override
    public int getTargetCapacity() {
        return WormholeConfig.stabilizerTargetCapacity.get();
    }

    @Override
    public PortalTarget getTarget(int index) {
        return this.targets.get(index);
    }

    @Override
    public void setTarget(int index, PortalTarget target) {
        this.targets.set(index, target);
        this.dataChanged();
    }

    @Override
    public List<PortalTarget> getTargets() {
        return this.targets;
    }

    @Override
    public int getNonNullTargetCount() {
        int count = 0;
        for (PortalTarget target : this.targets) {
            if (target == null) continue;
            ++count;
        }
        return count;
    }

    @Override
    public int receiveEnergy(int maxReceive, boolean simulate, boolean fromGroup) {
        if (!fromGroup && this.hasGroup()) {
            return this.getGroup().receiveEnergy(maxReceive, simulate);
        }
        if (maxReceive < 0) {
            return -this.extractEnergy(-maxReceive, simulate);
        }
        int absorb = Math.min(this.getMaxEnergyStored(true) - this.energy, maxReceive);
        if (!simulate) {
            this.energy += absorb;
            if (absorb > 0) {
                this.dataChanged();
            }
        }
        return absorb;
    }

    @Override
    public int extractEnergy(int maxExtract, boolean simulate, boolean fromGroup) {
        if (maxExtract < 0) {
            return -this.receiveEnergy(-maxExtract, simulate);
        }
        int drain = Math.min(this.energy, maxExtract);
        if (!simulate) {
            this.energy -= drain;
            if (drain > 0) {
                this.dataChanged();
            }
        }
        return drain;
    }

    @Override
    public int getEnergyStored(boolean fromGroup) {
        if (!fromGroup && this.hasGroup()) {
            return this.getGroup().getStoredEnergy();
        }
        return Math.min(this.energy, this.getMaxEnergyStored(true));
    }

    @Override
    public void setEnergyStored(int energy) {
        this.energy = energy;
        this.dataChanged();
    }

    @Override
    public int getMaxEnergyStored(boolean fromGroup) {
        if (!fromGroup && this.hasGroup()) {
            return this.getGroup().getEnergyCapacity();
        }
        return WormholeConfig.stabilizerEnergyCapacity.get();
    }

    @Override
    public boolean canExtract() {
        return false;
    }

    @Override
    public boolean canReceive() {
        return true;
    }

    @Override
    protected void writeData(class_11372 output) {
        super.writeData(output);
        class_11372 targetsTag = output.method_71461("targets");
        for (int i = 0; i < this.targets.size(); ++i) {
            if (this.targets.get(i) == null) continue;
            this.targets.get(i).write(targetsTag.method_71461("target" + i));
        }
        output.method_71465("energy", this.energy);
    }

    @Override
    protected void readData(class_11368 input) {
        super.readData(input);
        this.targets.clear();
        class_11368 targetsTag = input.method_71434("targets");
        for (int i = 0; i < this.getTargetCapacity(); ++i) {
            this.targets.add(targetsTag.method_71420("target" + i).map(PortalTarget::read).orElse(null));
        }
        this.energy = input.method_71424("energy", 0);
    }
}

