/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.wormhole;

import com.supermartijn642.core.CommonUtils;
import com.supermartijn642.core.network.BasePacket;
import com.supermartijn642.wormhole.Wormhole;
import com.supermartijn642.wormhole.extensions.WormholeLevel;
import com.supermartijn642.wormhole.packet.UpdateGroupPacket;
import com.supermartijn642.wormhole.packet.UpdateGroupsPacket;
import com.supermartijn642.wormhole.portal.PortalGroup;
import com.supermartijn642.wormhole.portal.PortalGroupBlockEntity;
import com.supermartijn642.wormhole.portal.PortalShape;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.entity.event.v1.ServerEntityWorldChangeEvents;
import net.fabricmc.fabric.api.entity.event.v1.ServerPlayerEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_3222;

public class PortalGroupCapability {
    private final class_1937 level;
    private final List<PortalGroup> groups = new LinkedList<PortalGroup>();
    private final Map<class_2338, PortalGroup> groupsByPosition = new HashMap<class_2338, PortalGroup>();

    public static void registerListeners() {
        ServerTickEvents.END_WORLD_TICK.register(PortalGroupCapability::tickLevelCapability);
        if (CommonUtils.getEnvironmentSide().isClient()) {
            ClientTickEvents.END_WORLD_TICK.register(PortalGroupCapability::tickLevelCapability);
        }
        ServerEntityWorldChangeEvents.AFTER_PLAYER_CHANGE_WORLD.register((player, origin, destination) -> PortalGroupCapability.onJoinWorld(player, (class_1937)destination));
        ServerPlayerEvents.AFTER_RESPAWN.register((oldPlayer, newPlayer, alive) -> PortalGroupCapability.onRespawn(newPlayer));
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> PortalGroupCapability.onJoin(handler.method_32311()));
    }

    public static PortalGroupCapability get(class_1937 level) {
        return ((WormholeLevel)level).wormholeGetPortalGroupCapability();
    }

    private static void tickLevelCapability(class_1937 level) {
        PortalGroupCapability.get(level).tick();
    }

    private static void onJoinWorld(class_3222 player, class_1937 level) {
        Wormhole.CHANNEL.sendToPlayer((class_1657)player, (BasePacket)new UpdateGroupsPacket(PortalGroupCapability.get(level).write()));
    }

    private static void onRespawn(class_3222 player) {
        Wormhole.CHANNEL.sendToPlayer((class_1657)player, (BasePacket)new UpdateGroupsPacket(PortalGroupCapability.get((class_1937)player.method_51469()).write()));
    }

    private static void onJoin(class_3222 player) {
        Wormhole.CHANNEL.sendToPlayer((class_1657)player, (BasePacket)new UpdateGroupsPacket(PortalGroupCapability.get((class_1937)player.method_51469()).write()));
    }

    public PortalGroupCapability(class_1937 level) {
        this.level = level;
    }

    public void add(PortalShape shape) {
        PortalGroup group = new PortalGroup(this.level, shape);
        this.groups.add(group);
        group.shape.frame.forEach(pos -> this.groupsByPosition.put((class_2338)pos, group));
        group.shape.area.forEach(pos -> this.groupsByPosition.put((class_2338)pos, group));
        this.update();
    }

    public void remove(PortalGroup group) {
        this.groups.remove(group);
        group.shape.frame.forEach(this.groupsByPosition::remove);
        group.shape.area.forEach(this.groupsByPosition::remove);
        this.update();
    }

    public void tick() {
        for (PortalGroup group : this.groupsByPosition.values()) {
            group.canTick = true;
        }
    }

    public void updateGroup(PortalGroup group) {
        if (!this.level.field_9236 && group != null) {
            Wormhole.CHANNEL.sendToDimension(this.level, (BasePacket)new UpdateGroupPacket(this.writeGroup(group)));
        }
    }

    private void update() {
        Wormhole.CHANNEL.sendToDimension(this.level, (BasePacket)new UpdateGroupsPacket(this.write()));
    }

    public PortalGroup getGroup(PortalGroupBlockEntity entity) {
        return this.groupsByPosition.get(entity.method_11016());
    }

    public PortalGroup getGroup(class_2338 pos) {
        return this.groupsByPosition.get(pos);
    }

    public Collection<PortalGroup> getGroups() {
        return this.groupsByPosition.values();
    }

    public class_2487 write() {
        class_2487 compound = new class_2487();
        class_2487 groupsTag = new class_2487();
        for (int i = 0; i < this.groups.size(); ++i) {
            groupsTag.method_10566("groups" + i, (class_2520)this.groups.get(i).write());
        }
        compound.method_10566("groups", (class_2520)groupsTag);
        return compound;
    }

    public void read(class_2520 tag) {
        if (tag instanceof class_2487) {
            class_2487 compound = (class_2487)tag;
            this.groups.clear();
            this.groupsByPosition.clear();
            class_2487 groupsTag = compound.method_68568("groups");
            for (String key : groupsTag.method_10541()) {
                PortalGroup group = new PortalGroup(this.level, groupsTag.method_68568(key));
                this.groups.add(group);
                group.shape.frame.forEach(pos -> this.groupsByPosition.put((class_2338)pos, group));
                group.shape.area.forEach(pos -> this.groupsByPosition.put((class_2338)pos, group));
            }
        }
    }

    private class_2487 writeGroup(PortalGroup group) {
        class_2487 tag = new class_2487();
        tag.method_10566("group", (class_2520)group.write());
        return tag;
    }

    public void readGroup(class_2487 tag) {
        tag.method_10562("group").ifPresent(data -> {
            PortalGroup group = new PortalGroup(this.level, (class_2487)data);
            this.groups.add(group);
            group.shape.frame.forEach(pos -> this.groupsByPosition.put((class_2338)pos, group));
            group.shape.area.forEach(pos -> this.groupsByPosition.put((class_2338)pos, group));
        });
    }
}

