/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.model.types.base;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.supermartijn642.fusion.api.model.BlockModelBakingContext;
import com.supermartijn642.fusion.api.model.DefaultModelTypes;
import com.supermartijn642.fusion.api.model.ItemModelBakingContext;
import com.supermartijn642.fusion.api.model.ModelType;
import com.supermartijn642.fusion.api.model.data.BaseModelData;
import com.supermartijn642.fusion.model.types.base.BaseBakedModel;
import com.supermartijn642.fusion.model.types.base.BaseItemModel;
import com.supermartijn642.fusion.model.types.base.BaseModelDataImpl;
import com.supermartijn642.fusion.model.types.base.BaseModelElement;
import com.supermartijn642.fusion.model.types.base.BaseModelQuad;
import com.supermartijn642.fusion.util.IdentifierUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.class_10439;
import net.minecraft.class_1058;
import net.minecraft.class_10802;
import net.minecraft.class_10809;
import net.minecraft.class_10820;
import net.minecraft.class_1087;
import net.minecraft.class_1100;
import net.minecraft.class_2960;
import net.minecraft.class_785;
import net.minecraft.class_793;
import net.minecraft.class_809;
import net.minecraft.class_811;
import org.jetbrains.annotations.Nullable;

public class BaseModelType
implements ModelType<BaseModelData> {
    @Override
    public Collection<class_2960> getModelDependencies(BaseModelData data) {
        return data.getParents();
    }

    @Override
    @Nullable
    public class_1100 getAsVanillaModel(BaseModelData data) {
        return data.getVanillaModel();
    }

    @Override
    public List<class_2960> getParentModels(BaseModelData data) {
        return data.getParents();
    }

    @Override
    public class_1087 bakeBlockModel(BlockModelBakingContext context, BaseModelData data) {
        ((BaseModelDataImpl)data).validateParents(context);
        List<BaseModelQuad> quads = ((BaseModelDataImpl)data).bakeQuads(context);
        Boolean ambientOcclusion = ((BaseModelDataImpl)data).findProperty(context, class_1100::comp_3741, null);
        class_1058 particleSprite = context.getTexture(((BaseModelDataImpl)data).findParticleSprite(context));
        return new BaseBakedModel(quads, ambientOcclusion, particleSprite);
    }

    @Override
    public class_10439 bakeItemModel(ItemModelBakingContext context, BaseModelData data) {
        ((BaseModelDataImpl)data).validateParents(context);
        List<BaseModelQuad> quads = ((BaseModelDataImpl)data).bakeQuads(context);
        boolean usesBlockLight = ((BaseModelDataImpl)data).findProperty((BlockModelBakingContext)context, class_1100::comp_3740, class_1100.class_4751.field_21859).method_24299();
        class_1058 particleSprite = context.getTexture(((BaseModelDataImpl)data).findParticleSprite(context));
        class_809 transforms = new class_809(((BaseModelDataImpl)data).findItemTransform(context, class_811.field_4323), ((BaseModelDataImpl)data).findItemTransform(context, class_811.field_4320), ((BaseModelDataImpl)data).findItemTransform(context, class_811.field_4321), ((BaseModelDataImpl)data).findItemTransform(context, class_811.field_4322), ((BaseModelDataImpl)data).findItemTransform(context, class_811.field_4316), ((BaseModelDataImpl)data).findItemTransform(context, class_811.field_4317), ((BaseModelDataImpl)data).findItemTransform(context, class_811.field_4318), ((BaseModelDataImpl)data).findItemTransform(context, class_811.field_4319));
        return new BaseItemModel(context.getTintSources(), quads, new class_10809(usesBlockLight, particleSprite, transforms));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public BaseModelData deserialize(JsonObject json) throws JsonParseException {
        List vanillaElements;
        class_793 model = (class_793)DefaultModelTypes.VANILLA.deserialize(json);
        if (json.has("parent") && json.has("parents")) {
            throw new JsonParseException("Model can only have either 'parent' or 'parents', not both!");
        }
        List<class_2960> parents = List.of();
        if (json.has("parent")) {
            if (!json.get("parent").isJsonPrimitive() || !json.get("parent").getAsJsonPrimitive().isString()) {
                throw new JsonParseException("Property 'parent' must be a string!");
            }
            String parent = json.get("parent").getAsString();
            if (!IdentifierUtil.isValidIdentifier(parent)) {
                throw new JsonParseException("Property 'parent' must be a valid identifier!");
            }
            parents = List.of(class_2960.method_60654((String)parent));
        } else if (json.has("parents")) {
            if (!json.get("parents").isJsonArray()) {
                throw new JsonParseException("Property 'parents' must be an array!");
            }
            JsonArray parentArray = json.getAsJsonArray("parents");
            parents = new ArrayList<class_2960>(parentArray.size());
            for (JsonElement element : parentArray) {
                if (!element.isJsonPrimitive() || !element.getAsJsonPrimitive().isString()) {
                    throw new JsonParseException("Array 'parents' must only contain strings!");
                }
                String parent = element.getAsString();
                if (!IdentifierUtil.isValidIdentifier(parent)) {
                    throw new JsonParseException("Array 'parents' must only contain valid identifiers, not '" + parent + "'!");
                }
                parents.add(class_2960.method_60654((String)parent));
            }
            if (!parents.isEmpty()) {
                model = new class_793(model.comp_3739(), model.comp_3740(), model.comp_3741(), model.comp_3742(), model.comp_3743(), parents.get(0));
            }
        }
        List<BaseModelElement> elements = List.of();
        class_10820 class_108202 = model.comp_3739();
        if (!(class_108202 instanceof class_10802)) return new BaseModelDataImpl(model, parents, elements);
        class_10802 class_108022 = (class_10802)class_108202;
        try {
            List list;
            vanillaElements = list = class_108022.comp_3753();
            elements = new ArrayList<BaseModelElement>(vanillaElements.size());
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        for (class_785 element : vanillaElements) {
            elements.add(new BaseModelElement(element.comp_3727(), element.comp_3728(), element.comp_3729(), element.comp_3730(), element.comp_3731(), element.comp_3732()));
        }
        return new BaseModelDataImpl(model, parents, elements);
    }

    @Override
    public JsonObject serialize(BaseModelData value) {
        JsonObject json = DefaultModelTypes.VANILLA.serialize(value.getVanillaModel());
        if (value.getParents().size() > 1) {
            json.remove("parent");
            JsonArray parents = new JsonArray(value.getParents().size());
            value.getParents().forEach(p -> parents.add(p.toString()));
            json.add("parents", (JsonElement)parents);
        }
        return json;
    }
}

