/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.model.modifiers.item.predicates;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.supermartijn642.fusion.api.model.modifier.item.ItemPredicate;
import com.supermartijn642.fusion.api.util.Serializer;
import com.supermartijn642.fusion.util.IdentifierUtil;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.minecraft.class_9304;

public class EnchantmentItemPredicate
implements ItemPredicate {
    public static final Serializer<EnchantmentItemPredicate> SERIALIZER = new Serializer<EnchantmentItemPredicate>(){

        @Override
        public EnchantmentItemPredicate deserialize(JsonObject json) throws JsonParseException {
            int minLevel;
            if (!(json.has("enchantment") && json.get("enchantment").isJsonPrimitive() && json.getAsJsonPrimitive("enchantment").isString())) {
                throw new JsonParseException("Item-predicate must have string property 'enchantment'!");
            }
            if (!IdentifierUtil.isValidIdentifier(json.get("enchantment").getAsString())) {
                throw new JsonParseException("Property 'enchantment' must be a valid identifier, not '" + json.get("enchantment").getAsString() + "'!");
            }
            class_2960 enchantment = class_2960.method_60654((String)json.get("enchantment").getAsString());
            int maxLevel = 255;
            if (json.has("max_level")) {
                if (!json.get("max_level").isJsonPrimitive() || !json.getAsJsonPrimitive("max_level").isNumber()) {
                    throw new JsonParseException("Property 'max_level' must be a number!");
                }
                maxLevel = json.getAsJsonPrimitive("max_level").getAsInt();
                if (maxLevel < 0 || maxLevel > 255) {
                    throw new JsonParseException("Property 'max_level' must be between 0 and 255!");
                }
            }
            int n = minLevel = maxLevel == 0 ? 0 : 1;
            if (json.has("min_level")) {
                if (!json.get("min_level").isJsonPrimitive() || !json.getAsJsonPrimitive("min_level").isNumber()) {
                    throw new JsonParseException("Property 'min_level' must be a number!");
                }
                minLevel = json.getAsJsonPrimitive("min_level").getAsInt();
                if (minLevel < 0 || minLevel > 255) {
                    throw new JsonParseException("Property 'min_level' must be between 0 and 255!");
                }
            }
            if (minLevel > maxLevel) {
                throw new JsonParseException("Property 'min_level' must be less than or equal to 'max_level'!");
            }
            return new EnchantmentItemPredicate(enchantment, minLevel, maxLevel);
        }

        @Override
        public JsonObject serialize(EnchantmentItemPredicate value) {
            JsonObject json = new JsonObject();
            json.addProperty("enchantment", value.enchantment.toString());
            if (value.maxLevel != 0 && value.minLevel != 1) {
                json.addProperty("min_level", (Number)value.minLevel);
            }
            if (value.maxLevel != 255) {
                json.addProperty("max_level", (Number)value.maxLevel);
            }
            return json;
        }
    };
    private final class_2960 enchantment;
    private final int minLevel;
    private final int maxLevel;
    private class_5455 registry;
    private class_6880<class_1887> holder;

    public EnchantmentItemPredicate(class_2960 enchantment, int minLevel, int maxLevel) {
        if (enchantment == null) {
            throw new NullPointerException("Enchantment must not be null!");
        }
        if (minLevel < 0 || minLevel > 255) {
            throw new IllegalArgumentException("Min level must be between 0 and 255!");
        }
        if (maxLevel < 0 || maxLevel > 255) {
            throw new IllegalArgumentException("Max level must be between 0 and 255!");
        }
        if (minLevel > maxLevel) {
            throw new IllegalArgumentException("Minimum level must be less than or equal to maximum level!");
        }
        this.enchantment = enchantment;
        this.minLevel = minLevel;
        this.maxLevel = maxLevel;
    }

    @Override
    public boolean test(class_1799 stack) {
        class_9304 enchantments = stack.method_58657();
        if (enchantments.method_57543()) {
            return this.minLevel == 0;
        }
        if (class_310.method_1551().field_1687 == null) {
            return this.minLevel == 0;
        }
        if (class_310.method_1551().field_1687.method_30349() != this.registry) {
            this.registry = class_310.method_1551().field_1687.method_30349();
            this.holder = this.registry.method_30530(class_7924.field_41265).method_10223(this.enchantment).orElse(null);
        }
        if (this.holder == null) {
            return this.minLevel == 0;
        }
        int level = enchantments.method_57536(this.holder);
        return level >= this.minLevel && level <= this.maxLevel;
    }

    @Override
    public Serializer<? extends ItemPredicate> getSerializer() {
        return SERIALIZER;
    }
}

