/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.entity.model;

import com.supermartijn642.fusion.api.util.Pair;
import com.supermartijn642.fusion.entity.VanillaModelLayerProperties;
import com.supermartijn642.fusion.entity.model.ModelTransformer;
import com.supermartijn642.fusion.entity.model.predicates.EntityModelPredicate;
import com.supermartijn642.fusion.util.Triple;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.class_1297;
import net.minecraft.class_2960;
import net.minecraft.class_5601;
import net.minecraft.class_5819;
import net.minecraft.class_630;

public class EntityLayerProperties {
    public static final class_5819 RANDOM = class_5819.method_43047();
    private final class_5601 identifier;
    private final List<ModelOption> defaultModel;
    private final List<Pair<EntityModelPredicate, List<ModelOption>>> conditionals;

    public EntityLayerProperties(class_5601 identifier, List<ModelOption> defaultModel, List<Pair<EntityModelPredicate, List<ModelOption>>> conditionals) {
        this.identifier = identifier;
        this.defaultModel = defaultModel;
        this.conditionals = conditionals;
    }

    public class_5601 identifier() {
        return this.identifier;
    }

    public Triple<class_630, class_2960, Float> chooseModel(class_1297 entity) {
        List<ModelOption> options = this.defaultModel;
        for (Pair<EntityModelPredicate, List<ModelOption>> conditional : this.conditionals) {
            if (!conditional.left().test(entity)) continue;
            options = conditional.right();
            break;
        }
        if (options.size() == 1 && (options.get((int)0).textures == null || options.get((int)0).textures.size() == 1)) {
            return Triple.of(options.get((int)0).model, options.get((int)0).textures == null ? null : options.get((int)0).textures.get(0), options.get((int)0).scaling);
        }
        RANDOM.method_43052(this.seed(entity.method_5667()));
        double value = RANDOM.method_43058();
        double sum = 0.0;
        ModelOption option = null;
        for (ModelOption o : options) {
            if (!((sum += o.weight) >= value)) continue;
            option = o;
            break;
        }
        if (option == null) {
            throw new AssertionError((Object)("Weights should add up to 1, yet no model was found for value '" + value + "'!"));
        }
        class_2960 texture = option.textures == null ? null : (option.textures.size() > 1 ? option.textures.get(RANDOM.method_43048(option.textures.size())) : option.textures.get(0));
        return Triple.of(option.model, texture, option.scaling);
    }

    private long seed(UUID uuid) {
        return uuid.getLeastSignificantBits() ^ uuid.getMostSignificantBits() ^ (long)this.identifier.comp_2996().hashCode();
    }

    public void gatherModels(Consumer<class_630> output) {
        for (ModelOption modelOption : this.defaultModel) {
            output.accept(modelOption.model);
        }
        for (Pair pair : this.conditionals) {
            for (ModelOption option : (List)pair.right()) {
                output.accept(option.model);
            }
        }
    }

    public EntityLayerProperties transformed(VanillaModelLayerProperties properties) {
        return new EntityLayerProperties(this.identifier, this.defaultModel.stream().map(o -> o.transformed(properties)).toList(), this.conditionals.stream().map(c -> c.mapRight(l -> l.stream().map(o -> o.transformed(properties)).toList())).toList());
    }

    public static class ModelOption {
        private final class_630 model;
        private final boolean isVanillaModel;
        private final List<class_2960> textures;
        private final double weight;
        private final Float scaling;

        public ModelOption(class_630 model, boolean isVanillaModel, List<class_2960> textures, double weight, Float scaling) {
            this.model = model;
            this.isVanillaModel = isVanillaModel;
            this.textures = textures;
            this.weight = weight;
            this.scaling = scaling;
        }

        public double weight() {
            return this.weight;
        }

        public class_630 model() {
            return this.model;
        }

        public boolean isVanillaModel() {
            return this.isVanillaModel;
        }

        public List<class_2960> textures() {
            return this.textures;
        }

        public Float scaling() {
            return this.scaling;
        }

        private ModelOption transformed(VanillaModelLayerProperties properties) {
            if (this.isVanillaModel) {
                return this;
            }
            class_630 model = this.model;
            if (properties.getOffsetX() != 0.0f) {
                model = ModelTransformer.translateX(model, properties.getOffsetX());
            }
            if (properties.getOffsetY() != 0.0f) {
                model = ModelTransformer.translateY(model, properties.getOffsetY());
            }
            if (properties.getOffsetZ() != 0.0f) {
                model = ModelTransformer.translateZ(model, properties.getOffsetZ());
            }
            if (properties.shouldFlipX()) {
                model = ModelTransformer.flipX(model);
            }
            if (properties.shouldFlipY()) {
                model = ModelTransformer.flipY(model);
            }
            if (properties.shouldFlipZ()) {
                model = ModelTransformer.flipZ(model);
            }
            return new ModelOption(model, false, this.textures, this.weight, this.scaling);
        }
    }
}

