/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.cyclepaintings_common_forge.events;

import com.mojang.datafixers.util.Pair;
import com.natamus.collective_common_forge.functions.TaskFunctions;
import com.natamus.cyclepaintings_common_forge.util.Util;
import java.util.Optional;
import net.minecraft.ResourceLocationException;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.decoration.Painting;
import net.minecraft.world.entity.decoration.PaintingVariant;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public class BlockEvents {
    public static boolean onRightClickBlock(Level level, Player player, InteractionHand hand, BlockPos blockPos, BlockHitResult hitVec) {
        ResourceLocation variantResourceLocation;
        if (level.isClientSide) {
            return true;
        }
        ItemStack handstack = player.getItemInHand(hand);
        if (!handstack.getItem().equals(Items.PAINTING)) {
            return true;
        }
        BlockState blockState = level.getBlockState(blockPos);
        Block block = blockState.getBlock();
        if (!(block instanceof EntityBlock)) {
            return true;
        }
        ResourceLocation blockResourceLocation = level.registryAccess().lookupOrThrow(Registries.BLOCK).getKey((Object)block);
        if (!blockResourceLocation.getNamespace().equals("fastpaintings")) {
            return true;
        }
        Optional optionalFacing = blockState.getOptionalValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        if (optionalFacing.isEmpty()) {
            return true;
        }
        Direction facing = (Direction)optionalFacing.get();
        Pair<Integer, Integer> offsetPair = BlockEvents.getOffsetsFromState(blockState);
        BlockPos masterPosition = blockPos.above(((Integer)offsetPair.getSecond()).intValue()).relative(facing.getClockWise(), ((Integer)offsetPair.getFirst()).intValue());
        BlockEntity paintingBlockEntity = level.getBlockEntity(masterPosition);
        if (paintingBlockEntity == null) {
            return true;
        }
        CompoundTag tag = paintingBlockEntity.getUpdateTag((HolderLookup.Provider)level.registryAccess());
        if (!tag.contains("variant")) {
            return true;
        }
        String rawVariantResourceLocation = tag.getStringOr("variant", "");
        if (rawVariantResourceLocation.isEmpty()) {
            return true;
        }
        try {
            variantResourceLocation = ResourceLocation.parse((String)rawVariantResourceLocation);
        }
        catch (ResourceLocationException ex) {
            return true;
        }
        Registry paintingVariantRegistry = level.registryAccess().lookupOrThrow(Registries.PAINTING_VARIANT);
        Optional optionalPaintingVariant = paintingVariantRegistry.getOptional(variantResourceLocation);
        if (optionalPaintingVariant.isEmpty()) {
            return true;
        }
        Holder paintingVariantHolder = paintingVariantRegistry.wrapAsHolder((Object)((PaintingVariant)optionalPaintingVariant.get()));
        Holder<PaintingVariant> newVariantHolder = Util.getNewPaintingVariant(player, (Holder<PaintingVariant>)paintingVariantHolder);
        PaintingVariant newVariant = (PaintingVariant)newVariantHolder.value();
        BlockPos.MutableBlockPos newPaintingPosition = masterPosition.mutable();
        if (newVariant.height() > 1 || newVariant.width() > 2) {
            newPaintingPosition = newPaintingPosition.below();
        }
        if (newVariant.width() > 2) {
            newPaintingPosition = newPaintingPosition.relative(facing.getCounterClockWise(), 1);
        }
        level.setBlock(masterPosition, Blocks.AIR.defaultBlockState(), 3);
        BlockPos finalNewPaintingPosition = newPaintingPosition.immutable();
        TaskFunctions.enqueueCollectiveServerTask((MinecraftServer)level.getServer(), () -> level.addFreshEntity((Entity)new Painting(level, finalNewPaintingPosition, facing, newVariantHolder)), (int)0);
        return true;
    }

    public static Pair<Integer, Integer> getOffsetsFromState(BlockState state) {
        int xOffset = 0;
        int yOffset = 0;
        for (Property property : state.getProperties()) {
            if (!(property instanceof IntegerProperty)) continue;
            IntegerProperty intProp = (IntegerProperty)property;
            switch (intProp.getName()) {
                case "x_offset": {
                    xOffset = (Integer)state.getValue(property);
                    break;
                }
                case "y_offset": {
                    yOffset = (Integer)state.getValue(property);
                }
            }
        }
        return Pair.of((Object)xOffset, (Object)yOffset);
    }
}

