/*
 * Decompiled with CFR 0.152.
 */
package com.damir00109;

import com.damir00109.ActionBar;
import com.damir00109.BossBarTPS;
import com.damir00109.TPS;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.sun.management.OperatingSystemMXBean;
import java.lang.management.ManagementFactory;
import java.util.ArrayDeque;
import java.util.Queue;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VanillaTPS {
    public static final String MOD_ID = "vanilla-tps";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"vanilla-tps");
    public static long lastTickTime = 0L;
    public static double tps = 20.0;
    public static double mspt = 50.0;
    public static final Queue<Double> tps5s = new ArrayDeque<Double>(100);
    public static final Queue<Double> tps1m = new ArrayDeque<Double>(1200);
    public static final Queue<Double> tps5m = new ArrayDeque<Double>(6000);
    public static final Queue<Double> tps15m = new ArrayDeque<Double>(18000);
    public static final Queue<Double> mspt5s = new ArrayDeque<Double>(100);
    public static final Queue<Double> mspt1m = new ArrayDeque<Double>(1200);
    public static final Queue<Double> mspt5m = new ArrayDeque<Double>(6000);
    public static final Queue<Double> mspt15m = new ArrayDeque<Double>(18000);

    public static void onServerTick(MinecraftServer server) {
        long currentTime = System.nanoTime();
        if (lastTickTime != 0L) {
            double deltaTime = (double)(currentTime - lastTickTime) / 1.0E9;
            tps = 1.0 / deltaTime;
            mspt = deltaTime * 1000.0;
            VanillaTPS.collectStatistics(tps, mspt);
        }
        lastTickTime = currentTime;
    }

    private static void collectStatistics(double tps, double mspt) {
        tps5s.add(tps);
        tps1m.add(tps);
        tps5m.add(tps);
        tps15m.add(tps);
        mspt5s.add(mspt);
        mspt1m.add(mspt);
        mspt5m.add(mspt);
        mspt15m.add(mspt);
        if (tps5s.size() > 100) {
            tps5s.poll();
        }
        if (tps1m.size() > 1200) {
            tps1m.poll();
        }
        if (tps5m.size() > 6000) {
            tps5m.poll();
        }
        if (tps15m.size() > 18000) {
            tps15m.poll();
        }
        if (mspt5s.size() > 100) {
            mspt5s.poll();
        }
        if (mspt1m.size() > 1200) {
            mspt1m.poll();
        }
        if (mspt5m.size() > 6000) {
            mspt5m.poll();
        }
        if (mspt15m.size() > 18000) {
            mspt15m.poll();
        }
    }

    public static double getCurrentTPS() {
        return tps;
    }

    public static double getCurrentMSPT() {
        return mspt;
    }

    public static double getCpuUsage() {
        OperatingSystemMXBean osBean = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
        double processLoad = osBean.getProcessCpuLoad() * 100.0;
        return Double.isNaN(processLoad) ? 0.0 : processLoad;
    }

    public static double getRamUsagePercentage() {
        Runtime runtime = Runtime.getRuntime();
        long totalMemory = runtime.totalMemory();
        long freeMemory = runtime.freeMemory();
        long usedMemory = totalMemory - freeMemory;
        long maxMemory = runtime.maxMemory();
        return (double)usedMemory / (double)maxMemory * 100.0;
    }

    public static String getRamUsageFormatted() {
        Runtime runtime = Runtime.getRuntime();
        long totalMemory = runtime.totalMemory();
        long freeMemory = runtime.freeMemory();
        long usedMemory = totalMemory - freeMemory;
        long maxMemory = runtime.maxMemory();
        return String.format("%dM / %dM (max: %dM)", usedMemory / 1024L / 1024L, totalMemory / 1024L / 1024L, maxMemory / 1024L / 1024L);
    }

    public static void registerCommands(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"tps").requires(source -> source.method_9259(2))).executes(context -> {
            ((class_2168)context.getSource()).method_45068(class_2561.method_30163((String)TPS.getTpsInfo()));
            return 1;
        }));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"tps-actionbar").requires(source -> source.method_9259(2))).executes(context -> {
            class_3222 player = ((class_2168)context.getSource()).method_44023();
            if (player != null) {
                ActionBar.toggleActionBar(player);
            }
            return 1;
        }));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"tabtps").requires(source -> source.method_9259(2))).executes(context -> {
            class_3222 player = ((class_2168)context.getSource()).method_44023();
            if (player != null) {
                BossBarTPS.toggleBossBar(player);
            }
            return 1;
        }));
    }
}

