/*
 * Decompiled with CFR 0.152.
 */
package com.damir00109;

import com.damir00109.VanillaTPS;
import java.util.Iterator;
import java.util.Queue;

public class TPS {
    public static String getTpsInfo() {
        StringBuilder builder = new StringBuilder();
        builder.append(String.format("%-15s", "TPS:")).append(String.format("%-15s", "MSPT:")).append(String.format("%-20s", "\u0420\u0435\u0441\u0443\u0440\u0441\u044b:")).append("\n");
        double tps5sValue = TPS.getAverage(VanillaTPS.tps5s);
        double tps1mValue = TPS.getAverage(VanillaTPS.tps1m);
        double tps5mValue = TPS.getAverage(VanillaTPS.tps5m);
        double tps15mValue = TPS.getAverage(VanillaTPS.tps15m);
        String tps5sStr = String.format("%.2f", tps5sValue);
        String tps1mStr = String.format("%.2f", tps1mValue);
        String tps5mStr = String.format("%.2f", tps5mValue);
        String tps15mStr = String.format("%.2f", tps15mValue);
        int maxTpsLength = Math.max(Math.max(tps5sStr.length(), tps1mStr.length()), Math.max(tps5mStr.length(), tps15mStr.length()));
        builder.append("\u251c\u2500 5s: ").append(String.format("%-" + maxTpsLength + "s", tps5sStr)).append("   \u251c\u2500 5s: ").append(String.format("%-10.2f", TPS.getAverage(VanillaTPS.mspt5s))).append("   CPU: ").append(String.format("%.2f%%", VanillaTPS.getCpuUsage())).append("\n");
        builder.append("\u251c\u2500 1m: ").append(String.format("%-" + maxTpsLength + "s", tps1mStr)).append("   \u251c\u2500 1m: ").append(String.format("%-10.2f", TPS.getAverage(VanillaTPS.mspt1m))).append("   RAM: ").append(String.format("%.2f%%", VanillaTPS.getRamUsagePercentage())).append("\n");
        builder.append("\u251c\u2500 5m: ").append(String.format("%-" + maxTpsLength + "s", tps5mStr)).append("   \u251c\u2500 5m: ").append(String.format("%-10.2f", TPS.getAverage(VanillaTPS.mspt5m))).append("\n");
        builder.append("\u2514\u2500 15m: ").append(String.format("%-" + maxTpsLength + "s", tps15mStr)).append("  \u2514\u2500 15m: ").append(String.format("%-10.2f", TPS.getAverage(VanillaTPS.mspt15m))).append("\n");
        builder.append("\n\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u043e: ").append(VanillaTPS.getRamUsageFormatted()).append("\n");
        return builder.toString();
    }

    private static double getAverage(Queue<Double> queue) {
        if (queue.isEmpty()) {
            return 0.0;
        }
        double sum = 0.0;
        Iterator iterator = queue.iterator();
        while (iterator.hasNext()) {
            double value = (Double)iterator.next();
            sum += value;
        }
        return sum / (double)queue.size();
    }
}

