/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.util.resource;

import de.keksuccino.fancymenu.customization.placeholder.PlaceholderParser;
import de.keksuccino.fancymenu.util.file.type.FileMediaType;
import de.keksuccino.fancymenu.util.resource.PlayableResource;
import de.keksuccino.fancymenu.util.resource.RenderableResource;
import de.keksuccino.fancymenu.util.resource.Resource;
import de.keksuccino.fancymenu.util.resource.ResourceHandler;
import de.keksuccino.fancymenu.util.resource.ResourceHandlers;
import de.keksuccino.fancymenu.util.resource.ResourceSource;
import de.keksuccino.fancymenu.util.resource.ResourceSourceType;
import de.keksuccino.fancymenu.util.resource.resources.audio.IAudio;
import de.keksuccino.fancymenu.util.resource.resources.text.IText;
import de.keksuccino.fancymenu.util.resource.resources.texture.ITexture;
import de.keksuccino.fancymenu.util.resource.resources.video.IVideo;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.class_2960;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResourceSupplier<R extends Resource> {
    private static final Logger LOGGER = LogManager.getLogger();
    @NotNull
    protected String source;
    @NotNull
    protected Class<R> resourceType;
    @NotNull
    FileMediaType mediaType;
    @Nullable
    protected R current;
    @Nullable
    protected String lastGetterSource;
    @Nullable
    protected Consumer<R> onUpdateCurrent = null;
    protected boolean empty = false;

    @NotNull
    public static <R extends Resource> ResourceSupplier<R> empty(@NotNull Class<R> resourceType, @NotNull FileMediaType mediaType) {
        ResourceSupplier<R> supplier = new ResourceSupplier<R>(resourceType, mediaType, "");
        supplier.empty = true;
        return supplier;
    }

    @NotNull
    public static ResourceSupplier<ITexture> image(@NotNull String source) {
        return new ResourceSupplier<ITexture>(ITexture.class, FileMediaType.IMAGE, source);
    }

    @NotNull
    public static ResourceSupplier<IAudio> audio(@NotNull String source) {
        return new ResourceSupplier<IAudio>(IAudio.class, FileMediaType.AUDIO, source).setOnUpdateResourceTask(PlayableResource::stop);
    }

    @NotNull
    public static ResourceSupplier<IVideo> video(@NotNull String source) {
        return new ResourceSupplier<IVideo>(IVideo.class, FileMediaType.VIDEO, source);
    }

    @NotNull
    public static ResourceSupplier<IText> text(@NotNull String source) {
        return new ResourceSupplier<IText>(IText.class, FileMediaType.TEXT, source);
    }

    public ResourceSupplier(@NotNull Class<R> resourceType, @NotNull FileMediaType mediaType, @NotNull String source) {
        this.source = Objects.requireNonNull(source);
        this.resourceType = Objects.requireNonNull(resourceType);
        this.mediaType = Objects.requireNonNull(mediaType);
    }

    @Nullable
    public R get() {
        String getterSource;
        if (this.empty) {
            return null;
        }
        if (this.current != null && this.current.isClosed()) {
            this.current = null;
        }
        if (!(getterSource = PlaceholderParser.replacePlaceholders(this.source, false)).equals(this.lastGetterSource)) {
            if (this.onUpdateCurrent != null && this.current != null) {
                this.onUpdateCurrent.accept(this.current);
            }
            this.current = null;
        }
        this.lastGetterSource = getterSource;
        if (this.current == null) {
            ResourceSource resourceSource = ResourceSource.of(getterSource);
            try {
                ResourceHandler<?, ?> handler = this.getResourceHandler();
                if (handler != null) {
                    this.current = handler.get(resourceSource);
                }
            }
            catch (Exception ex) {
                LOGGER.error("[FANCYMENU] ResourceSupplier failed to get resource: " + String.valueOf(resourceSource) + " (" + this.source + ")", (Throwable)ex);
            }
        }
        return this.current;
    }

    @Nullable
    public ResourceHandler<?, ?> getResourceHandler() {
        if (this.mediaType == FileMediaType.IMAGE) {
            return ResourceHandlers.getImageHandler();
        }
        if (this.mediaType == FileMediaType.AUDIO) {
            return ResourceHandlers.getAudioHandler();
        }
        if (this.mediaType == FileMediaType.VIDEO) {
            return ResourceHandlers.getVideoHandler();
        }
        if (this.mediaType == FileMediaType.TEXT) {
            return ResourceHandlers.getTextHandler();
        }
        return null;
    }

    public void forRenderable(@NotNull BiConsumer<R, class_2960> task) {
        RenderableResource r;
        class_2960 loc;
        R resource = this.get();
        if (resource instanceof RenderableResource && (loc = (r = (RenderableResource)resource).getResourceLocation()) != null) {
            task.accept(resource, loc);
        }
    }

    @NotNull
    public Class<R> getResourceType() {
        return this.resourceType;
    }

    @NotNull
    public FileMediaType getMediaType() {
        return this.mediaType;
    }

    @NotNull
    public ResourceSourceType getSourceType() {
        if (this.empty) {
            return ResourceSourceType.LOCAL;
        }
        return ResourceSourceType.getSourceTypeOf(PlaceholderParser.replacePlaceholders(this.source, false));
    }

    @NotNull
    public String getSourceWithoutPrefix() {
        if (this.empty) {
            return "";
        }
        return ResourceSourceType.getWithoutSourcePrefix(this.source);
    }

    @NotNull
    public String getSourceWithPrefix() {
        if (this.empty) {
            return "";
        }
        if (ResourceSourceType.hasSourcePrefix(this.source)) {
            return this.source;
        }
        return this.getSourceType().getSourcePrefix() + this.source;
    }

    public void setSource(@NotNull String source) {
        if (this.empty) {
            return;
        }
        this.source = Objects.requireNonNull(source);
    }

    public ResourceSupplier<R> setOnUpdateResourceTask(@Nullable Consumer<R> oldResourceConsumer) {
        this.onUpdateCurrent = oldResourceConsumer;
        return this;
    }

    public boolean isEmpty() {
        return this.empty;
    }
}

