/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.util.rendering.text.markdown;

import de.keksuccino.fancymenu.util.rendering.DrawableColor;
import de.keksuccino.fancymenu.util.rendering.text.markdown.MarkdownRenderer;
import de.keksuccino.fancymenu.util.rendering.ui.FancyMenuUiComponent;
import de.keksuccino.fancymenu.util.rendering.ui.scroll.v2.scrollarea.ScrollArea;
import de.keksuccino.fancymenu.util.rendering.ui.scroll.v2.scrollarea.entry.ScrollAreaEntry;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_4069;
import net.minecraft.class_6379;
import net.minecraft.class_6382;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScrollableMarkdownRenderer
implements class_4068,
class_4069,
class_6379,
FancyMenuUiComponent {
    @NotNull
    protected ScrollArea scrollArea = new ScrollArea(0.0f, 0.0f, 0.0f, 0.0f);
    @NotNull
    protected MarkdownRenderer markdownRenderer = new MarkdownRenderer();
    @NotNull
    protected List<class_364> children = new ArrayList<class_364>();
    protected boolean allowScrolling = true;
    @NotNull
    protected String text = "";
    protected boolean dragging = false;
    protected boolean focused = false;

    public ScrollableMarkdownRenderer(float x, float y, float width, float height) {
        this.rebuild(x, y, width, height);
    }

    public void rebuild(float x, float y, float width, float height) {
        this.children.clear();
        this.markdownRenderer = new MarkdownRenderer();
        this.scrollArea = new ScrollArea(this, x, y, width, height){

            @Override
            public void updateScrollArea() {
                super.updateScrollArea();
                this.verticalScrollBar.scrollAreaEndX = this.x + this.width + 12.0f;
                this.horizontalScrollBar.scrollAreaEndY = this.y + this.height + 12.0f;
            }
        };
        this.scrollArea.minimumEntryWidthIsAreaWidth = false;
        this.scrollArea.makeEntriesWidthOfArea = false;
        this.scrollArea.makeAllEntriesWidthOfWidestEntry = false;
        this.scrollArea.verticalScrollBar.grabberWidth = 10.0f;
        this.scrollArea.verticalScrollBar.grabberHeight = 20.0f;
        this.scrollArea.horizontalScrollBar.grabberWidth = 20.0f;
        this.scrollArea.horizontalScrollBar.grabberHeight = 10.0f;
        this.scrollArea.backgroundColor = () -> DrawableColor.of(0, 0, 0, 0);
        this.scrollArea.borderColor = () -> DrawableColor.of(0, 0, 0, 0);
        this.scrollArea.addEntry(new MarkdownRendererEntry(this.scrollArea, this.markdownRenderer));
        this.markdownRenderer.addLineRenderValidator(line -> {
            if (line.parent.getY() + line.offsetY + line.getLineHeight() < this.scrollArea.getInnerY()) {
                return false;
            }
            if (line.parent.getY() + line.offsetY > this.scrollArea.getInnerY() + this.scrollArea.getInnerHeight()) {
                return false;
            }
            return true;
        });
        this.markdownRenderer.setText(this.text);
        this.children.add((class_364)this.markdownRenderer);
        this.children.add(this.scrollArea);
    }

    protected void tick() {
        this.scrollArea.verticalScrollBar.setScrollWheelAllowed(this.allowScrolling);
        this.scrollArea.verticalScrollBar.active = this.scrollArea.getTotalEntryHeight() > this.scrollArea.getInnerHeight() && this.allowScrolling;
        this.scrollArea.horizontalScrollBar.active = this.scrollArea.getTotalEntryWidth() > this.scrollArea.getInnerWidth() && this.allowScrolling;
    }

    public void method_25394(@NotNull class_332 graphics, int mouseX, int mouseY, float partial) {
        this.tick();
        this.scrollArea.method_25394(graphics, mouseX, mouseY, partial);
    }

    public ScrollableMarkdownRenderer setText(@NotNull String text) {
        this.text = Objects.requireNonNull(text);
        this.markdownRenderer.setText(text);
        return this;
    }

    public ScrollableMarkdownRenderer setScrollingAllowed(boolean allowed) {
        this.allowScrolling = allowed;
        return this;
    }

    public boolean isScrollingAllowed() {
        return this.allowScrolling;
    }

    @NotNull
    public MarkdownRenderer getMarkdownRenderer() {
        return this.markdownRenderer;
    }

    @NotNull
    public ScrollArea getScrollArea() {
        return this.scrollArea;
    }

    @NotNull
    public List<class_364> method_25396() {
        return this.children;
    }

    public boolean method_25397() {
        return this.dragging;
    }

    public void method_25398(boolean dragging) {
        this.dragging = dragging;
    }

    @Nullable
    public class_364 method_25399() {
        return this.scrollArea;
    }

    public void method_25395(@Nullable class_364 var1) {
    }

    @NotNull
    public class_6379.class_6380 method_37018() {
        return class_6379.class_6380.field_33784;
    }

    public void method_37020(@NotNull class_6382 var1) {
    }

    public boolean method_25401(double mouseX, double mouseY, double scrollDeltaX, double scrollDeltaY) {
        return this.scrollArea.method_25401(mouseX, mouseY, scrollDeltaX, scrollDeltaY);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        this.markdownRenderer.method_25406(mouseX, mouseY, button);
        this.scrollArea.method_25406(mouseX, mouseY, button);
        return false;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        for (class_364 listener : this.method_25396()) {
            if (!listener.method_25402(mouseX, mouseY, button)) continue;
            this.method_25395(listener);
            if (button == 0) {
                this.method_25398(true);
            }
            return true;
        }
        return false;
    }

    protected static class MarkdownRendererEntry
    extends ScrollAreaEntry {
        protected MarkdownRenderer markdownRenderer;

        public MarkdownRendererEntry(ScrollArea parent, MarkdownRenderer markdownRenderer) {
            super(parent, 20.0f, 20.0f);
            this.markdownRenderer = markdownRenderer;
            this.selectable = false;
            this.playClickSound = false;
            this.backgroundColorNormal = () -> DrawableColor.of(0, 0, 0, 0);
            this.backgroundColorHover = () -> DrawableColor.of(0, 0, 0, 0);
        }

        @Override
        public void renderEntry(@NotNull class_332 graphics, int mouseX, int mouseY, float partial) {
            this.markdownRenderer.setOptimalWidth(this.parent.getInnerWidth());
            this.markdownRenderer.setX(this.x);
            this.markdownRenderer.setY(this.y);
            this.setWidth(this.markdownRenderer.getRealWidth());
            this.setHeight(this.markdownRenderer.getRealHeight());
            this.markdownRenderer.method_25394(graphics, mouseX, mouseY, partial);
        }

        @Override
        public void onClick(ScrollAreaEntry entry, double mouseX, double mouseY, int button) {
        }
    }
}

