/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.util.cycle;

import de.keksuccino.fancymenu.util.ConsumingSupplier;
import de.keksuccino.fancymenu.util.cycle.ILocalizedValueCycle;
import de.keksuccino.fancymenu.util.cycle.ValueCycle;
import java.security.InvalidParameterException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;

public class LocalizedGenericValueCycle<T>
extends ValueCycle<T>
implements ILocalizedValueCycle<T> {
    protected String cycleLocalizationKey;
    protected ConsumingSupplier<T, class_2583> cycleStyle = consumes -> class_2583.field_24360;
    protected ConsumingSupplier<T, class_2583> valueStyle = consumes -> class_2583.field_24360;
    protected ConsumingSupplier<T, String> valueNameSupplier = Object::toString;

    @SafeVarargs
    public static <T> LocalizedGenericValueCycle<T> of(@NotNull String cycleLocalizationKey, T ... values) {
        Objects.requireNonNull(values);
        List<T> valueList = Arrays.asList(values);
        if (valueList.size() < 2) {
            throw new InvalidParameterException("Failed to create LocalizedGenericValueCycle! Value list size too small (<2)!");
        }
        LocalizedGenericValueCycle<T> valueCycle = new LocalizedGenericValueCycle<T>(cycleLocalizationKey);
        valueCycle.values.addAll(valueList);
        return valueCycle;
    }

    protected LocalizedGenericValueCycle(String cycleLocalizationKey) {
        this.cycleLocalizationKey = cycleLocalizationKey;
    }

    @Override
    @NotNull
    public String getCycleLocalizationKey() {
        return this.cycleLocalizationKey;
    }

    @Override
    public class_5250 getCycleComponent() {
        return class_2561.method_43469((String)this.getCycleLocalizationKey(), (Object[])new Object[]{this.getCurrentValueComponent()}).method_27696(this.cycleStyle.get(this.current()));
    }

    @Override
    public class_5250 getCurrentValueComponent() {
        return class_2561.method_43470((String)this.valueNameSupplier.get(this.current())).method_27696(this.valueStyle.get(this.current()));
    }

    public LocalizedGenericValueCycle<T> setValueNameSupplier(@NotNull ConsumingSupplier<T, String> supplier) {
        this.valueNameSupplier = supplier;
        return this;
    }

    @Override
    public LocalizedGenericValueCycle<T> setCycleComponentStyleSupplier(@NotNull ConsumingSupplier<T, class_2583> supplier) {
        this.cycleStyle = supplier;
        return this;
    }

    public LocalizedGenericValueCycle<T> setValueComponentStyleSupplier(@NotNull ConsumingSupplier<T, class_2583> supplier) {
        this.valueStyle = supplier;
        return this;
    }

    @Override
    public LocalizedGenericValueCycle<T> addCycleListener(@NotNull Consumer<T> listener) {
        return (LocalizedGenericValueCycle)super.addCycleListener((Consumer)listener);
    }
}

