/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.loadingrequirement.requirements.gui;

import com.google.common.io.Files;
import de.keksuccino.fancymenu.customization.layout.Layout;
import de.keksuccino.fancymenu.customization.layout.LayoutHandler;
import de.keksuccino.fancymenu.customization.loadingrequirement.LoadingRequirement;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.fancymenu.util.rendering.ui.screen.texteditor.TextEditorFormattingRule;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.class_1074;
import org.jetbrains.annotations.NotNull;

public class IsLayoutEnabledRequirement
extends LoadingRequirement {
    public IsLayoutEnabledRequirement() {
        super("fancymenu_visibility_requirement_is_layout_enabled");
    }

    @Override
    public boolean hasValue() {
        return true;
    }

    @Override
    public boolean isRequirementMet(@Nullable String value) {
        if (value != null) {
            for (Layout s : LayoutHandler.getEnabledLayouts()) {
                if (s.layoutFile == null) continue;
                return Files.getNameWithoutExtension((String)s.layoutFile.getName()).equals(value);
            }
        }
        return false;
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return class_1074.method_4662((String)"fancymenu.helper.visibilityrequirement.is_layout_enabled", (Object[])new Object[0]);
    }

    @Override
    public List<String> getDescription() {
        return Arrays.asList(LocalizationUtils.splitLocalizedStringLines("fancymenu.helper.visibilityrequirement.is_layout_enabled.desc", new String[0]));
    }

    @Override
    public String getCategory() {
        return class_1074.method_4662((String)"fancymenu.editor.loading_requirement.category.gui", (Object[])new Object[0]);
    }

    @Override
    public String getValueDisplayName() {
        return class_1074.method_4662((String)"fancymenu.helper.visibilityrequirement.is_layout_enabled.value.desc", (Object[])new Object[0]);
    }

    @Override
    public String getValuePreset() {
        return "my_cool_main_menu_layout";
    }

    @Override
    public List<TextEditorFormattingRule> getValueFormattingRules() {
        return null;
    }
}

