/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.element.elements.button.custombutton;

import de.keksuccino.fancymenu.customization.action.blocks.GenericExecutableBlock;
import de.keksuccino.fancymenu.customization.element.AbstractElement;
import de.keksuccino.fancymenu.customization.element.ElementBuilder;
import de.keksuccino.fancymenu.customization.element.ExecutableElement;
import de.keksuccino.fancymenu.customization.element.elements.button.custombutton.ButtonEditorElement;
import de.keksuccino.fancymenu.customization.layer.ScreenCustomizationLayer;
import de.keksuccino.fancymenu.customization.layer.ScreenCustomizationLayerHandler;
import de.keksuccino.fancymenu.customization.loadingrequirement.internal.LoadingRequirementContainer;
import de.keksuccino.fancymenu.customization.placeholder.PlaceholderParser;
import de.keksuccino.fancymenu.mixin.mixins.common.client.IMixinAbstractWidget;
import de.keksuccino.fancymenu.util.enums.LocalizedCycleEnum;
import de.keksuccino.fancymenu.util.rendering.ui.tooltip.Tooltip;
import de.keksuccino.fancymenu.util.rendering.ui.tooltip.TooltipHandler;
import de.keksuccino.fancymenu.util.rendering.ui.widget.CustomizableSlider;
import de.keksuccino.fancymenu.util.rendering.ui.widget.CustomizableWidget;
import de.keksuccino.fancymenu.util.rendering.ui.widget.NavigatableWidget;
import de.keksuccino.fancymenu.util.rendering.ui.widget.slider.v2.RangeSlider;
import de.keksuccino.fancymenu.util.resource.RenderableResource;
import de.keksuccino.fancymenu.util.resource.ResourceSupplier;
import de.keksuccino.fancymenu.util.resource.resources.audio.IAudio;
import de.keksuccino.fancymenu.util.resource.resources.texture.ITexture;
import de.keksuccino.fancymenu.util.threading.MainThreadTaskExecutor;
import de.keksuccino.konkrete.input.StringUtils;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_4264;
import net.minecraft.class_7919;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ButtonElement
extends AbstractElement
implements ExecutableElement {
    private static final Logger LOGGER = LogManager.getLogger();
    @Nullable
    private class_339 widget;
    private final RangeSlider templateDummySlider = new RangeSlider(0, 0, 0, 0, (class_2561)class_2561.method_43473(), 0.0, 1.0, 0.5);
    public ResourceSupplier<IAudio> clickSound;
    public ResourceSupplier<IAudio> hoverSound;
    @Nullable
    public String label;
    @Nullable
    public String hoverLabel;
    public String tooltip;
    public ResourceSupplier<ITexture> backgroundTextureNormal;
    public ResourceSupplier<ITexture> backgroundTextureHover;
    public ResourceSupplier<ITexture> backgroundTextureInactive;
    public boolean restartBackgroundAnimationsOnHover = true;
    public boolean nineSliceCustomBackground = false;
    public int nineSliceBorderX = 5;
    public int nineSliceBorderY = 5;
    public boolean navigatable = true;
    @NotNull
    public GenericExecutableBlock actionExecutor = new GenericExecutableBlock();
    @NotNull
    public LoadingRequirementContainer activeStateSupplier = new LoadingRequirementContainer();
    public boolean isTemplate = false;
    public boolean templateApplyWidth = false;
    public boolean templateApplyHeight = false;
    public boolean templateApplyPosX = false;
    public boolean templateApplyPosY = false;
    public boolean templateApplyOpacity = false;
    public boolean templateApplyVisibility = false;
    public boolean templateApplyLabel = false;
    @NotNull
    public TemplateSharing templateShareWith = TemplateSharing.BUTTONS;
    public ResourceSupplier<ITexture> sliderBackgroundTextureNormal;
    public ResourceSupplier<ITexture> sliderBackgroundTextureHighlighted;
    public boolean nineSliceSliderHandle = false;
    public int nineSliceSliderHandleBorderX = 5;
    public int nineSliceSliderHandleBorderY = 5;
    protected static long lastTemplateUpdateButton = -1L;
    protected static ButtonElement lastTemplateButton = null;
    protected static long lastTemplateUpdateSlider = -1L;
    protected static ButtonElement lastTemplateSlider = null;

    public ButtonElement(ElementBuilder<ButtonElement, ButtonEditorElement> builder) {
        super(builder);
    }

    @Override
    public void tick() {
        if (this.getWidget() == null) {
            return;
        }
        this.updateWidget();
    }

    @Override
    public void afterConstruction() {
        ButtonElement.resetTemplateCache();
    }

    @Override
    public void method_25394(@NotNull class_332 graphics, int mouseX, int mouseY, float partial) {
        if (this.getWidget() == null) {
            return;
        }
        this.updateWidget();
        if (!this.shouldRender()) {
            return;
        }
        if (ButtonElement.isEditor()) {
            class_7919 cachedVanillaTooltip = ((IMixinAbstractWidget)this.getWidget()).get_tooltip_FancyMenu().method_56137();
            boolean cachedVisible = this.getWidget().field_22764;
            boolean cachedActive = this.getWidget().field_22763;
            this.getWidget().field_22764 = true;
            this.getWidget().field_22763 = true;
            this.getWidget().method_47400(null);
            MainThreadTaskExecutor.executeInMainThread(() -> {
                this.getWidget().field_22764 = cachedVisible;
                this.getWidget().field_22763 = cachedActive;
                this.getWidget().method_47400(cachedVanillaTooltip);
            }, MainThreadTaskExecutor.ExecuteTiming.POST_CLIENT_TICK);
        }
        this.renderElementWidget(graphics, mouseX, mouseY, partial);
    }

    @Override
    public void tickVisibleInvisible() {
        super.tickVisibleInvisible();
        if (this.getWidget() != null) {
            this.updateWidget();
        }
    }

    protected void renderElementWidget(@NotNull class_332 graphics, int mouseX, int mouseY, float partial) {
        if (this.getWidget() != null && (!this.isTemplate || ButtonElement.isEditor())) {
            if (this.getWidget().method_25364() <= 0) {
                return;
            }
            if (this.getWidget().method_25368() <= 0) {
                return;
            }
            this.getWidget().method_25394(graphics, mouseX, mouseY, partial);
        }
    }

    @Override
    @Nullable
    public List<class_364> getWidgetsToRegister() {
        if (this.isTemplate) {
            return null;
        }
        if (this.getWidget() == null) {
            return null;
        }
        return List.of(this.getWidget());
    }

    @Override
    public int getAbsoluteWidth() {
        ButtonElement template;
        if (!this.isTemplate && this.isTemplateActive() && (template = ButtonElement.getTopActiveTemplateElement(this.isSlider())) != null && template.templateApplyWidth) {
            return template.getAbsoluteWidth();
        }
        return super.getAbsoluteWidth();
    }

    @Override
    public int getAbsoluteHeight() {
        ButtonElement template;
        if (!this.isTemplate && this.isTemplateActive() && (template = ButtonElement.getTopActiveTemplateElement(this.isSlider())) != null && template.templateApplyHeight) {
            return template.getAbsoluteHeight();
        }
        return super.getAbsoluteHeight();
    }

    @Override
    public int getAbsoluteX() {
        ButtonElement template;
        if (!this.isTemplate && this.isTemplateActive() && (template = ButtonElement.getTopActiveTemplateElement(this.isSlider())) != null && template.templateApplyPosX) {
            return template.getAbsoluteX();
        }
        return super.getAbsoluteX();
    }

    @Override
    public int getAbsoluteY() {
        ButtonElement template;
        if (!this.isTemplate && this.isTemplateActive() && (template = ButtonElement.getTopActiveTemplateElement(this.isSlider())) != null && template.templateApplyPosY) {
            return template.getAbsoluteY();
        }
        return super.getAbsoluteY();
    }

    @Override
    public boolean shouldRender() {
        ButtonElement template;
        if (!this.isTemplate && this.isTemplateActive() && (template = ButtonElement.getTopActiveTemplateElement(this.isSlider())) != null && template.templateApplyVisibility) {
            return template.shouldRender();
        }
        return super.shouldRender();
    }

    public void updateWidget() {
        this.updateWidgetActiveState();
        this.updateWidgetVisibility();
        this.updateWidgetAlpha();
        this.updateWidgetTooltip();
        this.updateWidgetLabels();
        this.updateWidgetHoverSound();
        this.updateWidgetClickSound();
        this.updateWidgetTexture();
        this.updateWidgetSize();
        this.updateWidgetPosition();
        this.updateWidgetNavigatable();
    }

    public void updateWidgetActiveState() {
        if (this.getWidget() == null) {
            return;
        }
        this.getWidget().field_22763 = this.activeStateSupplier.requirementsMet();
    }

    public void updateWidgetNavigatable() {
        class_339 class_3392 = this.getWidget();
        if (class_3392 instanceof NavigatableWidget) {
            NavigatableWidget w = (NavigatableWidget)class_3392;
            w.setNavigatable(this.navigatable);
        }
    }

    public void updateWidgetVisibility() {
        class_339 class_3392 = this.getWidget();
        if (class_3392 instanceof CustomizableWidget) {
            CustomizableWidget w = (CustomizableWidget)class_3392;
            w.setHiddenFancyMenu(!this.shouldRender());
        }
    }

    public void updateWidgetAlpha() {
        if (this.getWidget() == null) {
            return;
        }
        this.getWidget().method_25350(this.getOpacity());
    }

    public void updateWidgetPosition() {
        if (this.getWidget() == null) {
            return;
        }
        this.getWidget().method_46421(this.getAbsoluteX());
        this.getWidget().method_46419(this.getAbsoluteY());
    }

    public void updateWidgetSize() {
        if (this.getWidget() == null) {
            return;
        }
        this.getWidget().method_25358(this.getAbsoluteWidth());
        ((IMixinAbstractWidget)this.getWidget()).setHeightFancyMenu(this.getAbsoluteHeight());
    }

    public void updateWidgetTooltip() {
        if (this.tooltip != null && this.getWidget() != null && this.getWidget().method_49606() && this.getWidget().field_22764 && this.shouldRender() && !ButtonElement.isEditor()) {
            String tooltip = this.tooltip.replace("%n%", "\n");
            TooltipHandler.INSTANCE.addWidgetTooltip(this.getWidget(), Tooltip.of(StringUtils.splitLines((String)PlaceholderParser.replacePlaceholders(tooltip), (String)"\n")), false, true);
        }
    }

    public void updateWidgetLabels() {
        String l = this.getLabel();
        String h = this.getHoverLabel();
        if (this.getWidget() == null) {
            return;
        }
        if (l != null) {
            this.getWidget().method_25355(ButtonElement.buildComponent(l));
        } else {
            this.getWidget().method_25355((class_2561)class_2561.method_43473());
        }
        if (h != null && this.getWidget().method_25367() && this.getWidget().field_22763) {
            this.getWidget().method_25355(ButtonElement.buildComponent(h));
        }
    }

    public void updateWidgetHoverSound() {
        class_339 class_3392 = this.getWidget();
        if (class_3392 instanceof CustomizableWidget) {
            CustomizableWidget w = (CustomizableWidget)class_3392;
            w.setHoverSoundFancyMenu(this.getPropertySource().hoverSound != null ? this.getPropertySource().hoverSound.get() : null);
        }
    }

    public void updateWidgetClickSound() {
        class_339 class_3392 = this.getWidget();
        if (class_3392 instanceof CustomizableWidget) {
            CustomizableWidget w = (CustomizableWidget)class_3392;
            w.setCustomClickSoundFancyMenu(this.getPropertySource().clickSound != null ? this.getPropertySource().clickSound.get() : null);
        }
    }

    public void updateWidgetTexture() {
        class_339 class_3392;
        class_339 class_3393;
        RenderableResource backNormal = null;
        RenderableResource backHover = null;
        RenderableResource backInactive = null;
        if (this.getPropertySource().backgroundTextureNormal != null) {
            backNormal = this.getPropertySource().backgroundTextureNormal.get();
        }
        if (this.getPropertySource().backgroundTextureHover != null) {
            backHover = this.getPropertySource().backgroundTextureHover.get();
        }
        if (this.getPropertySource().backgroundTextureInactive != null) {
            backInactive = this.getPropertySource().backgroundTextureInactive.get();
        }
        if ((class_3393 = this.getWidget()) instanceof CustomizableWidget) {
            CustomizableWidget w = (CustomizableWidget)class_3393;
            class_339 class_3394 = this.getWidget();
            if (class_3394 instanceof CustomizableSlider) {
                CustomizableSlider s = (CustomizableSlider)class_3394;
                s.setNineSliceCustomSliderBackground_FancyMenu(this.getPropertySource().nineSliceCustomBackground);
                s.setNineSliceSliderBackgroundBorderX_FancyMenu(this.getPropertySource().nineSliceBorderX);
                s.setNineSliceSliderBackgroundBorderY_FancyMenu(this.getPropertySource().nineSliceBorderY);
            } else {
                w.setNineSliceCustomBackground_FancyMenu(this.getPropertySource().nineSliceCustomBackground);
                w.setNineSliceBorderX_FancyMenu(this.getPropertySource().nineSliceBorderX);
                w.setNineSliceBorderY_FancyMenu(this.getPropertySource().nineSliceBorderY);
            }
            w.setCustomBackgroundNormalFancyMenu(backNormal);
            w.setCustomBackgroundHoverFancyMenu(backHover);
            w.setCustomBackgroundInactiveFancyMenu(backInactive);
            w.setCustomBackgroundResetBehaviorFancyMenu(this.getPropertySource().restartBackgroundAnimationsOnHover ? CustomizableWidget.CustomBackgroundResetBehavior.RESET_ON_HOVER : CustomizableWidget.CustomBackgroundResetBehavior.RESET_NEVER);
        }
        RenderableResource sliderBackNormal = null;
        RenderableResource sliderBackHighlighted = null;
        if (this.getPropertySource().sliderBackgroundTextureNormal != null) {
            sliderBackNormal = this.getPropertySource().sliderBackgroundTextureNormal.get();
        }
        if (this.getPropertySource().sliderBackgroundTextureHighlighted != null) {
            sliderBackHighlighted = this.getPropertySource().sliderBackgroundTextureHighlighted.get();
        }
        if ((class_3392 = this.getWidget()) instanceof CustomizableSlider) {
            CustomizableSlider w = (CustomizableSlider)class_3392;
            w.setNineSliceCustomSliderHandle_FancyMenu(this.getPropertySource().nineSliceSliderHandle);
            w.setNineSliceSliderHandleBorderX_FancyMenu(this.getPropertySource().nineSliceSliderHandleBorderX);
            w.setNineSliceSliderHandleBorderY_FancyMenu(this.getPropertySource().nineSliceSliderHandleBorderY);
            w.setCustomSliderBackgroundNormalFancyMenu(sliderBackNormal);
            w.setCustomSliderBackgroundHighlightedFancyMenu(sliderBackHighlighted);
        }
    }

    @Nullable
    public class_339 getWidget() {
        if (ButtonElement.isEditor() && this.isTemplate && this.templateShareWith == TemplateSharing.SLIDERS) {
            return this.templateDummySlider;
        }
        return this.widget;
    }

    public void setWidget(@Nullable class_339 widget) {
        this.widget = widget;
    }

    @Override
    @NotNull
    public GenericExecutableBlock getExecutableBlock() {
        return this.actionExecutor;
    }

    public boolean isButton() {
        return this.getWidget() instanceof class_4264;
    }

    public boolean isSlider() {
        return this.getWidget() instanceof CustomizableSlider;
    }

    public float getOpacity() {
        if (this.isTemplate) {
            return this.opacity;
        }
        ButtonElement template = ButtonElement.getTopActiveTemplateElement(this.isSlider());
        if (template != null && template.templateApplyOpacity) {
            return template.opacity;
        }
        return this.opacity;
    }

    @Nullable
    public String getLabel() {
        if (this.isTemplate) {
            return this.label;
        }
        ButtonElement template = ButtonElement.getTopActiveTemplateElement(this.isSlider());
        if (template != null && template.templateApplyLabel) {
            return template.label;
        }
        return this.label;
    }

    @Nullable
    public String getHoverLabel() {
        if (this.isTemplate) {
            return this.hoverLabel;
        }
        ButtonElement template = ButtonElement.getTopActiveTemplateElement(this.isSlider());
        if (template != null && template.templateApplyLabel) {
            return template.hoverLabel;
        }
        return this.hoverLabel;
    }

    @NotNull
    public ButtonElement getPropertySource() {
        if (this.isTemplate) {
            return this;
        }
        ButtonElement template = ButtonElement.getTopActiveTemplateElement(this.isSlider());
        if (template != null) {
            if (this.isSlider() && template.templateShareWith == TemplateSharing.BUTTONS) {
                return this;
            }
            if (this.isButton() && template.templateShareWith == TemplateSharing.SLIDERS) {
                return this;
            }
            return template;
        }
        return this;
    }

    public boolean isTemplateActive() {
        if (this.isTemplate) {
            return false;
        }
        return ButtonElement.getTopActiveTemplateElement(this.isSlider()) != null;
    }

    @Nullable
    public static ButtonElement getTopActiveTemplateElement(boolean forSlider) {
        long now = System.currentTimeMillis();
        if (!forSlider && lastTemplateUpdateButton + 100L > now) {
            return lastTemplateButton;
        }
        if (forSlider && lastTemplateUpdateSlider + 100L > now) {
            return lastTemplateSlider;
        }
        ButtonElement template = null;
        ScreenCustomizationLayer layer = ScreenCustomizationLayerHandler.getActiveLayer();
        if (layer != null) {
            for (AbstractElement e : layer.allElements) {
                if (!(e instanceof ButtonElement)) continue;
                ButtonElement b = (ButtonElement)e;
                boolean validTemplate = true;
                if (forSlider && b.templateShareWith == TemplateSharing.BUTTONS) {
                    validTemplate = false;
                }
                if (!forSlider && b.templateShareWith == TemplateSharing.SLIDERS) {
                    validTemplate = false;
                }
                if (!b.isTemplate || !b.shouldRender() || !validTemplate) continue;
                template = b;
                break;
            }
        }
        if (!forSlider) {
            lastTemplateButton = template;
            lastTemplateUpdateButton = now;
        } else {
            lastTemplateSlider = template;
            lastTemplateUpdateSlider = now;
        }
        return template;
    }

    public static void resetTemplateCache() {
        lastTemplateButton = null;
        lastTemplateUpdateButton = -1L;
        lastTemplateSlider = null;
        lastTemplateUpdateSlider = -1L;
    }

    public static enum TemplateSharing implements LocalizedCycleEnum<TemplateSharing>
    {
        BUTTONS("buttons"),
        SLIDERS("sliders");

        private final String name;

        private TemplateSharing(String name) {
            this.name = name;
        }

        @Override
        @NotNull
        public String getLocalizationKeyBase() {
            return "fancymenu.elements.button.template.share_with";
        }

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        @Override
        @NotNull
        public class_2583 getValueComponentStyle() {
            return (class_2583)WARNING_TEXT_STYLE.get();
        }

        @NotNull
        public TemplateSharing[] getValues() {
            return TemplateSharing.values();
        }

        @Override
        @Nullable
        public TemplateSharing getByNameInternal(@NotNull String name) {
            return TemplateSharing.getByName(name);
        }

        @Nullable
        public static TemplateSharing getByName(@NotNull String name) {
            for (TemplateSharing sharing : TemplateSharing.values()) {
                if (!sharing.name.equals(name)) continue;
                return sharing;
            }
            return null;
        }
    }
}

