/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.element.elements.animationcontroller;

import de.keksuccino.fancymenu.FancyMenu;
import de.keksuccino.fancymenu.customization.element.AbstractElement;
import de.keksuccino.fancymenu.customization.element.ElementBuilder;
import de.keksuccino.fancymenu.customization.element.anchor.ElementAnchorPoint;
import de.keksuccino.fancymenu.customization.element.anchor.ElementAnchorPoints;
import de.keksuccino.fancymenu.customization.element.editor.AbstractEditorElement;
import de.keksuccino.fancymenu.customization.element.elements.animationcontroller.AnimationControllerElement;
import de.keksuccino.fancymenu.customization.element.elements.animationcontroller.AnimationKeyframe;
import de.keksuccino.fancymenu.customization.layout.Layout;
import de.keksuccino.fancymenu.customization.layout.editor.LayoutEditorScreen;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.fancymenu.util.MathUtils;
import de.keksuccino.fancymenu.util.cycle.CommonCycles;
import de.keksuccino.fancymenu.util.input.CharacterFilter;
import de.keksuccino.fancymenu.util.rendering.DrawableColor;
import de.keksuccino.fancymenu.util.rendering.RenderingUtils;
import de.keksuccino.fancymenu.util.rendering.ui.UIBase;
import de.keksuccino.fancymenu.util.rendering.ui.tooltip.Tooltip;
import de.keksuccino.fancymenu.util.rendering.ui.widget.button.CycleButton;
import de.keksuccino.fancymenu.util.rendering.ui.widget.button.ExtendedButton;
import de.keksuccino.fancymenu.util.rendering.ui.widget.editbox.ExtendedEditBox;
import de.keksuccino.fancymenu.util.rendering.ui.widget.slider.v2.RangeSlider;
import de.keksuccino.fancymenu.util.window.WindowHandler;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Stack;
import java.util.function.Consumer;
import net.minecraft.class_1041;
import net.minecraft.class_1074;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.glfw.GLFW;

public class KeyframeManagerScreen
extends class_437 {
    private static final Logger LOGGER = LogManager.getLogger();
    protected static final int KEY_MOVE_KEYFRAME_LEFT = 263;
    protected static final int KEY_MOVE_KEYFRAME_RIGHT = 262;
    protected static final int KEY_DELETE_KEYFRAME = 261;
    protected static final int KEY_ADD_KEYFRAME = 75;
    protected static final int KEY_TOGGLE_RECORDING = 82;
    protected static final int KEY_TOGGLE_PAUSE_RECORDING = 84;
    protected static final int KEY_TOGGLE_PLAYING = 80;
    protected static final DrawableColor TIMELINE_COLOR = DrawableColor.of(new Color(0, 122, 204));
    protected static final DrawableColor TIMELINE_PADDING_COLOR = DrawableColor.of(new Color(3, 83, 138));
    protected static final DrawableColor KEYFRAME_COLOR = DrawableColor.of(new Color(255, 255, 255));
    protected static final DrawableColor KEYFRAME_COLOR_SELECTED = DrawableColor.of(new Color(180, 37, 196));
    protected static final DrawableColor PROGRESS_COLOR = DrawableColor.of(new Color(255, 0, 0));
    protected static final DrawableColor PREVIEW_COLOR_NORMAL = DrawableColor.of(new Color(33, 176, 58));
    protected static final DrawableColor RECORDING_COLOR = DrawableColor.of(new Color(196, 37, 37));
    protected static final DrawableColor RECORDING_PAUSED_COLOR = DrawableColor.of(new Color(219, 108, 4));
    protected static final DrawableColor OFFSET_MODE_CROSSHAIR_COLOR = DrawableColor.of(new Color(219, 108, 4));
    protected static final int TIMELINE_HEIGHT = 50;
    protected static final int TIMELINE_Y_PADDING = 20;
    protected static final int KEYFRAME_LINE_WIDTH = 2;
    protected static final int KEYFRAME_LINE_HEIGHT = 30;
    protected static final int PROGRESS_LINE_WIDTH = 2;
    protected static final int MIN_TIMELINE_DURATION = 1000;
    protected static final int TIMELINE_EXTENSION_STEP = 2000;
    protected static final long TIMELINE_PADDING_DURATION = 2000L;
    protected static final int KEYFRAME_DRAG_CRUMPLE_ZONE = 3;
    protected static final long RECORDING_BLINK_INTERVAL = 600L;
    protected static final int NOTIFICATION_PADDING = 10;
    protected static final class_2561 KEYFRAME_ADDED_TEXT = class_2561.method_43471((String)"fancymenu.elements.animation_controller.keyframe_manager.keyframe_added").method_10862(class_2583.field_24360.method_36139(UIBase.getUIColorTheme().success_text_color.getColorInt()));
    protected static final class_2561 KEYFRAME_DELETED_TEXT = class_2561.method_43471((String)"fancymenu.elements.animation_controller.keyframe_manager.keyframe_deleted").method_10862(class_2583.field_24360.method_36139(UIBase.getUIColorTheme().warning_text_color.getColorInt()));
    protected static final class_2561 PLAYING_STARTED_TEXT = class_2561.method_43471((String)"fancymenu.elements.animation_controller.keyframe_manager.playing_started").method_10862(class_2583.field_24360.method_36139(UIBase.getUIColorTheme().success_text_color.getColorInt()));
    protected static final class_2561 PLAYING_STOPPED_TEXT = class_2561.method_43471((String)"fancymenu.elements.animation_controller.keyframe_manager.playing_stopped").method_10862(class_2583.field_24360.method_36139(UIBase.getUIColorTheme().warning_text_color.getColorInt()));
    protected final AnimationControllerElement controller;
    protected final Consumer<AnimationControllerMetadata> resultCallback;
    protected final List<AnimationKeyframe> workingKeyframes;
    protected final PreviewElement previewElement;
    protected final PreviewEditorElement previewEditorElement;
    protected boolean isDraggingProgress = false;
    protected boolean isPlaying = false;
    protected long playStartTime = -1L;
    protected long currentPlayOrRecordPosition = 0L;
    protected final List<AnimationKeyframe> selectedKeyframes = new ArrayList<AnimationKeyframe>();
    protected int draggingKeyframeIndex = -1;
    protected AnimationKeyframe lastCtrlClickedFrameForDeselect = null;
    protected boolean framesGotMoved = false;
    protected int timelineX;
    protected int timelineWidth;
    protected int timelineY;
    protected long timelineDuration = 1000L;
    protected int initialDragClickX = 0;
    protected boolean hasMovedFromClickPosition = false;
    protected boolean isRecording = false;
    protected boolean isRecordingPaused = false;
    protected long recordStartTime = -1L;
    protected double recordingSpeed = 1.0;
    protected double cachedRecordingSpeed;
    protected final Map<Integer, Integer> cachedWidgetRowCurrentX = new HashMap<Integer, Integer>();
    protected long lastRecordingBlinkTime = -1L;
    protected boolean recordingBlinkState = true;
    protected final List<Notification> activeNotifications = new ArrayList<Notification>();
    protected boolean isShowingSmoothingInput = false;
    protected String lastSmoothingInputValue = null;
    protected boolean isShowingTimestampInput = false;
    protected boolean isOffsetMode = false;
    protected final Stack<List<AnimationKeyframe>> undoStack = new Stack();
    protected final Stack<List<AnimationKeyframe>> redoStack = new Stack();
    protected CycleButton<ElementAnchorPoint> anchorButton;
    protected CycleButton<CommonCycles.CycleEnabledDisabled> stickyButton;
    protected ExtendedButton undoButton;
    protected ExtendedButton redoButton;
    protected ExtendedButton deleteKeyframeButton;
    protected ExtendedButton playButton;
    protected ExtendedButton startStopRecordingButton;
    protected RangeSlider recordingSpeedSlider;
    protected ExtendedButton smoothingButton;
    protected ExtendedEditBox smoothingDistanceInput;
    protected ExtendedEditBox timestampInput;
    protected int lastGuiScaleCorrectionWidth = 0;
    protected int lastGuiScaleCorrectionHeight = 0;

    public KeyframeManagerScreen(AnimationControllerElement controller, Consumer<AnimationControllerMetadata> resultCallback) {
        super((class_2561)class_2561.method_43471((String)"fancymenu.elements.animation_controller.keyframe_manager"));
        this.controller = controller;
        this.isOffsetMode = this.controller.offsetMode;
        this.resultCallback = resultCallback;
        this.workingKeyframes = new ArrayList<AnimationKeyframe>(controller.keyframes.stream().map(AnimationKeyframe::clone).toList());
        this.workingKeyframes.sort(Comparator.comparingLong(k -> k.timestamp));
        for (AnimationKeyframe kf : this.workingKeyframes) {
            this.timelineDuration = Math.max(this.timelineDuration, kf.timestamp);
        }
        this.timelineDuration += 2000L;
        this.previewElement = new PreviewElement(controller.builder);
        this.previewElement.baseWidth = 50;
        this.previewElement.baseHeight = 50;
        this.previewElement.posOffsetX = 0;
        this.previewElement.posOffsetY = 0;
        this.previewElement.stayOnScreen = false;
        this.previewElement.stickyAnchor = true;
        this.previewElement.anchorPoint = ElementAnchorPoints.MID_CENTERED;
        if (!this.workingKeyframes.isEmpty()) {
            this.applyKeyframeValuesToElement(this.workingKeyframes.getFirst(), this.previewElement);
        }
        this.previewEditorElement = new PreviewEditorElement(this.previewElement, new LayoutEditorScreen(Layout.buildUniversal()));
        this.saveState();
    }

    protected void method_25426() {
        boolean tooFarRight;
        this.timelineX = 50;
        this.timelineWidth = this.field_22789 - 100;
        this.timelineY = this.field_22790 - 50 - 20;
        this.cachedWidgetRowCurrentX.clear();
        int buttonBaseWidth = 60;
        ExtendedButton cancelButton = UIBase.applyDefaultWidgetSkinTo(new ExtendedButton(10, 10, buttonBaseWidth, 20, (class_2561)class_2561.method_43471((String)"gui.cancel"), button -> this.resultCallback.accept(null)));
        this.method_37063((class_364)cancelButton);
        ExtendedButton doneButton = UIBase.applyDefaultWidgetSkinTo(new ExtendedButton(80, 10, buttonBaseWidth, 20, (class_2561)class_2561.method_43471((String)"gui.done"), button -> this.resultCallback.accept(new AnimationControllerMetadata(this.workingKeyframes, this.isOffsetMode))));
        this.method_37063((class_364)doneButton);
        this.playButton = UIBase.applyDefaultWidgetSkinTo(new ExtendedButton(0, 0, buttonBaseWidth, 0, (class_2561)class_2561.method_43473(), button -> this.togglePlayback()));
        this.playButton.setLabelSupplier(consumes -> class_2561.method_43471((String)(this.isPlaying ? "fancymenu.elements.animation_controller.keyframe_manager.pause" : "fancymenu.elements.animation_controller.keyframe_manager.play")));
        this.playButton.setIsActiveSupplier(consumes -> !this.isRecording);
        this.addBottomWidget(1, 0, this.playButton);
        this.startStopRecordingButton = UIBase.applyDefaultWidgetSkinTo(new ExtendedButton(0, 0, buttonBaseWidth, 0, (class_2561)class_2561.method_43473(), button -> this.toggleRecording()));
        this.startStopRecordingButton.setLabelSupplier(consumes -> class_2561.method_43471((String)(this.isRecording ? "fancymenu.elements.animation_controller.keyframe_manager.stop_recording" : "fancymenu.elements.animation_controller.keyframe_manager.start_recording")));
        this.startStopRecordingButton.setIsActiveSupplier(consumes -> !this.isPlaying);
        this.addBottomWidget(1, 0, this.startStopRecordingButton);
        this.recordingSpeedSlider = new RangeSlider(0, 0, buttonBaseWidth + 60, 20, (class_2561)class_2561.method_43473(), 0.0, 100.0, this.recordingSpeed * 100.0);
        this.recordingSpeedSlider.setShowAsInteger(true);
        this.recordingSpeedSlider.setLabelSupplier(slider -> {
            String speedText = slider.getValueDisplayText() + "%";
            return class_2561.method_43469((String)"fancymenu.elements.animation_controller.keyframe_manager.recording_speed", (Object[])new Object[]{speedText});
        });
        this.recordingSpeedSlider.setSliderValueUpdateListener((slider, valueDisplayText, value) -> this.setRecordingSpeed(value));
        this.recordingSpeedSlider.setFocusable(true);
        this.recordingSpeedSlider.setNavigatable(true);
        UIBase.applyDefaultWidgetSkinTo(this.recordingSpeedSlider);
        this.addBottomWidget(1, 0, this.recordingSpeedSlider);
        ExtendedButton addKeyframeButton = UIBase.applyDefaultWidgetSkinTo(new ExtendedButton(0, 0, buttonBaseWidth, 0, (class_2561)class_2561.method_43471((String)"fancymenu.elements.animation_controller.keyframe_manager.add_keyframe"), button -> this.addKeyframeAtProgress()));
        addKeyframeButton.setIsActiveSupplier(consumes -> this.isRecording && this.selectedKeyframes.isEmpty());
        this.addBottomWidget(1, 0, addKeyframeButton);
        this.deleteKeyframeButton = UIBase.applyDefaultWidgetSkinTo(new ExtendedButton(0, 0, buttonBaseWidth, 0, (class_2561)class_2561.method_43471((String)"fancymenu.elements.animation_controller.keyframe_manager.delete_keyframe"), button -> this.deleteSelectedKeyframes()));
        this.deleteKeyframeButton.setIsActiveSupplier(consumes -> !this.selectedKeyframes.isEmpty());
        this.addBottomWidget(1, 0, this.deleteKeyframeButton);
        this.smoothingButton = UIBase.applyDefaultWidgetSkinTo(new ExtendedButton(0, 0, buttonBaseWidth, 0, (class_2561)class_2561.method_43471((String)"fancymenu.elements.animation_controller.keyframe_manager.smoothing"), button -> this.toggleSmoothingInput()));
        this.smoothingButton.setIsActiveSupplier(consumes -> !this.isPlaying && !this.isRecording && this.selectedKeyframes.size() > 1 && !this.isShowingTimestampInput);
        this.smoothingButton.setTooltipSupplier(consumes -> Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.elements.animation_controller.keyframe_manager.smoothing.desc", new String[0])));
        this.addBottomWidget(1, 0, this.smoothingButton);
        CycleButton<CommonCycles.CycleEnabledDisabled> offsetModeButton = new CycleButton<CommonCycles.CycleEnabledDisabled>(0, 0, buttonBaseWidth, 0, CommonCycles.cycleEnabledDisabled("fancymenu.elements.animation_controller.keyframe_manager.offset_mode", this.isOffsetMode), (value, button) -> this.setOffsetMode(value.getAsBoolean()));
        offsetModeButton.setTooltipSupplier(consumes -> Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.elements.animation_controller.keyframe_manager.offset_mode.desc", new String[0])));
        this.addBottomWidget(1, 0, (class_339)offsetModeButton);
        this.undoButton = UIBase.applyDefaultWidgetSkinTo(new ExtendedButton(0, 0, buttonBaseWidth, 0, (class_2561)class_2561.method_43471((String)"fancymenu.editor.edit.undo"), button -> this.undo()));
        this.undoButton.setIsActiveSupplier(consumes -> !this.undoStack.isEmpty() && !this.isPlaying);
        this.addBottomWidget(2, 0, this.undoButton);
        this.redoButton = UIBase.applyDefaultWidgetSkinTo(new ExtendedButton(0, 0, buttonBaseWidth, 0, (class_2561)class_2561.method_43471((String)"fancymenu.editor.edit.redo"), button -> this.redo()));
        this.redoButton.setIsActiveSupplier(consumes -> !this.redoStack.isEmpty() && !this.isPlaying);
        this.addBottomWidget(2, 0, this.redoButton);
        List<ElementAnchorPoint> anchorPoints = ElementAnchorPoints.getAnchorPoints();
        anchorPoints.remove(ElementAnchorPoints.ELEMENT);
        anchorPoints.remove(ElementAnchorPoints.VANILLA);
        this.anchorButton = new CycleButton<ElementAnchorPoint>(0, 0, buttonBaseWidth + 105, 0, CommonCycles.cycle("fancymenu.elements.animation_controller.keyframe_manager.anchor_point_cycle", anchorPoints, ElementAnchorPoints.TOP_LEFT).setValueNameSupplier(ElementAnchorPoint::getName).setValueComponentStyleSupplier(consumes -> class_2583.field_24360.method_36139(UIBase.getUIColorTheme().warning_text_color.getColorInt())), (value, button) -> this.setAnchorPoint((ElementAnchorPoint)value));
        this.anchorButton.setIsActiveSupplier(consumes -> (this.selectedKeyframes.size() == 1 || this.isRecording) && !this.isOffsetMode);
        this.addBottomWidget(2, 0, (class_339)this.anchorButton);
        this.stickyButton = new CycleButton<CommonCycles.CycleEnabledDisabled>(0, 0, buttonBaseWidth + 65, 0, CommonCycles.cycleEnabledDisabled("fancymenu.elements.animation_controller.keyframe_manager.sticky"), (value, button) -> this.setStickyAnchor(value.getAsBoolean()));
        this.stickyButton.setIsActiveSupplier(consumes -> (this.selectedKeyframes.size() == 1 || this.isRecording) && !this.isOffsetMode);
        this.addBottomWidget(2, 0, (class_339)this.stickyButton);
        ExtendedButton timestampButton = UIBase.applyDefaultWidgetSkinTo(new ExtendedButton(0, 0, buttonBaseWidth, 0, (class_2561)class_2561.method_43471((String)"fancymenu.elements.animation_controller.keyframe_manager.timestamp_edit"), button -> this.toggleTimestampInput()));
        timestampButton.setIsActiveSupplier(consumes -> !this.isPlaying && !this.isRecording && this.selectedKeyframes.size() == 1 && !this.isShowingSmoothingInput);
        timestampButton.setTooltipSupplier(consumes -> Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.elements.animation_controller.keyframe_manager.timestamp_edit.desc", new String[0])));
        this.addBottomWidget(2, 0, timestampButton);
        CycleButton<CommonCycles.CycleEnabledDisabled> previewMovingButton = new CycleButton<CommonCycles.CycleEnabledDisabled>(0, 0, buttonBaseWidth + 65, 0, CommonCycles.cycleEnabledDisabled("fancymenu.elements.animation_controller.keyframe_manager.move_preview_with_arrow_keys", FancyMenu.getOptions().arrowKeysMovePreview.getValue()), (value, button) -> FancyMenu.getOptions().arrowKeysMovePreview.setValue(value.getAsBoolean()));
        previewMovingButton.setTooltipSupplier(consumes -> Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.elements.animation_controller.keyframe_manager.move_preview_with_arrow_keys.desc", new String[0])));
        this.addBottomWidget(2, 0, (class_339)previewMovingButton);
        this.smoothingDistanceInput = new ExtendedEditBox(this, class_310.method_1551().field_1772, this.field_22789 / 2 - 50, this.stickyButton.method_46427() - 40, 100, 20, (class_2561)class_2561.method_43473()){

            @Override
            public void method_48579(@NotNull class_332 graphics, int mouseX, int mouseY, float partial) {
                class_5250 c = class_2561.method_43471((String)"fancymenu.elements.animation_controller.keyframe_manager.smoothing.input");
                int cW = class_310.method_1551().field_1772.method_27525((class_5348)c);
                class_327 class_3272 = class_310.method_1551().field_1772;
                int n = this.method_46426() + this.method_25368() / 2 - cW / 2;
                int n2 = this.method_46427();
                Objects.requireNonNull(class_310.method_1551().field_1772);
                graphics.method_51439(class_3272, (class_2561)c, n, n2 - 9 - 5, UIBase.getUIColorTheme().generic_text_base_color.getColorInt(), false);
                super.method_48579(graphics, mouseX, mouseY, partial);
            }
        };
        this.smoothingDistanceInput.setCharacterFilter(CharacterFilter.buildIntegerFiler());
        this.smoothingDistanceInput.setIsVisibleSupplier(consumes -> this.isShowingSmoothingInput);
        this.smoothingDistanceInput.method_1880(6);
        UIBase.applyDefaultWidgetSkinTo(this.smoothingDistanceInput);
        this.method_37063((class_364)this.smoothingDistanceInput);
        this.timestampInput = new ExtendedEditBox(this, class_310.method_1551().field_1772, this.field_22789 / 2 - 50, this.stickyButton.method_46427() - 40, 100, 20, (class_2561)class_2561.method_43473()){

            @Override
            public void method_48579(@NotNull class_332 graphics, int mouseX, int mouseY, float partial) {
                class_5250 c = class_2561.method_43471((String)"fancymenu.elements.animation_controller.keyframe_manager.timestamp_edit.input");
                int cW = class_310.method_1551().field_1772.method_27525((class_5348)c);
                class_327 class_3272 = class_310.method_1551().field_1772;
                int n = this.method_46426() + this.method_25368() / 2 - cW / 2;
                int n2 = this.method_46427();
                Objects.requireNonNull(class_310.method_1551().field_1772);
                graphics.method_51439(class_3272, (class_2561)c, n, n2 - 9 - 5, UIBase.getUIColorTheme().generic_text_base_color.getColorInt(), false);
                super.method_48579(graphics, mouseX, mouseY, partial);
            }
        };
        this.timestampInput.setCharacterFilter(CharacterFilter.buildIntegerFiler());
        this.timestampInput.setIsVisibleSupplier(consumes -> this.isShowingTimestampInput);
        this.timestampInput.method_1880(20);
        UIBase.applyDefaultWidgetSkinTo(this.timestampInput);
        this.method_37063((class_364)this.timestampInput);
        if (!this.isPlaying && !this.isRecording) {
            this.updateTimelineDurationToMaxTimestamp();
        }
        CycleButton<CommonCycles.CycleEnabledDisabled> farRightWidget = previewMovingButton;
        class_1041 window = class_310.method_1551().method_22683();
        boolean resized = window.method_4480() != this.lastGuiScaleCorrectionWidth || window.method_4507() != this.lastGuiScaleCorrectionHeight;
        this.lastGuiScaleCorrectionWidth = window.method_4480();
        this.lastGuiScaleCorrectionHeight = window.method_4507();
        boolean bl = tooFarRight = farRightWidget.method_46426() + farRightWidget.method_25368() >= this.field_22789 - 100;
        if (tooFarRight && WindowHandler.getGuiScale() > 1.0) {
            double newScale = WindowHandler.getGuiScale();
            if ((newScale -= 1.0) < 1.0) {
                newScale = 1.0;
            }
            WindowHandler.setGuiScale(newScale);
            this.method_25410(class_310.method_1551(), window.method_4486(), window.method_4502());
        } else if (!tooFarRight && resized) {
            RenderingUtils.resetGuiScale();
            this.method_25410(class_310.method_1551(), window.method_4486(), window.method_4502());
        }
    }

    protected <T extends class_339> T addBottomWidget(int row, int spacingAfterButtonOffset, @NotNull T widget) {
        if (row < 1) {
            row = 1;
        }
        if (!this.cachedWidgetRowCurrentX.containsKey(row)) {
            this.cachedWidgetRowCurrentX.put(row, this.timelineX);
        }
        int currentX = this.cachedWidgetRowCurrentX.get(row);
        int y = this.timelineY - 25 - 25 * (row - 1);
        int buttonSpacing = 5 + spacingAfterButtonOffset;
        widget.method_46421(currentX);
        widget.method_46419(y);
        widget.method_53533(20);
        int labelWidth = class_310.method_1551().field_1772.method_27525((class_5348)widget.method_25369());
        if (labelWidth + 10 > widget.method_25368()) {
            widget.method_25358(labelWidth + 10);
        }
        UIBase.applyDefaultWidgetSkinTo(widget);
        this.method_37063((class_364)widget);
        int newCurrentX = currentX + widget.method_25368() + buttonSpacing;
        this.cachedWidgetRowCurrentX.put(row, newCurrentX);
        return widget;
    }

    public void method_25394(@NotNull class_332 graphics, int mouseX, int mouseY, float partial) {
        if (this.isShowingSmoothingInput) {
            if (!this.smoothingDistanceInput.method_25370()) {
                this.smoothingDistanceInput.setFocusable(true);
                this.method_25395((class_364)this.smoothingDistanceInput);
            }
        } else if (this.smoothingDistanceInput == this.method_25399()) {
            this.method_48267();
        }
        if (this.isShowingTimestampInput && this.selectedKeyframes.size() != 1) {
            this.isShowingTimestampInput = false;
        }
        if (this.isShowingTimestampInput) {
            if (!this.timestampInput.method_25370()) {
                this.timestampInput.setFocusable(true);
                this.method_25395((class_364)this.timestampInput);
            }
        } else if (this.timestampInput == this.method_25399()) {
            this.method_48267();
        }
        long actualEndTime = this.timelineDuration - 2000L;
        if (this.isRecording && !this.isPlaying && !this.isRecordingPaused) {
            long now = System.currentTimeMillis();
            long actualElapsed = now - this.recordStartTime;
            this.currentPlayOrRecordPosition = (long)((double)actualElapsed * this.recordingSpeed);
            long trimmedActualDuration = this.timelineDuration - 2000L - 2000L;
            if (this.currentPlayOrRecordPosition >= trimmedActualDuration) {
                this.updateTimelineDuration(this.timelineDuration - 2000L + 2000L);
                actualEndTime = this.timelineDuration - 2000L;
            }
        }
        if (this.isPlaying && !this.isRecording) {
            this.currentPlayOrRecordPosition = System.currentTimeMillis() - this.playStartTime;
            if (this.currentPlayOrRecordPosition > this.timelineDuration) {
                this.isPlaying = false;
                this.currentPlayOrRecordPosition = 0L;
            }
        }
        graphics.method_25294(0, 0, this.field_22789, this.field_22790, UIBase.getUIColorTheme().screen_background_color.getColorInt());
        this.renderTimelineBackground(graphics, actualEndTime);
        this.renderKeyframeLines(graphics, mouseX, mouseY, partial, actualEndTime);
        this.renderProgressLine(graphics, mouseX, mouseY, partial, actualEndTime);
        this.tickAnimation();
        this.renderPreview(graphics, mouseX, mouseY, partial);
        this.renderTimeText(graphics, actualEndTime);
        this.renderKeyframeInfo(graphics, mouseX, mouseY, partial);
        this.renderRecordingIndicator(graphics, mouseX, mouseY, partial);
        this.renderOffsetModeCrosshair(graphics);
        this.renderNotifications(graphics, mouseX, mouseY, partial);
        super.method_25394(graphics, mouseX, mouseY, partial);
    }

    protected void tickAnimation() {
        if (this.isRecording && !this.isRecordingPaused) {
            return;
        }
        AnimationKeyframe currentFrame = null;
        AnimationKeyframe nextFrame = null;
        for (int i = 0; i < this.workingKeyframes.size() - 1; ++i) {
            AnimationKeyframe k1 = this.workingKeyframes.get(i);
            AnimationKeyframe k2 = this.workingKeyframes.get(i + 1);
            if (this.currentPlayOrRecordPosition < k1.timestamp || this.currentPlayOrRecordPosition >= k2.timestamp) continue;
            currentFrame = k1;
            nextFrame = k2;
            break;
        }
        if ((this.isPlaying || this.isDraggingProgress) && currentFrame != null && nextFrame != null) {
            this.selectKeyframeClearOldSelection(null);
            float progress = (float)(this.currentPlayOrRecordPosition - currentFrame.timestamp) / (float)(nextFrame.timestamp - currentFrame.timestamp);
            if (this.isOffsetMode) {
                this.previewElement.animatedOffsetX = (int)this.lerp(currentFrame.posOffsetX, nextFrame.posOffsetX, progress);
                this.previewElement.animatedOffsetY = (int)this.lerp(currentFrame.posOffsetY, nextFrame.posOffsetY, progress);
                this.previewElement.posOffsetX = 0;
                this.previewElement.posOffsetY = 0;
            } else {
                this.previewElement.posOffsetX = (int)this.lerp(currentFrame.posOffsetX, nextFrame.posOffsetX, progress);
                this.previewElement.posOffsetY = (int)this.lerp(currentFrame.posOffsetY, nextFrame.posOffsetY, progress);
            }
            this.previewElement.baseWidth = (int)this.lerp(currentFrame.baseWidth, nextFrame.baseWidth, progress);
            this.previewElement.baseHeight = (int)this.lerp(currentFrame.baseHeight, nextFrame.baseHeight, progress);
            this.previewElement.anchorPoint = this.isOffsetMode ? ElementAnchorPoints.MID_CENTERED : nextFrame.anchorPoint;
            this.previewElement.stickyAnchor = nextFrame.stickyAnchor;
        }
    }

    protected void renderOffsetModeCrosshair(@NotNull class_332 graphics) {
        if (!this.isOffsetMode) {
            return;
        }
        int centerX = this.field_22789 / 2;
        int centerY = this.field_22790 / 2;
        graphics.method_25294(centerX - 10, centerY - 1, centerX + 10, centerY + 1, OFFSET_MODE_CROSSHAIR_COLOR.getColorInt());
        graphics.method_25294(centerX - 1, centerY - 10, centerX + 1, centerY + 10, OFFSET_MODE_CROSSHAIR_COLOR.getColorInt());
    }

    protected void renderTimelineBackground(@NotNull class_332 graphics, long actualEndTime) {
        float usableWidth = (float)this.timelineWidth * ((float)Math.max(actualEndTime + 2000L, 1000L) / (float)this.timelineDuration);
        graphics.method_25294(this.timelineX, this.timelineY, this.timelineX + (int)((float)actualEndTime / (float)this.timelineDuration * usableWidth), this.timelineY + 50, TIMELINE_COLOR.getColorInt());
        int paddingStartX = this.timelineX + (int)((float)actualEndTime / (float)this.timelineDuration * usableWidth);
        graphics.method_25294(paddingStartX, this.timelineY, this.timelineX + (int)usableWidth, this.timelineY + 50, TIMELINE_PADDING_COLOR.getColorInt());
    }

    protected void renderKeyframeLines(@NotNull class_332 graphics, int mouseX, int mouseY, float partial, long actualDuration) {
        for (int i = 0; i < this.workingKeyframes.size(); ++i) {
            long maxRightPosition;
            AnimationKeyframe keyframe = this.workingKeyframes.get(i);
            float progress = (float)keyframe.timestamp / (float)this.timelineDuration;
            int lineX = this.timelineX + (int)((float)this.timelineWidth * progress);
            DrawableColor color = this.selectedKeyframes.contains(keyframe) ? KEYFRAME_COLOR_SELECTED : KEYFRAME_COLOR;
            graphics.method_25294(lineX - 1, this.timelineY + 10, lineX + 1, this.timelineY + 40, color.getColorInt());
            if (this.draggingKeyframeIndex != i) continue;
            int dragDeltaX = mouseX - this.initialDragClickX;
            if (!this.hasMovedFromClickPosition) {
                boolean bl = this.hasMovedFromClickPosition = Math.abs(dragDeltaX) >= 3;
                if (!this.hasMovedFromClickPosition) continue;
                this.framesGotMoved = true;
                this.saveState();
            }
            float newProgress = (float)(mouseX - this.timelineX) / (float)this.timelineWidth;
            long newDuration = this.timelineDuration;
            if (!this.isRecording && mouseX > this.timelineX + this.timelineWidth - 10) {
                newDuration = this.timelineDuration + 2000L;
                newProgress = (float)(mouseX - this.timelineX) / (float)this.timelineWidth;
            }
            newProgress = Math.max(0.0f, Math.min(1.0f, newProgress));
            long timeDelta = (long)((float)newDuration * newProgress) - keyframe.timestamp;
            long minSelectedTimestamp = Long.MAX_VALUE;
            long maxSelectedTimestamp = Long.MIN_VALUE;
            long deltaToLastFrame = 0L;
            for (AnimationKeyframe selectedFrame : this.selectedKeyframes) {
                minSelectedTimestamp = Math.min(minSelectedTimestamp, selectedFrame.timestamp);
                maxSelectedTimestamp = Math.max(maxSelectedTimestamp, selectedFrame.timestamp);
                if (selectedFrame.timestamp <= keyframe.timestamp) continue;
                deltaToLastFrame = Math.max(deltaToLastFrame, selectedFrame.timestamp - keyframe.timestamp);
            }
            long maxLeftShift = -minSelectedTimestamp;
            if (timeDelta < maxLeftShift) {
                timeDelta = maxLeftShift;
            }
            if (this.isRecording && keyframe.timestamp + timeDelta > (maxRightPosition = actualDuration - deltaToLastFrame)) {
                timeDelta = maxRightPosition - keyframe.timestamp;
            }
            for (AnimationKeyframe selectedFrame : this.selectedKeyframes) {
                long newTimestamp = selectedFrame.timestamp + timeDelta;
                newTimestamp = Math.max(0L, newTimestamp);
                if (this.isRecording) {
                    newTimestamp = Math.min(newTimestamp, actualDuration);
                }
                selectedFrame.timestamp = newTimestamp;
            }
            this.updateTimelineDurationToMaxTimestamp();
        }
    }

    protected void renderPreview(@NotNull class_332 graphics, int mouseX, int mouseY, float partial) {
        if (!this.isPlaying && (this.selectedKeyframes.size() == 1 || this.isRecording)) {
            this.previewEditorElement.method_25394(graphics, mouseX, mouseY, partial);
        } else {
            this.previewEditorElement.renderPreviewBody(graphics, mouseX, mouseY, partial);
        }
    }

    protected void renderProgressLine(@NotNull class_332 graphics, int mouseX, int mouseY, float partial, long actualDuration) {
        float playProgress = (float)this.currentPlayOrRecordPosition / (float)this.timelineDuration;
        int progressX = this.timelineX + (int)((float)this.timelineWidth * playProgress);
        if (this.isDraggingProgress && (!this.isRecording || this.isRecordingPaused)) {
            float newProgress = (float)(mouseX - this.timelineX) / (float)this.timelineWidth;
            if (this.isRecording) {
                float maxProgress = (float)actualDuration / (float)this.timelineDuration;
                newProgress = Math.max(0.0f, Math.min(maxProgress, newProgress));
            } else {
                newProgress = Math.max(0.0f, Math.min(1.0f, newProgress));
            }
            this.currentPlayOrRecordPosition = (long)((float)this.timelineDuration * newProgress);
            if (this.isPlaying) {
                this.playStartTime = System.currentTimeMillis() - this.currentPlayOrRecordPosition;
            }
            progressX = this.timelineX + (int)((float)this.timelineWidth * newProgress);
        }
        graphics.method_25294(progressX - 1, this.timelineY, progressX + 1, this.timelineY + 50, PROGRESS_COLOR.getColorIntWithAlpha(0.7f));
    }

    protected void renderTimeText(@NotNull class_332 graphics, long actualEndTime) {
        String currentTimeStr = this.formatTime(this.currentPlayOrRecordPosition);
        String totalTimeStr = this.formatTime(actualEndTime);
        int currentTimeColor = this.currentPlayOrRecordPosition > actualEndTime ? UIBase.getUIColorTheme().warning_text_color.getColorInt() : UIBase.getUIColorTheme().generic_text_base_color.getColorInt();
        class_5250 currentTimeComp = class_2561.method_43470((String)currentTimeStr).method_10862(class_2583.field_24360.method_36139(currentTimeColor));
        class_5250 totalTimeComp = class_2561.method_43470((String)totalTimeStr);
        class_5250 baseComp = class_2561.method_43469((String)"fancymenu.elements.animation_controller.keyframe_manager.time", (Object[])new Object[]{currentTimeComp, totalTimeComp});
        graphics.method_51439(class_310.method_1551().field_1772, (class_2561)baseComp, this.timelineX, this.timelineY + 50 + 5, UIBase.getUIColorTheme().generic_text_base_color.getColorInt(), false);
    }

    protected void renderKeyframeInfo(@NotNull class_332 graphics, int mouseX, int mouseY, float partial) {
        if (this.selectedKeyframes.size() == 1) {
            AnimationKeyframe selectedKeyframe = this.selectedKeyframes.getFirst();
            String yes = class_1074.method_4662((String)"fancymenu.elements.animation_controller.keyframe_manager.keyframe_info.yes", (Object[])new Object[0]);
            String no = class_1074.method_4662((String)"fancymenu.elements.animation_controller.keyframe_manager.keyframe_info.no", (Object[])new Object[0]);
            class_2561[] lines = LocalizationUtils.splitLocalizedLines("fancymenu.elements.animation_controller.keyframe_manager.keyframe_info", this.formatTime(selectedKeyframe.timestamp), "" + selectedKeyframe.posOffsetX, "" + selectedKeyframe.posOffsetY, "" + selectedKeyframe.baseWidth, "" + selectedKeyframe.baseHeight, selectedKeyframe.anchorPoint.getName(), selectedKeyframe.stickyAnchor ? yes : no);
            int yOffset = 40;
            for (class_2561 line : lines) {
                graphics.method_51439(class_310.method_1551().field_1772, line, 10, yOffset, UIBase.getUIColorTheme().generic_text_base_color.getColorInt(), false);
                yOffset += 10;
            }
        }
    }

    protected void renderRecordingIndicator(@NotNull class_332 graphics, int mouseX, int mouseY, float partial) {
        if (this.isRecording) {
            int n;
            long currentTime = System.currentTimeMillis();
            if (currentTime - this.lastRecordingBlinkTime > 600L) {
                this.recordingBlinkState = !this.recordingBlinkState;
                this.lastRecordingBlinkTime = currentTime;
            }
            class_5250 recordingText = class_2561.method_43471((String)"fancymenu.elements.animation_controller.keyframe_manager.recording").method_10862(class_2583.field_24360.method_36139(RECORDING_COLOR.getColorInt()));
            class_5250 manualModeText = class_2561.method_43471((String)"fancymenu.elements.animation_controller.keyframe_manager.recording_speed.manual_mode").method_10862(class_2583.field_24360.method_36139(RECORDING_PAUSED_COLOR.getColorInt()));
            int recordingTextWidth = class_310.method_1551().field_1772.method_27525((class_5348)recordingText);
            int manualModeTextWidth = class_310.method_1551().field_1772.method_27525((class_5348)manualModeText);
            int rectSize = 20;
            int padding = 5;
            int totalWidthRecordingText = recordingTextWidth + padding + rectSize;
            int totalWidthManualModeText = manualModeTextWidth + padding + rectSize;
            int xOffset = 10;
            int yOffset = 10;
            int recordingTextX = this.field_22789 - totalWidthRecordingText - xOffset;
            int manualModeTextX = this.field_22789 - totalWidthManualModeText - xOffset;
            if (!this.isRecordingPaused) {
                int n2 = rectSize / 2;
                Objects.requireNonNull(class_310.method_1551().field_1772);
                n = n2 - 9 / 2;
            } else {
                n = 0;
            }
            int recordingTextOffsetY = n;
            graphics.method_51439(class_310.method_1551().field_1772, (class_2561)recordingText, recordingTextX, yOffset + recordingTextOffsetY, -1, false);
            if (this.isRecordingPaused) {
                class_327 class_3272 = class_310.method_1551().field_1772;
                Objects.requireNonNull(class_310.method_1551().field_1772);
                graphics.method_51439(class_3272, (class_2561)manualModeText, manualModeTextX, yOffset + rectSize - 9, -1, false);
            }
            if (this.recordingBlinkState) {
                int rectX = recordingTextX + recordingTextWidth + padding;
                graphics.method_25294(rectX, yOffset, rectX + rectSize, yOffset + rectSize, RECORDING_COLOR.getColorInt());
            }
        }
    }

    protected void renderNotifications(@NotNull class_332 graphics, int mouseX, int mouseY, float partial) {
        Iterator<Notification> iterator = this.activeNotifications.iterator();
        int notificationYOffset = 10;
        if (this.isRecording) {
            notificationYOffset += 30;
        }
        while (iterator.hasNext()) {
            Notification notification = iterator.next();
            if (notification.isExpired()) {
                iterator.remove();
                continue;
            }
            notification.updateOpacity();
            int textColor = UIBase.getUIColorTheme().generic_text_base_color.getColorIntWithAlpha(notification.opacity);
            graphics.method_51439(class_310.method_1551().field_1772, notification.message, this.field_22789 - class_310.method_1551().field_1772.method_27525((class_5348)notification.message) - 10, notificationYOffset, textColor, false);
            notificationYOffset += notification.getHeight();
        }
    }

    protected void updateTimelineDurationToMaxTimestamp() {
        if (this.isRecording) {
            return;
        }
        long maxTimestamp = 0L;
        for (AnimationKeyframe kf : this.workingKeyframes) {
            maxTimestamp = Math.max(maxTimestamp, kf.timestamp);
        }
        this.updateTimelineDuration(maxTimestamp);
    }

    protected void updateTimelineDuration(long newDurationWithoutPadding) {
        long newDuration = newDurationWithoutPadding + 2000L;
        this.timelineDuration = Math.max(1000L, newDuration);
    }

    protected String formatTime(long milliseconds) {
        if (this.timelineDuration < 2000L) {
            return milliseconds + "ms";
        }
        return String.format("%.1fs", Float.valueOf((float)milliseconds / 1000.0f));
    }

    public void method_25420(@NotNull class_332 graphics, int mouseX, int mouseY, float partial) {
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        this.lastCtrlClickedFrameForDeselect = null;
        this.framesGotMoved = false;
        if (super.method_25402(mouseX, mouseY, button)) {
            return true;
        }
        if (this.isShowingSmoothingInput && !this.smoothingDistanceInput.method_25405(mouseX, mouseY)) {
            this.lastSmoothingInputValue = this.smoothingDistanceInput.method_1882();
            this.isShowingSmoothingInput = false;
        }
        if (this.isShowingTimestampInput && !this.timestampInput.method_25405(mouseX, mouseY)) {
            this.isShowingTimestampInput = false;
        }
        if (this.previewEditorElement.method_25402(mouseX, mouseY, button)) {
            return true;
        }
        if (this.isOverProgressLine((int)mouseX, (int)mouseY) && (!this.isRecording || this.isRecordingPaused)) {
            this.isDraggingProgress = true;
            return true;
        }
        if (this.isOverProgressLine((int)mouseX, (int)mouseY) && this.isRecording && !this.isRecordingPaused) {
            this.displayNotification((class_2561)class_2561.method_43471((String)"fancymenu.elements.animation_controller.keyframe_manager.pause_recording_to_drag_progress").method_10862(class_2583.field_24360.method_36139(UIBase.getUIColorTheme().warning_text_color.getColorInt())), 6000L);
            return true;
        }
        int clickedIndex = this.getKeyframeIndexAtPosition((int)mouseX, (int)mouseY);
        if (!class_437.method_25441() && this.isInTimelineArea((int)mouseX, (int)mouseY) && clickedIndex == -1) {
            this.selectKeyframeClearOldSelection(null);
            return true;
        }
        if (this.isRecording && !this.isRecordingPaused && clickedIndex >= 0) {
            this.displayNotification((class_2561)class_2561.method_43471((String)"fancymenu.elements.animation_controller.keyframe_manager.pause_recording_to_edit_keyframe").method_10862(class_2583.field_24360.method_36139(UIBase.getUIColorTheme().warning_text_color.getColorInt())), 6000L);
            return true;
        }
        if (clickedIndex >= 0) {
            this.initialDragClickX = (int)mouseX;
            this.hasMovedFromClickPosition = false;
            this.draggingKeyframeIndex = clickedIndex;
            AnimationKeyframe keyframe = this.workingKeyframes.get(this.draggingKeyframeIndex);
            if (class_437.method_25441() && this.selectedKeyframes.contains(keyframe)) {
                this.lastCtrlClickedFrameForDeselect = keyframe;
            } else {
                this.selectKeyframe(this.workingKeyframes.get(clickedIndex), class_437.method_25441());
            }
            return true;
        }
        return false;
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        this.isDraggingProgress = false;
        this.draggingKeyframeIndex = -1;
        this.hasMovedFromClickPosition = false;
        boolean previewGotResized = this.previewEditorElement.recentlyResized;
        boolean previewGotMoved = this.previewEditorElement.recentlyMovedByDragging;
        this.previewEditorElement.method_25406(mouseX, mouseY, button);
        if (this.previewEditorElement.isSelected() && (previewGotResized || previewGotMoved) && this.selectedKeyframes.size() == 1 && (!this.isRecording || this.isRecordingPaused) && !this.isPlaying) {
            this.saveState();
            this.applyElementValuesToKeyframe(this.previewElement, this.selectedKeyframes.getFirst());
        }
        if (this.lastCtrlClickedFrameForDeselect != null && !this.framesGotMoved) {
            if (this.selectedKeyframes.size() > 1) {
                this.selectedKeyframes.remove(this.lastCtrlClickedFrameForDeselect);
                if (this.selectedKeyframes.size() == 1) {
                    AnimationKeyframe lastSelected = this.selectedKeyframes.getFirst();
                    this.selectKeyframeClearOldSelection(null);
                    this.selectKeyframeClearOldSelection(lastSelected);
                }
            } else {
                this.selectKeyframeClearOldSelection(null);
            }
        }
        this.lastCtrlClickedFrameForDeselect = null;
        this.framesGotMoved = false;
        return super.method_25406(mouseX, mouseY, button);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        String key = GLFW.glfwGetKeyName((int)keyCode, (int)scanCode);
        if (key == null) {
            key = "";
        }
        key = key.toLowerCase();
        if (class_437.method_25441()) {
            if (key.equals("z")) {
                this.undo();
                return true;
            }
            if (key.equals("y")) {
                this.redo();
                return true;
            }
        }
        if (this.isShowingSmoothingInput && this.smoothingDistanceInput.method_25370()) {
            this.lastSmoothingInputValue = this.smoothingDistanceInput.method_1882();
            if (keyCode == 257) {
                this.applySmoothingDistance();
                return true;
            }
            if (keyCode == 256) {
                this.isShowingSmoothingInput = false;
                return true;
            }
        }
        if (this.isShowingTimestampInput && this.timestampInput.method_25370()) {
            if (keyCode == 257) {
                this.saveState();
                if (this.selectedKeyframes.size() == 1 && MathUtils.isLong((String)this.timestampInput.method_1882())) {
                    this.selectedKeyframes.get((int)0).timestamp = Long.parseLong(this.timestampInput.method_1882());
                }
                this.isShowingTimestampInput = false;
                this.updateTimelineDurationToMaxTimestamp();
                return true;
            }
            if (keyCode == 256) {
                this.isShowingTimestampInput = false;
                return true;
            }
        }
        if ((!this.isRecording || this.isRecordingPaused) && class_437.method_25441() && keyCode == 65) {
            this.selectKeyframeClearOldSelection(null);
            this.workingKeyframes.forEach(keyframe -> this.selectKeyframe((AnimationKeyframe)keyframe, true));
        }
        if (!this.selectedKeyframes.isEmpty() && !FancyMenu.getOptions().arrowKeysMovePreview.getValue().booleanValue()) {
            if (keyCode == 263 || keyCode == 262) {
                long timeShift;
                this.saveState();
                long minSelectedTimestamp = Long.MAX_VALUE;
                long maxSelectedTimestamp = Long.MIN_VALUE;
                for (AnimationKeyframe selectedFrame : this.selectedKeyframes) {
                    minSelectedTimestamp = Math.min(minSelectedTimestamp, selectedFrame.timestamp);
                    maxSelectedTimestamp = Math.max(maxSelectedTimestamp, selectedFrame.timestamp);
                }
                long l = timeShift = keyCode == 263 ? -100L : 100L;
                if (keyCode == 263) {
                    if (minSelectedTimestamp + timeShift < 0L) {
                        timeShift = -minSelectedTimestamp;
                    }
                } else if (maxSelectedTimestamp + timeShift > this.timelineDuration) {
                    timeShift = this.timelineDuration - maxSelectedTimestamp;
                }
                if (timeShift != 0L) {
                    long finalTimeShift = timeShift;
                    this.selectedKeyframes.forEach(selectedKeyframe -> selectedKeyframe.timestamp += finalTimeShift);
                    this.updateTimelineDurationToMaxTimestamp();
                }
                return true;
            }
        } else if (!(!FancyMenu.getOptions().arrowKeysMovePreview.getValue().booleanValue() || this.selectedKeyframes.size() != 1 || this.isRecording && !this.isRecordingPaused || this.isPlaying || keyCode != 263 && keyCode != 262 && keyCode != 265 && keyCode != 264)) {
            this.saveState();
            this.isShowingTimestampInput = false;
            this.isShowingSmoothingInput = false;
            if (keyCode == 263) {
                --this.previewElement.posOffsetX;
            }
            if (keyCode == 262) {
                ++this.previewElement.posOffsetX;
            }
            if (keyCode == 265) {
                --this.previewElement.posOffsetY;
            }
            if (keyCode == 264) {
                ++this.previewElement.posOffsetY;
            }
            this.applyElementValuesToKeyframe(this.previewElement, this.selectedKeyframes.get(0));
            return true;
        }
        if (keyCode == 261 && !this.selectedKeyframes.isEmpty()) {
            this.deleteSelectedKeyframes();
            return true;
        }
        if (keyCode == 75) {
            this.addKeyframeAtProgress();
            return true;
        }
        if (keyCode == 80) {
            this.togglePlayback();
            return true;
        }
        if (keyCode == 82) {
            this.toggleRecording();
            return true;
        }
        if (keyCode == 84) {
            this.togglePauseRecording(true);
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (super.method_25403(mouseX, mouseY, button, dragX, dragY)) {
            return true;
        }
        return this.previewEditorElement.method_25403(mouseX, mouseY, button, dragX, dragY);
    }

    protected void applyElementValuesToKeyframe(@NotNull PreviewElement element, @NotNull AnimationKeyframe keyframe) {
        if (this.isOffsetMode) {
            int screenCenterX = this.field_22789 / 2;
            int screenCenterY = this.field_22790 / 2;
            int elementCenterX = element.getAbsoluteX() + element.getAbsoluteWidth() / 2;
            int elementCenterY = element.getAbsoluteY() + element.getAbsoluteHeight() / 2;
            keyframe.posOffsetX = elementCenterX - screenCenterX;
            keyframe.posOffsetY = elementCenterY - screenCenterY;
        } else {
            keyframe.posOffsetX = element.posOffsetX;
            keyframe.posOffsetY = element.posOffsetY;
        }
        keyframe.baseWidth = element.baseWidth;
        keyframe.baseHeight = element.baseHeight;
        keyframe.anchorPoint = this.isOffsetMode ? ElementAnchorPoints.MID_CENTERED : element.anchorPoint;
        keyframe.stickyAnchor = this.isOffsetMode ? true : element.stickyAnchor;
    }

    protected void applyKeyframeValuesToElement(@NotNull AnimationKeyframe keyframe, @NotNull PreviewElement element) {
        if (this.isOffsetMode) {
            element.animatedOffsetX = keyframe.posOffsetX;
            element.animatedOffsetY = keyframe.posOffsetY;
            element.posOffsetX = 0;
            element.posOffsetY = 0;
        } else {
            element.posOffsetX = keyframe.posOffsetX;
            element.posOffsetY = keyframe.posOffsetY;
        }
        element.baseWidth = keyframe.baseWidth;
        element.baseHeight = keyframe.baseHeight;
        element.anchorPoint = this.isOffsetMode ? ElementAnchorPoints.MID_CENTERED : keyframe.anchorPoint;
        element.stickyAnchor = this.isOffsetMode ? true : keyframe.stickyAnchor;
    }

    protected void togglePlayback() {
        if (this.isRecording) {
            return;
        }
        boolean bl = this.isPlaying = !this.isPlaying;
        if (this.isPlaying) {
            this.playStartTime = System.currentTimeMillis() - this.currentPlayOrRecordPosition;
            this.selectKeyframeClearOldSelection(null);
            this.draggingKeyframeIndex = -1;
            this.displayNotification(PLAYING_STARTED_TEXT, 2000L);
        } else {
            this.displayNotification(PLAYING_STOPPED_TEXT, 2000L);
        }
    }

    protected void toggleRecording() {
        if (this.isPlaying) {
            return;
        }
        if (this.isRecording) {
            this.stopRecording();
        } else {
            this.startRecording();
        }
    }

    protected void startRecording() {
        if (this.isPlaying) {
            return;
        }
        this.isRecording = true;
        this.isRecordingPaused = this.recordingSpeed == 0.0;
        this.recordStartTime = System.currentTimeMillis() - (long)((double)this.currentPlayOrRecordPosition / this.recordingSpeed);
        this.selectKeyframeClearOldSelection(null);
        this.draggingKeyframeIndex = -1;
        this.previewEditorElement.setSelected(true);
    }

    protected void stopRecording() {
        this.isRecording = false;
        this.isRecordingPaused = false;
        this.recordStartTime = -1L;
        this.selectKeyframeClearOldSelection(null);
        this.currentPlayOrRecordPosition = 0L;
        this.updateTimelineDurationToMaxTimestamp();
    }

    protected void togglePauseRecording(boolean updateSlider) {
        if (!this.isRecording) {
            return;
        }
        if (!this.isRecordingPaused) {
            this.cachedRecordingSpeed = this.recordingSpeed;
            this.setRecordingSpeed(0.0);
        } else {
            this.setRecordingSpeed(this.cachedRecordingSpeed);
        }
        if (updateSlider && this.recordingSpeedSlider != null) {
            this.recordingSpeedSlider.setValue(this.recordingSpeed);
        }
    }

    protected void setRecordingSpeed(double speed) {
        double oldSpeed = this.recordingSpeed;
        double newSpeed = Math.max(0.0, Math.min(1.0, speed));
        if (oldSpeed != newSpeed) {
            if (newSpeed > 0.0) {
                if (this.isRecording) {
                    long now = System.currentTimeMillis();
                    this.recordStartTime = now - (long)((double)this.currentPlayOrRecordPosition / newSpeed);
                }
                this.selectKeyframeClearOldSelection(null);
                this.isRecordingPaused = false;
            } else {
                this.isRecordingPaused = true;
            }
        }
        this.recordingSpeed = newSpeed;
    }

    protected void toggleOffsetMode() {
        this.setOffsetMode(!this.isOffsetMode);
    }

    protected void setOffsetMode(boolean offsetMode) {
        this.isOffsetMode = offsetMode;
        if (offsetMode) {
            this.previewElement.anchorPoint = ElementAnchorPoints.MID_CENTERED;
            this.anchorButton.setSelectedValue(ElementAnchorPoints.MID_CENTERED);
        }
    }

    protected void addKeyframeAtProgress() {
        AnimationKeyframe newKeyframe;
        if (!this.isRecording) {
            return;
        }
        this.saveState();
        if (this.isOffsetMode) {
            int screenCenterX = this.field_22789 / 2;
            int screenCenterY = this.field_22790 / 2;
            int elementCenterX = this.previewElement.getAbsoluteX() + this.previewElement.getAbsoluteWidth() / 2;
            int elementCenterY = this.previewElement.getAbsoluteY() + this.previewElement.getAbsoluteHeight() / 2;
            newKeyframe = new AnimationKeyframe(this.currentPlayOrRecordPosition, elementCenterX - screenCenterX, elementCenterY - screenCenterY, this.previewElement.baseWidth, this.previewElement.baseHeight, ElementAnchorPoints.MID_CENTERED, true);
        } else {
            newKeyframe = new AnimationKeyframe(this.currentPlayOrRecordPosition, this.previewElement.posOffsetX, this.previewElement.posOffsetY, this.previewElement.baseWidth, this.previewElement.baseHeight, this.previewElement.anchorPoint, this.previewElement.stickyAnchor);
        }
        this.workingKeyframes.add(newKeyframe);
        this.displayNotification(KEYFRAME_ADDED_TEXT, 2000L);
        this.workingKeyframes.sort(Comparator.comparingLong(k -> k.timestamp));
        this.updateTimelineDurationToMaxTimestamp();
    }

    protected void deleteSelectedKeyframes() {
        if (!this.selectedKeyframes.isEmpty()) {
            this.saveState();
            new ArrayList<AnimationKeyframe>(this.selectedKeyframes).forEach(selectedKeyframe -> {
                this.workingKeyframes.remove(selectedKeyframe);
                this.selectKeyframeClearOldSelection(null);
                this.updateTimelineDurationToMaxTimestamp();
                this.displayNotification(KEYFRAME_DELETED_TEXT, 2000L);
            });
        }
    }

    protected void saveState() {
        this.undoStack.push(new ArrayList<AnimationKeyframe>(this.workingKeyframes.stream().map(AnimationKeyframe::clone).toList()));
        this.redoStack.clear();
    }

    protected void undo() {
        ArrayList selected = new ArrayList();
        this.selectedKeyframes.forEach(keyframe -> selected.add(keyframe.uniqueIdentifier));
        if (this.isPlaying) {
            return;
        }
        if (!this.undoStack.isEmpty()) {
            this.redoStack.push(new ArrayList<AnimationKeyframe>(this.workingKeyframes));
            this.workingKeyframes.clear();
            this.workingKeyframes.addAll((Collection<AnimationKeyframe>)this.undoStack.pop());
            this.selectKeyframeClearOldSelection(null);
            this.updateTimelineDurationToMaxTimestamp();
        }
        if (!selected.isEmpty() && !this.isRecording) {
            selected.forEach(s -> {
                AnimationKeyframe frame = null;
                for (AnimationKeyframe f : this.workingKeyframes) {
                    if (!f.uniqueIdentifier.equals(s)) continue;
                    frame = f;
                    break;
                }
                this.selectKeyframe(frame, true);
            });
        }
    }

    protected void redo() {
        ArrayList selected = new ArrayList();
        this.selectedKeyframes.forEach(keyframe -> selected.add(keyframe.uniqueIdentifier));
        if (this.isPlaying) {
            return;
        }
        if (!this.redoStack.isEmpty()) {
            this.undoStack.push(new ArrayList<AnimationKeyframe>(this.workingKeyframes));
            this.workingKeyframes.clear();
            this.workingKeyframes.addAll((Collection<AnimationKeyframe>)this.redoStack.pop());
            this.selectKeyframeClearOldSelection(null);
            this.updateTimelineDurationToMaxTimestamp();
        }
        if (!selected.isEmpty() && !this.isRecording) {
            selected.forEach(s -> {
                AnimationKeyframe frame = null;
                for (AnimationKeyframe f : this.workingKeyframes) {
                    if (!f.uniqueIdentifier.equals(s)) continue;
                    frame = f;
                    break;
                }
                this.selectKeyframe(frame, true);
            });
        }
    }

    protected void selectKeyframe(@Nullable AnimationKeyframe selected, boolean addToSelection) {
        if (!addToSelection) {
            this.selectedKeyframes.clear();
        }
        if (selected != null) {
            if (!this.selectedKeyframes.contains(selected)) {
                this.selectedKeyframes.add(selected);
                if (this.selectedKeyframes.size() == 1) {
                    this.applyKeyframeValuesToElement(selected, this.previewElement);
                    this.previewEditorElement.setSelected(true);
                    if (this.isPlaying) {
                        this.togglePlayback();
                    }
                    this.anchorButton.setSelectedValue(selected.anchorPoint);
                    this.stickyButton.setSelectedValue(CommonCycles.CycleEnabledDisabled.getByBoolean(selected.stickyAnchor));
                } else if (!this.isRecording) {
                    this.previewEditorElement.setSelected(false);
                }
            }
        } else {
            this.selectedKeyframes.clear();
            if (!this.isRecording) {
                this.previewEditorElement.setSelected(false);
            }
        }
    }

    protected void selectKeyframeClearOldSelection(@Nullable AnimationKeyframe keyframe) {
        this.selectKeyframe(keyframe, false);
    }

    protected void toggleSmoothingInput() {
        this.lastSmoothingInputValue = this.smoothingDistanceInput.method_1882();
        boolean bl = this.isShowingSmoothingInput = !this.isShowingSmoothingInput;
        if (this.isShowingSmoothingInput) {
            this.smoothingDistanceInput.method_1852(this.lastSmoothingInputValue);
            if (this.smoothingDistanceInput.method_1882().isBlank()) {
                this.smoothingDistanceInput.method_1852("100");
            }
        }
    }

    protected void toggleTimestampInput() {
        if (this.selectedKeyframes.size() != 1) {
            return;
        }
        AnimationKeyframe selected = this.selectedKeyframes.get(0);
        boolean bl = this.isShowingTimestampInput = !this.isShowingTimestampInput;
        if (this.isShowingTimestampInput) {
            this.timestampInput.method_1852("" + selected.timestamp);
        }
    }

    protected void applySmoothingDistance() {
        String value;
        if (this.selectedKeyframes.size() > 1 && MathUtils.isLong((String)(value = this.smoothingDistanceInput.method_1882())) && !value.isEmpty()) {
            try {
                long distanceMs = Long.parseLong(value);
                if (distanceMs > 0L) {
                    this.saveState();
                    ArrayList<AnimationKeyframe> sortedFrames = new ArrayList<AnimationKeyframe>(this.selectedKeyframes);
                    sortedFrames.sort(Comparator.comparingLong(k -> k.timestamp));
                    long startTime = ((AnimationKeyframe)sortedFrames.get((int)0)).timestamp;
                    for (int i = 1; i < sortedFrames.size(); ++i) {
                        ((AnimationKeyframe)sortedFrames.get((int)i)).timestamp = startTime + distanceMs * (long)i;
                    }
                    this.updateTimelineDurationToMaxTimestamp();
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.isShowingSmoothingInput = false;
    }

    protected boolean isInTimelineArea(int mouseX, int mouseY) {
        return mouseX >= this.timelineX && mouseX <= this.timelineX + this.timelineWidth && mouseY >= this.timelineY && mouseY <= this.timelineY + 50;
    }

    protected boolean isOverProgressLine(int mouseX, int mouseY) {
        long maxTime = this.timelineDuration;
        float progress = (float)this.currentPlayOrRecordPosition / (float)maxTime;
        int progressX = this.timelineX + (int)((float)this.timelineWidth * progress);
        return mouseY >= this.timelineY && mouseY <= this.timelineY + 50 && mouseX >= progressX - 5 && mouseX <= progressX + 5;
    }

    protected int getKeyframeIndexAtPosition(int mouseX, int mouseY) {
        if (mouseY < this.timelineY || mouseY > this.timelineY + 50) {
            return -1;
        }
        for (int i = 0; i < this.workingKeyframes.size(); ++i) {
            AnimationKeyframe keyframe = this.workingKeyframes.get(i);
            float progress = (float)keyframe.timestamp / (float)this.timelineDuration;
            int lineX = (int)((float)this.timelineX + (float)this.timelineWidth * progress);
            int halfLineWidth = 1;
            if (mouseX < lineX - halfLineWidth || mouseX > lineX + halfLineWidth) continue;
            return i;
        }
        return -1;
    }

    protected void setAnchorPoint(ElementAnchorPoint newAnchor) {
        this.previewElement.anchorPoint = newAnchor;
        this.previewElement.posOffsetX = 0;
        this.previewElement.posOffsetY = 0;
        int startX = this.previewElement.getAbsoluteX();
        int startY = this.previewElement.getAbsoluteY();
        int endX = startX + this.previewElement.getAbsoluteWidth();
        int endY = startY + this.previewElement.getAbsoluteHeight();
        if (startX < 0 || startY < 0 || endX > this.field_22789 || endY > this.field_22790) {
            if (startX < 0) {
                this.previewElement.posOffsetX = -startX;
            } else if (endX > this.field_22789) {
                this.previewElement.posOffsetX = this.field_22789 - endX;
            }
            if (startY < 0) {
                this.previewElement.posOffsetY = -startY;
            } else if (endY > this.field_22790) {
                this.previewElement.posOffsetY = this.field_22790 - endY;
            }
        }
        if (this.selectedKeyframes.size() == 1) {
            this.saveState();
            AnimationKeyframe selectedKeyframe = this.selectedKeyframes.getFirst();
            selectedKeyframe.anchorPoint = this.previewElement.anchorPoint;
            selectedKeyframe.posOffsetX = this.previewElement.posOffsetX;
            selectedKeyframe.posOffsetY = this.previewElement.posOffsetY;
        }
    }

    protected void setStickyAnchor(boolean sticky) {
        if (this.selectedKeyframes.size() == 1) {
            this.saveState();
            this.selectedKeyframes.getFirst().stickyAnchor = sticky;
        }
        this.previewElement.stickyAnchor = sticky;
    }

    protected float lerp(float a, float b, float t) {
        return a + (b - a) * t;
    }

    public void displayNotification(@NotNull class_2561 message, long durationMs) {
        this.activeNotifications.add(new Notification(message, durationMs));
    }

    public boolean method_25422() {
        return false;
    }

    protected static class PreviewElement
    extends AbstractElement {
        public PreviewElement(ElementBuilder<?, ?> builder) {
            super(builder);
        }

        @Override
        public void method_25394(@NotNull class_332 graphics, int mouseX, int mouseY, float partial) {
        }
    }

    protected class PreviewEditorElement
    extends AbstractEditorElement {
        protected boolean elementMovingStarted;
        protected boolean resizingStarted;

        public PreviewEditorElement(@NotNull AbstractElement element, LayoutEditorScreen editor) {
            super(element, editor);
            this.elementMovingStarted = false;
            this.resizingStarted = false;
            this.settings.setFadeable(false);
            this.settings.setAdvancedSizingSupported(false);
            this.settings.setAdvancedPositioningSupported(false);
            this.settings.setOpacityChangeable(false);
            this.settings.setDelayable(false);
            this.settings.setElementAnchorPointAllowed(false);
            this.settings.setStretchable(false);
            this.settings.setVanillaAnchorPointAllowed(false);
            this.settings.setOrderable(false);
            this.settings.setCopyable(false);
            this.settings.setDestroyable(false);
            this.settings.setIdentifierCopyable(false);
        }

        @Override
        public void init() {
            super.init();
            this.topLeftDisplay.clearLines();
            this.bottomRightDisplay.clearLines();
        }

        @Override
        public void method_25394(@NotNull class_332 graphics, int mouseX, int mouseY, float partial) {
            this.renderPreviewBody(graphics, mouseX, mouseY, partial);
            super.method_25394(graphics, mouseX, mouseY, partial);
        }

        public void renderPreviewBody(@NotNull class_332 graphics, int mouseX, int mouseY, float partial) {
            DrawableColor c = PREVIEW_COLOR_NORMAL;
            if (KeyframeManagerScreen.this.isRecording) {
                c = RECORDING_COLOR;
            }
            if (KeyframeManagerScreen.this.selectedKeyframes.size() == 1) {
                c = KEYFRAME_COLOR_SELECTED;
            }
            graphics.method_25294(this.element.getAbsoluteX(), this.element.getAbsoluteY(), this.element.getAbsoluteX() + this.element.getAbsoluteWidth(), this.element.getAbsoluteY() + this.element.getAbsoluteHeight(), c.getColorInt());
        }

        @Override
        public boolean method_25403(double mouseX, double mouseY, int button, double dragX, double dragY) {
            int draggingDiffX = (int)(mouseX - this.leftMouseDownMouseX);
            int draggingDiffY = (int)(mouseY - this.leftMouseDownMouseY);
            boolean bl = this.movingCrumpleZonePassed = Math.abs(draggingDiffX) >= 5 || Math.abs(draggingDiffY) >= 5;
            if (this.movingCrumpleZonePassed && !this.elementMovingStarted) {
                this.updateMovingStartPos((int)mouseX, (int)mouseY);
                this.elementMovingStarted = true;
            }
            if (!this.resizingStarted) {
                this.updateResizingStartPos((int)mouseX, (int)mouseY);
                this.resizingStarted = true;
            }
            return super.method_25403(mouseX, mouseY, button, dragX, dragY);
        }

        @Override
        public boolean method_25406(double mouseX, double mouseY, int button) {
            this.movingCrumpleZonePassed = false;
            this.elementMovingStarted = false;
            this.resizingStarted = false;
            return super.method_25406(mouseX, mouseY, button);
        }
    }

    protected static class Notification {
        @NotNull
        public final class_2561 message;
        public final long startTime;
        public final long duration;
        public float opacity = 1.0f;

        public Notification(@NotNull class_2561 message, long duration) {
            this.message = message;
            this.startTime = System.currentTimeMillis();
            this.duration = duration;
        }

        public boolean isExpired() {
            return System.currentTimeMillis() - this.startTime > this.duration;
        }

        public void updateOpacity() {
            float fadeStartTime;
            long elapsedTime = System.currentTimeMillis() - this.startTime;
            if ((float)elapsedTime > (fadeStartTime = (float)(this.duration - 500L))) {
                this.opacity = 1.0f - ((float)elapsedTime - fadeStartTime) / 500.0f;
                this.opacity = Math.max(0.05f, Math.min(1.0f, this.opacity));
            }
        }

        public int getHeight() {
            Objects.requireNonNull(class_310.method_1551().field_1772);
            return 9 + 2;
        }
    }

    public record AnimationControllerMetadata(@NotNull List<AnimationKeyframe> keyframes, boolean isOffsetMode) {
    }
}

