/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.worldgen.feature.api.feature.noise_path.config;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_4651;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.minecraft.class_6646;

public class NoiseBandBlockPlacement {
    public static final Codec<NoiseBandBlockPlacement> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_4651.field_24937.fieldOf("state_provider").forGetter(config -> config.blockStateProvider), (App)Codec.doubleRange((double)-1.0, (double)1.0).lenientOptionalFieldOf("minimum_noise_threshold", (Object)1.0).forGetter(config -> config.minNoiseThreshold), (App)Codec.doubleRange((double)-1.0, (double)1.0).lenientOptionalFieldOf("maximum_noise_threshold", (Object)1.0).forGetter(config -> config.maxNoiseThreshold), (App)Codec.floatRange((float)0.0f, (float)1.0f).lenientOptionalFieldOf("placement_chance", (Object)Float.valueOf(1.0f)).forGetter(config -> Float.valueOf(config.placementChance)), (App)Codec.BOOL.lenientOptionalFieldOf("schedule_tick_on_placement", (Object)false).forGetter(config -> config.scheduleTickOnPlacement), (App)class_6646.field_35054.fieldOf("replacement_block_predicate").forGetter(config -> config.replacementBlockPredicate), (App)class_6646.field_35054.fieldOf("searching_block_predicate").forGetter(config -> config.searchingBlockPredicate), (App)Codec.INT.lenientOptionalFieldOf("vertical_placement_offset", (Object)0).forGetter(config -> config.verticalPlacementOffset)).apply((Applicative)instance, NoiseBandBlockPlacement::new));
    private final class_4651 blockStateProvider;
    private final double minNoiseThreshold;
    private final double maxNoiseThreshold;
    private final float placementChance;
    private final boolean scheduleTickOnPlacement;
    private final class_6646 replacementBlockPredicate;
    private final class_6646 searchingBlockPredicate;
    private final int verticalPlacementOffset;

    public NoiseBandBlockPlacement(class_4651 blockStateProvider, double minNoiseThreshold, double maxNoiseThreshold, float placementChance, boolean scheduleTickOnPlacement, class_6646 replacementBlockPredicate, class_6646 searchingBlockPredicate, int verticalPlacementOffset) {
        this.blockStateProvider = blockStateProvider;
        this.minNoiseThreshold = minNoiseThreshold;
        this.maxNoiseThreshold = maxNoiseThreshold;
        this.placementChance = placementChance;
        this.scheduleTickOnPlacement = scheduleTickOnPlacement;
        this.replacementBlockPredicate = replacementBlockPredicate;
        this.searchingBlockPredicate = searchingBlockPredicate;
        this.verticalPlacementOffset = verticalPlacementOffset;
    }

    public boolean generate(class_5281 level, class_2338.class_2339 pos, class_5819 random, double sampleOutput) {
        if (sampleOutput >= this.minNoiseThreshold && sampleOutput <= this.maxNoiseThreshold && random.method_43057() <= this.placementChance) {
            pos.method_10100(0, this.verticalPlacementOffset, 0);
            if (this.replacementBlockPredicate.test((Object)level, (Object)pos) && this.searchingBlockPredicate.test((Object)level, (Object)pos)) {
                class_2680 state = this.blockStateProvider.method_23455(random, (class_2338)pos);
                level.method_8652((class_2338)pos, state, 2);
                if (this.scheduleTickOnPlacement) {
                    level.method_64310((class_2338)pos, state.method_26204(), 1);
                }
                return true;
            }
        }
        return false;
    }

    public static class Builder {
        private final class_4651 blockStateProvider;
        private double minNoiseThreshold = -1.0;
        private double maxNoiseThreshold = 1.0;
        private float placementChance = 1.0f;
        private boolean scheduleTickOnPlacement = false;
        private class_6646 replacementBlockPredicate;
        private class_6646 searchingBlockPredicate;
        private int verticalPlacementOffset = 0;

        public Builder(class_4651 blockStateProvider) {
            this.blockStateProvider = blockStateProvider;
        }

        public Builder minNoiseThreshold(double minNoiseThreshold) {
            this.minNoiseThreshold = minNoiseThreshold;
            return this;
        }

        public Builder maxNoiseThreshold(double maxNoiseThreshold) {
            this.maxNoiseThreshold = maxNoiseThreshold;
            return this;
        }

        public Builder within(double minNoiseThreshold, double maxNoiseThreshold) {
            this.minNoiseThreshold = minNoiseThreshold;
            this.maxNoiseThreshold = maxNoiseThreshold;
            return this;
        }

        public Builder placementChance(float placementChance) {
            this.placementChance = placementChance;
            return this;
        }

        public Builder scheduleTickOnPlacement() {
            this.scheduleTickOnPlacement = true;
            return this;
        }

        public Builder replacementBlockPredicate(class_6646 replacementBlockPredicate) {
            this.replacementBlockPredicate = replacementBlockPredicate;
            return this;
        }

        public Builder searchingBlockPredicate(class_6646 searchingBlockPredicate) {
            this.searchingBlockPredicate = searchingBlockPredicate;
            return this;
        }

        public Builder verticalPlacementOffset(int verticalPlacementOffset) {
            this.verticalPlacementOffset = verticalPlacementOffset;
            return this;
        }

        public NoiseBandBlockPlacement build() {
            if (this.searchingBlockPredicate == null) {
                throw new IllegalArgumentException("searchingBlockPredicate cannot be null for NoiseBandBlockPlacement!");
            }
            if (this.replacementBlockPredicate == null) {
                throw new IllegalArgumentException("replacementBlockPredicate cannot be null for NoiseBandBlockPlacement!");
            }
            return new NoiseBandBlockPlacement(this.blockStateProvider, this.minNoiseThreshold, this.maxNoiseThreshold, this.placementChance, this.scheduleTickOnPlacement, this.replacementBlockPredicate, this.searchingBlockPredicate, this.verticalPlacementOffset);
        }
    }
}

