/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.wind.api;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.frozenblock.lib.config.frozenlib_config.FrozenLibConfig;
import net.frozenblock.lib.math.api.EasyNoiseSampler;
import net.frozenblock.lib.networking.FrozenNetworking;
import net.frozenblock.lib.wind.api.WindDisturbance;
import net.frozenblock.lib.wind.api.WindManagerExtension;
import net.frozenblock.lib.wind.impl.WindManagerInterface;
import net.frozenblock.lib.wind.impl.networking.WindAccessPacket;
import net.frozenblock.lib.wind.impl.networking.WindDisturbancePacket;
import net.frozenblock.lib.wind.impl.networking.WindSyncPacket;
import net.minecraft.class_10741;
import net.minecraft.class_18;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_26;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_3756;
import net.minecraft.class_4284;
import net.minecraft.class_8710;
import org.jetbrains.annotations.NotNull;

public class WindManager
extends class_18 {
    public static final String WIND_FILE_PATH = "frozenlib_wind_";
    public static final String WIND_MANAGER_FILE_ID = "frozenlib_wind_main";
    public static final Codec<WindManager> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.LONG.fieldOf("time").forGetter(windManager -> windManager.time), (App)Codec.BOOL.fieldOf("overrideWind").forGetter(windManager -> windManager.overrideWind), (App)class_243.field_38277.fieldOf("commandWind").forGetter(windManager -> windManager.commandWind), (App)Codec.DOUBLE.fieldOf("windX").forGetter(windManager -> windManager.windX), (App)Codec.DOUBLE.fieldOf("windY").forGetter(windManager -> windManager.windY), (App)Codec.DOUBLE.fieldOf("windZ").forGetter(windManager -> windManager.windZ), (App)Codec.DOUBLE.fieldOf("laggedWindX").forGetter(windManager -> windManager.laggedWindX), (App)Codec.DOUBLE.fieldOf("laggedWindY").forGetter(windManager -> windManager.laggedWindY), (App)Codec.DOUBLE.fieldOf("laggedWindZ").forGetter(windManager -> windManager.laggedWindZ)).apply((Applicative)instance, WindManager::createFromCodec));
    public static final class_10741<WindManager> TYPE = new class_10741("frozenlib_wind_main", WindManager::new, CODEC, class_4284.field_45082);
    private static final long MIN_TIME_VALUE = -9223372036854775807L;
    public static final Map<class_10741<? extends WindManagerExtension>, Integer> EXTENSION_PROVIDERS = new Object2ObjectOpenHashMap();
    private final List<WindDisturbance<?>> windDisturbancesA = new ArrayList();
    private final List<WindDisturbance<?>> windDisturbancesB = new ArrayList();
    private boolean isSwitchedServer;
    public List<WindManagerExtension> attachedExtensions;
    private boolean loadedExtensions;
    private class_3218 level;
    public boolean overrideWind;
    public long time;
    public class_243 commandWind = class_243.field_1353;
    public double windX;
    public double windY;
    public double windZ;
    public double laggedWindX;
    public double laggedWindY;
    public double laggedWindZ;
    public long seed;
    private boolean seedSet = false;
    public class_3756 noise = EasyNoiseSampler.createXoroNoise(this.seed);

    @NotNull
    public static WindManager createFromCodec(long time, boolean overrideWind, class_243 commandWind, double windX, double windY, double windZ, double laggedWindX, double laggedWindY, double laggedWindZ) {
        WindManager windManager = new WindManager();
        windManager.time = time;
        windManager.overrideWind = overrideWind;
        windManager.commandWind = commandWind;
        windManager.windX = windX;
        windManager.windY = windY;
        windManager.windZ = windZ;
        windManager.laggedWindX = laggedWindX;
        windManager.laggedWindY = laggedWindY;
        windManager.laggedWindZ = laggedWindZ;
        return windManager;
    }

    public boolean method_79() {
        return true;
    }

    public void setLevel(@NotNull class_3218 level) {
        this.level = level;
    }

    public static void addExtension(@NotNull class_10741<? extends WindManagerExtension> savedDataType, int priority) {
        EXTENSION_PROVIDERS.put(savedDataType, priority);
    }

    public static void addExtension(@NotNull class_10741<? extends WindManagerExtension> savedDataType) {
        WindManager.addExtension(savedDataType, 1000);
    }

    public void loadExtensionsIfNotLoaded(@NotNull class_3218 serverLevel) {
        if (this.loadedExtensions) {
            return;
        }
        class_26 storage = serverLevel.method_17983();
        ObjectArrayList extensions = new ObjectArrayList();
        Map.Entry[] extensionProviders = EXTENSION_PROVIDERS.entrySet().toArray(new Map.Entry[0]);
        Arrays.sort(extensionProviders, Map.Entry.comparingByValue());
        for (Map.Entry extensionByPriority : extensionProviders) {
            class_10741 type = (class_10741)extensionByPriority.getKey();
            WindManagerExtension extension = (WindManagerExtension)storage.method_17924(type);
            extension.setWindManager(this);
            extensions.add(extension);
        }
        this.attachedExtensions = extensions;
        this.loadedExtensions = true;
    }

    public void addWindDisturbanceAndSync(@NotNull WindDisturbance<?> windDisturbance, class_3218 serverLevel) {
        Optional<WindDisturbancePacket> optionalPacket = windDisturbance.toPacket();
        if (optionalPacket.isPresent()) {
            for (class_3222 player : PlayerLookup.world((class_3218)serverLevel)) {
                if (!windDisturbance.isWithinViewDistance(player.method_52372())) continue;
                ServerPlayNetworking.send((class_3222)player, (class_8710)optionalPacket.get());
            }
        }
        this.addWindDisturbance(windDisturbance);
    }

    public void addWindDisturbance(@NotNull WindDisturbance<?> windDisturbance) {
        this.getWindDisturbanceStash().add(windDisturbance);
    }

    private List<WindDisturbance<?>> getWindDisturbances() {
        return !this.isSwitchedServer ? this.windDisturbancesA : this.windDisturbancesB;
    }

    private List<WindDisturbance<?>> getWindDisturbanceStash() {
        return this.isSwitchedServer ? this.windDisturbancesA : this.windDisturbancesB;
    }

    public void clearWindDisturbances() {
        this.getWindDisturbances().clear();
    }

    public void clearAllWindDisturbances() {
        this.getWindDisturbances().clear();
        this.getWindDisturbanceStash().clear();
    }

    public void clearAndSwitchWindDisturbances() {
        this.clearWindDisturbances();
        this.isSwitchedServer = !this.isSwitchedServer;
    }

    @NotNull
    public static WindManager getOrCreateWindManager(@NotNull class_3218 level) {
        WindManager windManager = ((WindManagerInterface)level).frozenLib$getOrCreateWindManager();
        windManager.loadExtensionsIfNotLoaded(level);
        windManager.setLevel(level);
        return windManager;
    }

    public void tick(@NotNull class_3218 level) {
        if (!this.seedSet) {
            this.seedSet = true;
            this.seed = level.method_8412();
            this.noise = EasyNoiseSampler.createXoroNoise(this.seed);
        }
        if (level.method_54719().method_54751()) {
            this.runResetsIfNeeded(level);
            ++this.time;
            float thunderLevel = level.method_8478(1.0f) * 0.03f;
            double calcTime = (double)this.time * 5.0E-4;
            double calcTimeY = (double)this.time * 3.5E-4;
            class_243 vec3 = this.sampleVec3(calcTime, calcTimeY, calcTime);
            this.windX = vec3.field_1352 + vec3.field_1352 * (double)thunderLevel;
            this.windY = vec3.field_1351 + vec3.field_1351 * (double)thunderLevel;
            this.windZ = vec3.field_1350 + vec3.field_1350 * (double)thunderLevel;
            double calcLaggedTime = (double)(this.time - 40L) * 5.0E-4;
            double calcLaggedTimeY = (double)(this.time - 60L) * 3.5E-4;
            class_243 laggedVec = this.sampleVec3(calcLaggedTime, calcLaggedTimeY, calcLaggedTime);
            this.laggedWindX = laggedVec.field_1352 + laggedVec.field_1352 * (double)thunderLevel;
            this.laggedWindY = laggedVec.field_1351 + laggedVec.field_1351 * (double)thunderLevel;
            this.laggedWindZ = laggedVec.field_1350 + laggedVec.field_1350 * (double)thunderLevel;
            for (WindManagerExtension extension : this.attachedExtensions) {
                extension.baseTick(level);
                extension.tick(level);
            }
            if (this.time % 20L == 0L) {
                this.sendSync(level);
            }
        }
    }

    private boolean runResetsIfNeeded(class_3218 serverLevel) {
        boolean needsReset = false;
        if (Math.abs(this.time) == Long.MAX_VALUE) {
            needsReset = true;
            this.time = -9223372036854775807L;
        }
        if (Math.abs(this.windX) == Double.MAX_VALUE) {
            needsReset = true;
            this.windX = 0.0;
        }
        if (Math.abs(this.windY) == Double.MAX_VALUE) {
            needsReset = true;
            this.windY = 0.0;
        }
        if (Math.abs(this.windZ) == Double.MAX_VALUE) {
            needsReset = true;
            this.windZ = 0.0;
        }
        if (Math.abs(this.laggedWindX) == Double.MAX_VALUE) {
            needsReset = true;
            this.laggedWindX = 0.0;
        }
        if (Math.abs(this.laggedWindY) == Double.MAX_VALUE) {
            needsReset = true;
            this.laggedWindY = 0.0;
        }
        if (Math.abs(this.laggedWindZ) == Double.MAX_VALUE) {
            needsReset = true;
            this.laggedWindZ = 0.0;
        }
        for (WindManagerExtension extension : this.attachedExtensions) {
            if (!extension.runResetsIfNeeded()) continue;
            needsReset = true;
        }
        if (needsReset) {
            this.sendSync(serverLevel);
        }
        return needsReset;
    }

    @NotNull
    public WindSyncPacket createSyncPacket() {
        return new WindSyncPacket(this.time, this.seed, this.overrideWind, this.commandWind);
    }

    public void sendSync(@NotNull class_3218 level) {
        WindSyncPacket packet = this.createSyncPacket();
        for (class_3222 player : PlayerLookup.world((class_3218)level)) {
            this.sendSyncToPlayer(packet, player);
        }
    }

    public void sendSyncToPlayer(@NotNull WindSyncPacket packet, @NotNull class_3222 player) {
        ServerPlayNetworking.send((class_3222)player, (class_8710)packet);
        for (WindManagerExtension extension : this.attachedExtensions) {
            ServerPlayNetworking.send((class_3222)player, (class_8710)extension.syncPacket(packet));
        }
    }

    @NotNull
    public class_243 getWindMovement(@NotNull class_2338 pos) {
        return this.getWindMovement(class_243.method_24955((class_2382)pos));
    }

    @NotNull
    public class_243 getWindMovement(@NotNull class_2338 pos, double scale) {
        return this.getWindMovement(class_243.method_24955((class_2382)pos), scale);
    }

    @NotNull
    public class_243 getWindMovement(@NotNull class_2338 pos, double scale, double clamp) {
        return this.getWindMovement(class_243.method_24955((class_2382)pos), scale, clamp);
    }

    @NotNull
    public class_243 getWindMovement(@NotNull class_243 pos) {
        return this.getWindMovement(pos, 1.0);
    }

    @NotNull
    public class_243 getWindMovement(@NotNull class_243 pos, double scale) {
        return this.getWindMovement(pos, scale, Double.MAX_VALUE);
    }

    @NotNull
    public class_243 getWindMovement(@NotNull class_243 pos, double scale, double clamp) {
        return this.getWindMovement(pos, scale, clamp, 1.0);
    }

    @NotNull
    public class_243 getWindMovement(@NotNull class_243 pos, double scale, double clamp, double windDisturbanceScale) {
        double brightness = this.level.method_8314(class_1944.field_9284, class_2338.method_49638((class_2374)pos));
        double windScale = Math.max(brightness - Math.max(15.0 - brightness, 0.0), 0.0) * 0.0667;
        Pair<Double, class_243> disturbance = this.calculateWindDisturbance(pos);
        double disturbanceAmount = (Double)disturbance.getFirst();
        class_243 windDisturbance = (class_243)disturbance.getSecond();
        double windX = class_3532.method_16436((double)disturbanceAmount, (double)(this.windX * windScale), (double)(windDisturbance.field_1352 * windDisturbanceScale)) * scale;
        double windY = class_3532.method_16436((double)disturbanceAmount, (double)(this.windY * windScale), (double)(windDisturbance.field_1351 * windDisturbanceScale)) * scale;
        double windZ = class_3532.method_16436((double)disturbanceAmount, (double)(this.windZ * windScale), (double)(windDisturbance.field_1350 * windDisturbanceScale)) * scale;
        if (FrozenLibConfig.IS_DEBUG) {
            FrozenNetworking.sendPacketToAllPlayers(this.level, new WindAccessPacket(pos));
        }
        return new class_243(class_3532.method_15350((double)windX, (double)(-clamp), (double)clamp), class_3532.method_15350((double)windY, (double)(-clamp), (double)clamp), class_3532.method_15350((double)windZ, (double)(-clamp), (double)clamp));
    }

    @Deprecated
    @NotNull
    public class_243 getWindMovement3D(@NotNull class_2338 pos, double stretch) {
        return this.getWindMovement3D(class_243.method_24955((class_2382)pos), stretch);
    }

    @Deprecated
    @NotNull
    public class_243 getWindMovement3D(@NotNull class_2338 pos, double scale, double stretch) {
        return this.getWindMovement3D(class_243.method_24955((class_2382)pos), scale, stretch);
    }

    @Deprecated
    @NotNull
    public class_243 getWindMovement3D(@NotNull class_2338 pos, double scale, double clamp, double stretch) {
        return this.getWindMovement3D(class_243.method_24955((class_2382)pos), scale, clamp, stretch);
    }

    @Deprecated
    @NotNull
    public class_243 getWindMovement3D(@NotNull class_243 pos, double stretch) {
        return this.getWindMovement3D(pos, 1.0, stretch);
    }

    @Deprecated
    @NotNull
    public class_243 getWindMovement3D(@NotNull class_243 pos, double scale, double stretch) {
        return this.getWindMovement3D(pos, scale, Double.MAX_VALUE, stretch);
    }

    @Deprecated
    @NotNull
    public class_243 getWindMovement3D(@NotNull class_243 pos, double scale, double clamp, double stretch) {
        class_243 wind = this.sample3D(pos, stretch);
        return new class_243(class_3532.method_15350((double)(wind.method_10216() * scale), (double)(-clamp), (double)clamp), class_3532.method_15350((double)(wind.method_10214() * scale), (double)(-clamp), (double)clamp), class_3532.method_15350((double)(wind.method_10215() * scale), (double)(-clamp), (double)clamp));
    }

    @NotNull
    private class_243 sampleVec3(double x, double y, double z) {
        if (!this.overrideWind) {
            double windX = this.noise.method_33658(x, 0.0, 0.0);
            double windY = this.noise.method_33658(0.0, y, 0.0);
            double windZ = this.noise.method_33658(0.0, 0.0, z);
            return new class_243(windX, windY, windZ);
        }
        return this.commandWind;
    }

    @Deprecated
    @NotNull
    private class_243 sample3D(@NotNull class_243 pos, double stretch) {
        double sampledTime = (double)this.time * 0.1;
        double xyz = pos.method_10216() + pos.method_10214() + pos.method_10215();
        double windX = this.noise.method_33658((xyz + sampledTime) * stretch, 0.0, 0.0);
        double windY = this.noise.method_33658(0.0, (xyz + sampledTime) * stretch, 0.0);
        double windZ = this.noise.method_33658(0.0, 0.0, (xyz + sampledTime) * stretch);
        return new class_243(windX, windY, windZ);
    }

    @NotNull
    private Pair<Double, class_243> calculateWindDisturbance(@NotNull class_243 pos) {
        return WindManager.calculateWindDisturbance(this.getWindDisturbances(), (class_1937)this.level, pos);
    }

    @NotNull
    public static Pair<Double, class_243> calculateWindDisturbance(@NotNull List<WindDisturbance<?>> windDisturbances, @NotNull class_1937 level, @NotNull class_243 pos) {
        ArrayList<Pair> winds = new ArrayList<Pair>();
        double strength = 0.0;
        for (WindDisturbance<?> windDisturbance : windDisturbances) {
            WindDisturbance.DisturbanceResult disturbanceResult = windDisturbance.calculateDisturbanceResult(level, pos);
            if (disturbanceResult.strength() == 0.0 || disturbanceResult.weight() == 0.0) continue;
            strength = Math.max(strength, disturbanceResult.strength());
            winds.add(Pair.of((Object)disturbanceResult.weight(), (Object)disturbanceResult.wind()));
        }
        double finalX = 0.0;
        double finalY = 0.0;
        double finalZ = 0.0;
        if (!winds.isEmpty()) {
            double x = 0.0;
            double y = 0.0;
            double z = 0.0;
            double sumOfWeights = 0.0;
            for (Pair pair : winds) {
                double weight = (Double)pair.getFirst();
                sumOfWeights += weight;
                class_243 windVec = (class_243)pair.getSecond();
                x += weight * windVec.field_1352;
                y += weight * windVec.field_1351;
                z += weight * windVec.field_1350;
            }
            finalX = x / sumOfWeights;
            finalY = y / sumOfWeights;
            finalZ = z / sumOfWeights;
        }
        return Pair.of((Object)strength, (Object)new class_243(finalX, finalY, finalZ));
    }
}

