/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.shadow.xjs.data.serialization.writer;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import net.frozenblock.lib.shadow.xjs.data.JsonValue;
import net.frozenblock.lib.shadow.xjs.data.comments.CommentData;
import net.frozenblock.lib.shadow.xjs.data.comments.CommentStyle;
import net.frozenblock.lib.shadow.xjs.data.comments.CommentType;
import net.frozenblock.lib.shadow.xjs.data.serialization.writer.ElementWriter;
import net.frozenblock.lib.shadow.xjs.data.serialization.writer.JsonWriterOptions;

public abstract class CommentedElementWriter
extends ElementWriter {
    protected final boolean outputComments;
    protected CommentStyle forcedStyle;

    protected CommentedElementWriter(File file, boolean format) throws IOException {
        super(file, format);
        this.outputComments = format;
    }

    protected CommentedElementWriter(Writer writer, boolean format) {
        super(writer, format);
        this.outputComments = format;
    }

    protected CommentedElementWriter(File file, JsonWriterOptions options) throws IOException {
        super(file, options);
        this.outputComments = options.isOutputComments();
    }

    protected CommentedElementWriter(Writer writer, JsonWriterOptions options) {
        super(writer, options);
        this.outputComments = options.isOutputComments();
    }

    protected boolean hasComment(CommentType type) {
        return this.outputComments && this.current != null && this.current().hasComment(type);
    }

    protected CommentData getComment(CommentType type) {
        return this.current().getComments().getData(type);
    }

    @Override
    protected void writeAbove() throws IOException {
        if (this.format) {
            this.writeLines(this.getActualLinesAbove());
            if (this.hasComment(CommentType.HEADER)) {
                CommentData data = this.getComment(CommentType.HEADER);
                this.writeComment(data);
                this.nl();
                if (this.level == -1 && !data.endsWithNewline() && this.getLinesAbove(this.getFirst(this.current())) <= 0) {
                    this.nl();
                }
            }
        }
    }

    @Override
    protected void writeBetween() throws IOException {
        if (this.format) {
            int lines = this.getActualLinesBetween();
            if (lines > 0) {
                this.writeLines(lines, this.level + 1);
            } else {
                this.tw.write(this.separator);
            }
            if (!this.hasComment(CommentType.VALUE)) {
                return;
            }
            CommentData data = this.getComment(CommentType.VALUE);
            CommentStyle style = this.forcedStyle;
            if (lines == 0 && !data.endsWithNewline()) {
                style = CommentStyle.BLOCK;
            }
            this.writeComment(data, style, this.level + 1, false);
            if (lines <= 0 && !data.endsWithNewline()) {
                this.tw.write(this.separator);
            } else if (!data.endsWithNewline()) {
                this.nl(this.level + 1);
            }
        }
    }

    @Override
    protected void writeAfter() throws IOException {
        boolean separatorWritten;
        if (!this.hasComment(CommentType.EOL)) {
            return;
        }
        CommentData data = this.getComment(CommentType.EOL);
        boolean bl = separatorWritten = this.getLinesAbove(this.peek()) == 0;
        if (!separatorWritten) {
            this.tw.write(this.separator);
        }
        this.writeComment(data);
        if (separatorWritten) {
            this.tw.write(this.separator);
        }
    }

    @Override
    protected boolean writeTrailing() throws IOException {
        if (!this.format) {
            return false;
        }
        CommentData data = this.parent().getComments().getData(CommentType.INTERIOR);
        boolean empty = this.parent().isEmpty();
        int lines = this.getActualLinesTrailing();
        if (empty) {
            lines = Math.min(1, lines);
        }
        if (data.getLines() > 0) {
            lines = Math.max(1, lines);
        }
        int level = !data.isEmpty() ? this.level : this.level - 1;
        this.writeLines(lines, level);
        if (data.isEmpty()) {
            return lines > 0;
        }
        boolean trim = data.endsWithNewline();
        if (lines <= 0) {
            this.tw.write(this.separator);
        }
        this.writeComment(data, this.forcedStyle, this.level, true);
        if (empty && lines <= 0) {
            this.tw.write(this.separator);
        }
        if (!trim && lines > 0) {
            this.nl(this.level - 1);
        }
        return lines > 0;
    }

    protected void writeFooter() throws IOException {
        JsonValue source;
        JsonValue jsonValue = source = this.parent != null ? this.parent() : this.previous();
        if (source == null || !source.hasComment(CommentType.FOOTER)) {
            return;
        }
        CommentData data = source.getComments().getData(CommentType.FOOTER);
        this.nl(0);
        this.writeComment(data);
    }

    protected void writeComment(CommentData data) throws IOException {
        this.writeComment(data, this.forcedStyle, this.level, false);
    }

    protected void writeComment(CommentData data, CommentStyle style, int level, boolean dedentLast) throws IOException {
        data.writeTo(this.tw, style, this.indent, level, this.eol, dedentLast);
    }

    @Override
    protected boolean requiresSmartSpace(JsonValue value) {
        if (value == null) {
            return false;
        }
        return value.isContainer() || value.hasComment(CommentType.HEADER);
    }
}

