/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.shadow.personthecat.fresult;

import net.frozenblock.lib.shadow.personthecat.fresult.OptionalResult;
import net.frozenblock.lib.shadow.personthecat.fresult.PartialOptionalResult;
import net.frozenblock.lib.shadow.personthecat.fresult.Result;
import net.frozenblock.lib.shadow.personthecat.fresult.Shorthand;
import net.frozenblock.lib.shadow.personthecat.fresult.Void;
import net.frozenblock.lib.shadow.personthecat.fresult.WithResources;
import net.frozenblock.lib.shadow.personthecat.fresult.functions.ThrowingConsumer;
import net.frozenblock.lib.shadow.personthecat.fresult.functions.ThrowingFunction;
import net.frozenblock.lib.shadow.personthecat.fresult.functions.ThrowingOptionalFunction;
import net.frozenblock.lib.shadow.personthecat.fresult.functions.ThrowingSupplier;

public class WithResource<R extends AutoCloseable, E extends Throwable> {
    private final ThrowingSupplier<R, E> rGetter;

    WithResource(ThrowingSupplier<R, E> rGetter) {
        this.rGetter = rGetter;
    }

    public <T, E2 extends E> Result.Pending<T, E> of(ThrowingFunction<R, T, E2> attempt) {
        return Result.of(() -> this.execute(attempt));
    }

    public <E2 extends E> Result.Pending<Void, E> of(ThrowingConsumer<R, E2> attempt) {
        return this.of(Result.wrapVoid(attempt));
    }

    public <T, E2 extends E> Result<T, Throwable> suppress(ThrowingFunction<R, T, E2> attempt) {
        return Result.suppress(() -> this.execute(attempt));
    }

    public <E2 extends E> Result<Void, Throwable> suppress(ThrowingConsumer<R, E2> attempt) {
        return this.suppress(Result.wrapVoid(attempt));
    }

    public <T, E2 extends E> PartialOptionalResult<T, E> nullable(ThrowingFunction<R, T, E2> attempt) {
        return Result.nullable(() -> this.execute(attempt));
    }

    public <T, E2 extends E> PartialOptionalResult<T, E> nullable(ThrowingOptionalFunction<R, T, E2> attempt) {
        return this.nullable((R r) -> attempt.apply(r).orElse(null));
    }

    public <T, E2 extends E> OptionalResult<T, Throwable> suppressNullable(ThrowingFunction<R, T, E2> attempt) {
        return Result.suppressNullable(() -> this.execute(attempt));
    }

    public <T, E2 extends E> OptionalResult<T, Throwable> suppressNullable(ThrowingOptionalFunction<R, T, E2> attempt) {
        return this.suppressNullable((R r) -> attempt.apply(r).orElse(null));
    }

    public <R2 extends AutoCloseable> WithResources<R, R2, E> with(ThrowingSupplier<R2, E> resource) {
        return new WithResources<R, R2, E>(this.rGetter, resource);
    }

    public <R2 extends AutoCloseable> WithResources<R, R2, E> with(ThrowingFunction<R, R2, E> getter) {
        return new WithResources<R, AutoCloseable, E>(this.rGetter, () -> (AutoCloseable)getter.apply((AutoCloseable)this.rGetter.get()));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T, E2 extends E> T execute(ThrowingFunction<R, T, E2> attempt) throws E {
        try (AutoCloseable r = (AutoCloseable)this.rGetter.get();){
            AutoCloseable t = attempt.apply(r);
            return (T)t;
        }
        catch (Throwable e) {
            throw Shorthand.errorFound(e);
        }
    }
}

