/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.resource_pack.api.client;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.ModContainer;
import net.frozenblock.lib.FrozenLibConstants;
import net.frozenblock.lib.FrozenLibLogUtils;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Environment(value=EnvType.CLIENT)
public class FrozenLibModResourcePackApi {
    @ApiStatus.Internal
    public static final Path RESOURCE_PACK_DIRECTORY = FrozenLibConstants.FROZENLIB_GAME_DIRECTORY.resolve("resourcepacks");
    @ApiStatus.Internal
    public static final Path MOD_RESOURCE_PACK_DIRECTORY = FrozenLibConstants.FROZENLIB_GAME_DIRECTORY.resolve("mod_resourcepacks");
    @ApiStatus.Internal
    public static final Path MOD_RESOURCE_PACK_PENDING_EXTRACTION_DIRECTORY = FrozenLibConstants.FROZENLIB_GAME_DIRECTORY.resolve("mod_resourcepacks_pending_extraction");
    @ApiStatus.Internal
    private static final Path HASH_FILE = FrozenLibConstants.FROZENLIB_GAME_DIRECTORY.resolve("mod_resource_pack_hashes.txt");
    @ApiStatus.Internal
    private static final List<String> HIDDEN_PACK_IDS = new ArrayList<String>();
    @ApiStatus.Internal
    private static final List<String> MOD_RESOURCE_PACK_IDS = new ArrayList<String>();

    public static void findAndPrepareResourcePack(@NotNull ModContainer container, String packName, boolean isDoubleZip, boolean hidePackFromMenu, boolean skipHashCheck) throws IOException {
        Optional resourcePack;
        String zipPackName = packName + ".zip";
        String packId = "frozenlib:mod/file/" + zipPackName;
        String subPath = "frozenlib_resourcepacks/" + zipPackName;
        MOD_RESOURCE_PACK_IDS.add(packId);
        if (hidePackFromMenu) {
            FrozenLibModResourcePackApi.registerHiddenPackId(packId);
        }
        if ((resourcePack = container.findPath(subPath)).isPresent()) {
            Path jarPackPath = (Path)resourcePack.get();
            String currentHash = FrozenLibModResourcePackApi.calculateSHA256(jarPackPath);
            boolean hasHashChanged = skipHashCheck || FrozenLibModResourcePackApi.hasHashChanged(packName, currentHash);
            File destFile = new File(MOD_RESOURCE_PACK_DIRECTORY.toString(), zipPackName);
            if (hasHashChanged || !destFile.exists()) {
                if (destFile.exists()) {
                    if (!hasHashChanged) {
                        return;
                    }
                    destFile.delete();
                }
                InputStream inputFromJar = Files.newInputStream(jarPackPath, new OpenOption[0]);
                if (isDoubleZip) {
                    File extractionFile = new File(MOD_RESOURCE_PACK_PENDING_EXTRACTION_DIRECTORY.toString(), zipPackName);
                    FileUtils.copyInputStreamToFile((InputStream)inputFromJar, (File)extractionFile);
                    inputFromJar.close();
                    AtomicBoolean extracted = new AtomicBoolean(false);
                    ZipFile zipFile = new ZipFile(extractionFile);
                    zipFile.entries().asIterator().forEachRemaining(entry -> {
                        if (entry.getName().equals(zipPackName) && !extracted.get()) {
                            try {
                                InputStream zipInputStream = zipFile.getInputStream((ZipEntry)entry);
                                FileUtils.copyInputStreamToFile((InputStream)zipInputStream, (File)destFile);
                                zipInputStream.close();
                                extracted.set(true);
                            }
                            catch (IOException e) {
                                throw new RuntimeException(e);
                            }
                        }
                    });
                    extractionFile.delete();
                    if (!extracted.get()) {
                        FrozenLibLogUtils.logWarning("Could not find internal Resource Pack of name " + zipPackName + "!");
                    }
                } else {
                    FileUtils.copyInputStreamToFile((InputStream)inputFromJar, (File)destFile);
                    inputFromJar.close();
                }
            }
            FrozenLibModResourcePackApi.updateHashRecord(packName, currentHash);
        } else {
            FrozenLibLogUtils.logWarning("Could not find internal Resource Pack of name " + zipPackName + "!");
        }
    }

    public static void registerHiddenPackId(String packId) {
        HIDDEN_PACK_IDS.add(packId);
    }

    public static boolean isPackHiddenFromMenu(String packId) {
        return HIDDEN_PACK_IDS.contains(packId);
    }

    public static boolean isFrozenLibPackRegisteredByMod(String packId) {
        return MOD_RESOURCE_PACK_IDS.contains(packId);
    }

    private static String calculateSHA256(Path path) throws IOException {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            byte[] fileBytes = Files.readAllBytes(path);
            byte[] hashBytes = digest.digest(fileBytes);
            StringBuilder hexString = new StringBuilder();
            for (byte b : hashBytes) {
                String hex = Integer.toHexString(0xFF & b);
                if (hex.length() == 1) {
                    hexString.append('0');
                }
                hexString.append(hex);
            }
            return hexString.toString();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("SHA-256 algorithm not available", e);
        }
    }

    private static Map<String, String> readHashRecords() {
        HashMap<String, String> hashes = new HashMap<String, String>();
        if (Files.exists(HASH_FILE, new LinkOption[0])) {
            try {
                Files.lines(HASH_FILE).forEach(line -> {
                    String[] parts = line.split("=", 2);
                    if (parts.length == 2) {
                        hashes.put(parts[0], parts[1]);
                    }
                });
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return hashes;
    }

    private static void writeHashRecords(Map<String, String> hashes) {
        try {
            Files.createDirectories(FrozenLibConstants.FROZENLIB_GAME_DIRECTORY, new FileAttribute[0]);
            StringBuilder content = new StringBuilder();
            for (Map.Entry<String, String> entry : hashes.entrySet()) {
                String packName = entry.getKey();
                if (!new File(MOD_RESOURCE_PACK_DIRECTORY.toString(), packName + ".zip").exists()) continue;
                content.append(packName).append("=").append(entry.getValue()).append("\n");
            }
            Files.write(HASH_FILE, content.toString().getBytes(), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static boolean hasHashChanged(String packName, String currentHash) {
        Map<String, String> existingHashes = FrozenLibModResourcePackApi.readHashRecords();
        String existingHash = existingHashes.get(packName);
        return existingHash == null || !existingHash.equals(currentHash);
    }

    private static void updateHashRecord(String packName, String newHash) {
        Map<String, String> hashes = FrozenLibModResourcePackApi.readHashRecords();
        hashes.put(packName, newHash);
        FrozenLibModResourcePackApi.writeHashRecords(hashes);
    }
}

