/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.music.api.client.structure;

import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.frozenblock.lib.music.api.client.structure.StructureMusicInfo;
import net.frozenblock.lib.worldgen.structure.api.status.client.ClientStructureStatuses;
import net.frozenblock.lib.worldgen.structure.impl.status.PlayerStructureStatus;
import net.minecraft.class_10383;
import net.minecraft.class_156;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_746;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class StructureMusicApi {
    private static final Map<class_2960, List<StructureMusicInfo>> STRUCTURE_TO_MUSIC_INFO_MAP = new Object2ObjectLinkedOpenHashMap();

    public static void registerMusicInfoForStructure(class_2960 structureLocation, StructureMusicInfo musicInfo) {
        List musicList = STRUCTURE_TO_MUSIC_INFO_MAP.computeIfAbsent(structureLocation, location -> new ArrayList());
        musicList.add(musicInfo);
        STRUCTURE_TO_MUSIC_INFO_MAP.put(structureLocation, musicList);
    }

    public static void registerMusicInfoForStructure(@NotNull class_5321<class_3195> structureKey, StructureMusicInfo musicInfo) {
        StructureMusicApi.registerMusicInfoForStructure(structureKey.method_29177(), musicInfo);
    }

    @ApiStatus.Internal
    @NotNull
    private static Optional<class_10383> getCurrentStructureMusicInfo(class_5819 random) {
        Optional<PlayerStructureStatus> optionalStructureStatus = ClientStructureStatuses.getProminentStructureStatus();
        if (optionalStructureStatus.isPresent()) {
            PlayerStructureStatus structureStatus = optionalStructureStatus.get();
            boolean isInsidePiece = structureStatus.isInsidePiece();
            List structureMusicInfoList = STRUCTURE_TO_MUSIC_INFO_MAP.getOrDefault(structureStatus.getStructure(), List.of());
            ArrayList<StructureMusicInfo> finalizedStructureMusicInfoList = new ArrayList<StructureMusicInfo>();
            for (StructureMusicInfo structureMusicInfo : structureMusicInfoList) {
                if (!isInsidePiece && structureMusicInfo.mustBeInsidePiece()) continue;
                finalizedStructureMusicInfoList.add(structureMusicInfo);
            }
            if (!finalizedStructureMusicInfoList.isEmpty()) {
                return Optional.of(((StructureMusicInfo)class_156.method_32309(finalizedStructureMusicInfoList, (class_5819)random)).musicInfo());
            }
        }
        return Optional.empty();
    }

    @ApiStatus.Internal
    @NotNull
    public static class_10383 chooseMusicInfoOrStructureMusicInfo(@Nullable class_746 player, class_10383 musicInfo) {
        if (player == null) {
            return musicInfo;
        }
        return StructureMusicApi.getCurrentStructureMusicInfo(player.method_59922()).orElse(musicInfo);
    }
}

