/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.loot.impl;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.loot.v3.LootTableSource;
import net.frozenblock.lib.loot.impl.MutableLootPool;
import net.minecraft.class_117;
import net.minecraft.class_176;
import net.minecraft.class_1792;
import net.minecraft.class_2960;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_55;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MutableLootTable {
    private final ArrayList<MutableLootPool> pools;
    private final ArrayList<class_117> functions = new ArrayList();
    private final class_176 paramSet;
    private final class_2960 randomSequence;

    public MutableLootTable(@NotNull class_52 table) {
        this.pools = MutableLootTable.createLootPools(table.field_943);
        this.functions.addAll(table.field_944);
        this.paramSet = table.method_322();
        this.randomSequence = table.field_44892.orElse(null);
    }

    @Nullable
    public static MutableLootTable getMutable(@NotNull class_5321<class_52> lootTableKey, class_5321<class_52> id, class_52 lootTable) {
        if (lootTableKey.equals(id)) {
            return new MutableLootTable(lootTable);
        }
        return null;
    }

    @Nullable
    public static MutableLootTable getMutable(class_5321<class_52> lootTableKey, class_5321<class_52> id, class_52 lootTable, @NotNull LootTableSource source) {
        if (source.isBuiltin()) {
            return MutableLootTable.getMutable(lootTableKey, id, lootTable);
        }
        return null;
    }

    public class_52 build() {
        class_52.class_53 builder = class_52.method_324();
        builder.method_334(this.paramSet);
        builder.method_51883(this.randomSequence);
        this.pools.forEach(mPool -> builder.field_949.add((Object)mPool.build()));
        this.functions.forEach(arg_0 -> ((ImmutableList.Builder)builder.field_951).add(arg_0));
        return builder.method_338();
    }

    public MutableLootTable modifyPools(Consumer<MutableLootPool> consumer) {
        this.pools.forEach(consumer);
        return this;
    }

    public MutableLootTable modifyPools(Predicate<MutableLootPool> condition, Consumer<MutableLootPool> consumer) {
        this.pools.forEach(pool -> {
            if (condition.test((MutableLootPool)pool)) {
                consumer.accept((MutableLootPool)pool);
            }
        });
        return this;
    }

    @NotNull
    private static ArrayList<MutableLootPool> createLootPools(@NotNull List<class_55> lootPoolList) {
        ArrayList<MutableLootPool> lootPools = new ArrayList<MutableLootPool>();
        lootPoolList.forEach(pool -> lootPools.add(new MutableLootPool((class_55)pool)));
        return lootPools;
    }

    @Contract(pure=true)
    @NotNull
    public static Predicate<MutableLootPool> has(class_1792 item) {
        return lootPool -> lootPool.hasItem(item);
    }

    @Contract(pure=true)
    @NotNull
    public static Predicate<MutableLootPool> hasAny(class_1792 ... items) {
        return lootPool -> lootPool.hasAnyItems(items);
    }

    @Contract(pure=true)
    @NotNull
    public static Predicate<MutableLootPool> hasAll(class_1792 ... items) {
        return lootPool -> lootPool.hasAllItems(items);
    }
}

