/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.item.impl;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.frozenblock.lib.config.frozenlib_config.FrozenLibConfig;
import net.frozenblock.lib.item.impl.network.CooldownTickCountPacket;
import net.frozenblock.lib.item.impl.network.ForcedCooldownPacket;
import net.frozenblock.lib.tag.api.FrozenItemTags;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1792;
import net.minecraft.class_1796;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_7923;
import net.minecraft.class_8710;
import org.jetbrains.annotations.NotNull;

public class SaveableItemCooldowns {
    @NotNull
    public static List<SaveableCooldownInstance> makeSaveableCooldownInstanceList(@NotNull class_3222 player) {
        ArrayList<SaveableCooldownInstance> saveableCooldownInstances = new ArrayList<SaveableCooldownInstance>();
        int tickCount = player.method_7357().field_8025;
        player.method_7357().field_8024.forEach((cooldownGroup, cooldownInstance) -> {
            boolean alwaysSave;
            Optional optionalItem = class_7923.field_41178.method_17966(cooldownGroup);
            boolean bl = alwaysSave = optionalItem.isPresent() && ((class_1792)optionalItem.get()).method_40131().method_40220(FrozenItemTags.ALWAYS_SAVE_COOLDOWNS);
            if (alwaysSave || FrozenLibConfig.get().saveItemCooldowns) {
                saveableCooldownInstances.add(SaveableCooldownInstance.makeFromCooldownInstance(cooldownGroup, cooldownInstance, tickCount));
            }
        });
        return saveableCooldownInstances;
    }

    public static void saveCooldowns(@NotNull class_11372 output, @NotNull class_3222 player) {
        class_11372.class_11373 list = output.method_71467("FrozenLibSavedItemCooldowns", SaveableCooldownInstance.CODEC);
        for (SaveableCooldownInstance cooldown : SaveableItemCooldowns.makeSaveableCooldownInstanceList(player)) {
            list.method_71484((Object)cooldown);
        }
    }

    @NotNull
    public static List<SaveableCooldownInstance> readCooldowns(@NotNull class_11368 input) {
        ArrayList<SaveableCooldownInstance> saveableCooldownInstances = new ArrayList<SaveableCooldownInstance>();
        class_11368.class_11369 list = input.method_71437("FrozenLibSavedItemCooldowns", SaveableCooldownInstance.CODEC);
        for (SaveableCooldownInstance cooldown : list) {
            saveableCooldownInstances.add(cooldown);
        }
        return saveableCooldownInstances;
    }

    public static void setCooldowns(@NotNull List<SaveableCooldownInstance> saveableCooldownInstances, @NotNull class_3222 player) {
        if (player.method_51469().field_9236) {
            return;
        }
        class_1796 itemCooldowns = player.method_7357();
        int tickCount = itemCooldowns.field_8025;
        ServerPlayNetworking.send((class_3222)player, (class_8710)new CooldownTickCountPacket(tickCount));
        for (SaveableCooldownInstance saveableCooldownInstance : saveableCooldownInstances) {
            int cooldownLeft = saveableCooldownInstance.cooldownLeft();
            int startTime = tickCount - (saveableCooldownInstance.totalCooldownTime() - cooldownLeft);
            int endTime = tickCount + cooldownLeft;
            class_2960 cooldownGroup = saveableCooldownInstance.cooldownGroup();
            itemCooldowns.field_8024.put(cooldownGroup, new class_1796.class_1797(startTime, endTime));
            ServerPlayNetworking.send((class_3222)player, (class_8710)new ForcedCooldownPacket(cooldownGroup, startTime, endTime));
        }
    }

    public record SaveableCooldownInstance(class_2960 cooldownGroup, int cooldownLeft, int totalCooldownTime) {
        public static final Codec<SaveableCooldownInstance> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_2960.field_25139.fieldOf("CooldownGroup").forGetter(SaveableCooldownInstance::cooldownGroup), (App)Codec.INT.fieldOf("CooldownLeft").orElse((Object)0).forGetter(SaveableCooldownInstance::cooldownLeft), (App)Codec.INT.fieldOf("TotalCooldownTime").orElse((Object)0).forGetter(SaveableCooldownInstance::totalCooldownTime)).apply((Applicative)instance, SaveableCooldownInstance::new));

        @NotNull
        public static SaveableCooldownInstance makeFromCooldownInstance(@NotNull class_2960 cooldownGroup, @NotNull class_1796.class_1797 cooldownInstance, int tickCount) {
            int cooldownLeft = cooldownInstance.comp_3084 - tickCount;
            int totalCooldownTime = cooldownInstance.comp_3084 - cooldownInstance.comp_3083;
            return new SaveableCooldownInstance(cooldownGroup, cooldownLeft, totalCooldownTime);
        }
    }
}

