/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.file.transfer;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import org.apache.commons.io.FilenameUtils;
import org.jetbrains.annotations.Nullable;

public class FileTransferFilter {
    private static final List<String> WHITELISTED_FILE_EXTENSIONS = ImmutableList.of((Object)"png", (Object)"json");
    private static final List<String> WHITELISTED_SERVER_DESTINATIONS = new ArrayList<String>();
    private static final List<String> WHITELISTED_CLIENT_DESTINATIONS = new ArrayList<String>();
    private static final List<String> WHITELISTED_SERVER_REQUEST_PATHS = new ArrayList<String>();
    private static final List<String> WHITELISTED_CLIENT_REQUEST_PATHS = new ArrayList<String>();

    public static boolean isTransferAcceptable(String destPath, String fileName, @Nullable class_3222 player) {
        boolean returnValue;
        boolean isServer;
        boolean bl = isServer = player != null;
        boolean bl2 = WHITELISTED_FILE_EXTENSIONS.contains(FilenameUtils.getExtension((String)fileName)) && FileTransferFilter.isDestinationPathAcceptable(destPath, !isServer) ? true : (returnValue = false);
        if (!returnValue && isServer) {
            player.field_13987.method_52396((class_2561)class_2561.method_43471((String)"frozenlib.file_transfer.unsupported_file"));
        }
        return returnValue;
    }

    public static boolean isRequestAcceptable(String requestPath, String fileName, @Nullable class_3222 player) {
        boolean returnValue;
        boolean isServer;
        boolean bl = isServer = player != null;
        boolean bl2 = WHITELISTED_FILE_EXTENSIONS.contains(FilenameUtils.getExtension((String)fileName)) && FileTransferFilter.isRequestPathAcceptable(requestPath, !isServer) ? true : (returnValue = false);
        if (!returnValue && isServer) {
            player.field_13987.method_52396((class_2561)class_2561.method_43471((String)"frozenlib.file_transfer.unsupported_file_request"));
        }
        return returnValue;
    }

    private static boolean isDestinationPathAcceptable(String destPath, boolean client) {
        return (client ? WHITELISTED_CLIENT_DESTINATIONS : WHITELISTED_SERVER_DESTINATIONS).contains(destPath);
    }

    private static boolean isRequestPathAcceptable(String destPath, boolean client) {
        return (client ? WHITELISTED_CLIENT_REQUEST_PATHS : WHITELISTED_SERVER_REQUEST_PATHS).contains(destPath);
    }

    public static void whitelistDestinationPath(String destPath, boolean client) {
        (client ? WHITELISTED_CLIENT_DESTINATIONS : WHITELISTED_SERVER_DESTINATIONS).add(destPath);
    }

    public static void whitelistRequestPath(String destPath, boolean client) {
        (client ? WHITELISTED_CLIENT_REQUEST_PATHS : WHITELISTED_SERVER_REQUEST_PATHS).add(destPath);
    }
}

