/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.item;

import java.util.function.Predicate;
import net.bunten.enderscape.item.NebuliteToolContext;
import net.bunten.enderscape.item.NebuliteToolItem;
import net.bunten.enderscape.registry.EnderscapeDataComponents;
import net.bunten.enderscape.registry.EnderscapeEnchantments;
import net.bunten.enderscape.registry.EnderscapeItemSounds;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_3419;
import net.minecraft.class_5536;
import net.minecraft.class_5537;
import net.minecraft.class_5630;
import net.minecraft.class_5712;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.minecraft.class_9276;
import net.minecraft.class_9334;

public class MagniaAttractorItem
extends NebuliteToolItem {
    public MagniaAttractorItem(class_1792.class_1793 properties) {
        super(properties);
    }

    @Override
    public boolean displayHudWhen(NebuliteToolContext context) {
        return MagniaAttractorItem.is(context.stack()) && MagniaAttractorItem.fuelExceedsCost(context) && MagniaAttractorItem.isEnabled(context.stack());
    }

    public class_1269 method_7836(class_1937 level, class_1657 player, class_1268 hand) {
        return this.tryCyclePower(new NebuliteToolContext(player.method_5998(hand), level, (class_1309)player)) ? class_1269.field_21466 : super.method_7836(level, player, hand);
    }

    @Override
    public boolean method_31566(class_1799 stack, class_1799 other, class_1735 slot, class_5536 action, class_1657 player, class_5630 access) {
        if (action == class_5536.field_27014 && other.method_7960()) {
            return this.tryCyclePower(new NebuliteToolContext(stack, player.method_37908(), (class_1309)player));
        }
        return super.method_31566(stack, other, slot, action, player, access);
    }

    private boolean tryCyclePower(NebuliteToolContext context) {
        if (MagniaAttractorItem.fuelExceedsCost(context)) {
            class_1799 stack;
            MagniaAttractorItem.setEnabled(stack, !MagniaAttractorItem.isEnabled(stack = context.stack()));
            context.user().method_5783(MagniaAttractorItem.isEnabled(stack) ? EnderscapeItemSounds.MAGNIA_ATTRACTOR_POWER_ON : EnderscapeItemSounds.MAGNIA_ATTRACTOR_POWER_OFF, 1.0f, 1.0f);
            context.user().method_32876((class_6880)class_5712.field_28146);
            return true;
        }
        return false;
    }

    public static boolean hasBundling(class_1937 level, class_1799 stack) {
        try {
            class_2378 registry = level.method_30349().method_46759(class_7924.field_41265).orElse(null);
            if (registry == null) {
                return false;
            }
            class_1887 enchantment = (class_1887)registry.method_29107(EnderscapeEnchantments.BUNDLING);
            if (enchantment == null) {
                return false;
            }
            class_6880 holder = registry.method_47983((Object)enchantment);
            return class_1890.method_8225((class_6880)holder, (class_1799)stack) > 0;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean is(class_1799 stack) {
        return stack.method_7909() instanceof MagniaAttractorItem;
    }

    public static boolean tryAddToBundle(class_1661 inventory, class_1799 toAdd) {
        class_1799 attractor = MagniaAttractorItem.getValidAttractor(inventory);
        if (attractor.method_7960() || !MagniaAttractorItem.isEnabled(attractor) || !MagniaAttractorItem.hasBundling(inventory.field_7546.method_37908(), attractor)) {
            return false;
        }
        for (class_1799 stack : inventory.field_7547) {
            if (!(stack.method_7909() instanceof class_5537) || !stack.method_57826(class_9334.field_49650)) continue;
            class_9276 contents = (class_9276)stack.method_58694(class_9334.field_49650);
            for (class_1799 bundle : contents.method_57421()) {
                class_9276.class_9277 mutableContents;
                if (!class_1799.method_31577((class_1799)bundle, (class_1799)toAdd) || (mutableContents = new class_9276.class_9277(contents)).method_57432(toAdd) <= 0) continue;
                stack.method_57379(class_9334.field_49650, (Object)mutableContents.method_57435());
                return true;
            }
        }
        return false;
    }

    public static class_1799 getValidAttractor(class_1661 inventory) {
        class_1657 player = inventory.field_7546;
        class_1937 level = player.method_37908();
        Predicate<class_1799> isValidAttractor = stack -> stack.method_7909() instanceof MagniaAttractorItem && NebuliteToolItem.fuelExceedsCost(new NebuliteToolContext((class_1799)stack, level, (class_1309)player));
        if (isValidAttractor.test(player.method_6047())) {
            return player.method_6047();
        }
        if (isValidAttractor.test(player.method_6079())) {
            return player.method_6079();
        }
        return inventory.field_7547.stream().filter(isValidAttractor).findFirst().orElse(class_1799.field_8037);
    }

    public static void setEnabled(class_1799 stack, boolean value) {
        stack.method_57379(EnderscapeDataComponents.ENABLED, (Object)value);
    }

    public static boolean isEnabled(class_1799 stack) {
        if (stack.method_57826(EnderscapeDataComponents.ENABLED)) {
            return (Boolean)stack.method_58694(EnderscapeDataComponents.ENABLED);
        }
        throw new IllegalStateException(String.valueOf(stack.method_7909()) + " missing component of " + String.valueOf(EnderscapeDataComponents.ENABLED));
    }

    public static void setEntitiesPulled(class_1799 stack, int value) {
        stack.method_57379(EnderscapeDataComponents.ENTITIES_PULLED, (Object)value);
    }

    public static void incrementEntitiesPulled(class_1799 stack, int count) {
        stack.method_57379(EnderscapeDataComponents.ENTITIES_PULLED, (Object)(MagniaAttractorItem.getEntitiesPulled(stack) + count));
    }

    public static int getEntitiesPulled(class_1799 stack) {
        if (stack.method_57826(EnderscapeDataComponents.ENTITIES_PULLED)) {
            return (Integer)stack.method_58694(EnderscapeDataComponents.ENTITIES_PULLED);
        }
        return 0;
    }

    public static void setEntitiesPulledToUseFuel(class_1799 stack, int value) {
        stack.method_57379(EnderscapeDataComponents.ENTITIES_PULLED_TO_USE_FUEL, (Object)value);
    }

    public static int getEntitiesPulledToUseFuel(class_1799 stack) {
        if (stack.method_57826(EnderscapeDataComponents.ENTITIES_PULLED_TO_USE_FUEL)) {
            return (Integer)stack.method_58694(EnderscapeDataComponents.ENTITIES_PULLED_TO_USE_FUEL);
        }
        throw new IllegalStateException(String.valueOf(stack.method_7909()) + " missing component of " + String.valueOf(EnderscapeDataComponents.ENTITIES_PULLED_TO_USE_FUEL));
    }

    public static int getEntityPullRange(class_1799 stack) {
        if (stack.method_57826(EnderscapeDataComponents.ENTITY_PULL_RANGE)) {
            return (Integer)stack.method_58694(EnderscapeDataComponents.ENTITY_PULL_RANGE);
        }
        return 0;
    }

    public static boolean shouldReduceFuel(class_1799 stack) {
        return MagniaAttractorItem.getEntitiesPulled(stack) >= MagniaAttractorItem.getEntitiesPulledToUseFuel(stack);
    }

    public static boolean tryUseFuel(NebuliteToolContext context, int count) {
        class_1799 stack = context.stack();
        class_1309 user = context.user();
        if (MagniaAttractorItem.shouldReduceFuel(stack)) {
            NebuliteToolItem.useFuel(context);
            MagniaAttractorItem.setEntitiesPulled(stack, Math.max(0, count - MagniaAttractorItem.getEntitiesPulledToUseFuel(stack)));
            MagniaAttractorItem.setEnabled(stack, true);
            user.method_37908().method_43128(null, user.method_23317(), user.method_23318(), user.method_23321(), EnderscapeItemSounds.MAGNIA_ATTRACTOR_USE_FUEL, class_3419.field_15248, 1.0f, 1.0f);
            return true;
        }
        return false;
    }
}

