/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.feature;

import java.util.HashSet;
import java.util.Set;
import net.bunten.enderscape.block.MagniaSproutBlock;
import net.bunten.enderscape.registry.EnderscapeBlocks;
import net.bunten.enderscape.registry.tag.EnderscapeBlockTags;
import net.bunten.enderscape.util.BlockUtil;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3031;
import net.minecraft.class_3111;
import net.minecraft.class_3532;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.minecraft.class_5821;
import net.minecraft.class_6019;

public class MagniaArchFeature
extends class_3031<class_3111> {
    private static final int RADIUS = 2;

    public MagniaArchFeature() {
        super(class_3111.field_24893);
    }

    public boolean method_13151(class_5821<class_3111> context) {
        class_5819 random = context.method_33654();
        class_5281 level = context.method_33652();
        class_2338 origin = context.method_33655();
        HashSet<class_2338> mains = new HashSet<class_2338>();
        HashSet<class_2338> decorations = new HashSet<class_2338>();
        int maxDistance = class_6019.method_35017((int)3, (int)7).method_35008(random);
        if (maxDistance <= 4 && random.method_43048(3) == 0) {
            maxDistance *= 2;
        }
        class_2338 leftSide = new class_2338(origin.method_10263() - maxDistance, origin.method_10264(), origin.method_10260());
        class_2338 rightSide = new class_2338(origin.method_10263() + maxDistance, origin.method_10264(), origin.method_10260());
        if (!BlockUtil.hasTerrainDepth((class_1936)level, leftSide, 12, class_2350.field_11033)) {
            return false;
        }
        if (!BlockUtil.hasTerrainDepth((class_1936)level, rightSide, 12, class_2350.field_11033)) {
            return false;
        }
        this.calculateArch(random, origin, level, mains, maxDistance);
        this.placeArch(mains, 2, random, level, decorations, origin);
        this.placeMagniaSprouts(decorations, random, level);
        return true;
    }

    private void calculateArch(class_5819 random, class_2338 origin, class_5281 level, Set<class_2338> mains, int maxDistance) {
        int windDirection = random.method_43056() ? -1 : 1;
        boolean weirdShape = random.method_43048(3) == 0;
        for (float angle = 0.0f; angle < (float)Math.PI * 2; angle += 0.1f) {
            class_2338 pos = class_2338.method_49637((double)((float)origin.method_10263() + (float)windDirection * class_3532.method_15374((float)angle) * (float)maxDistance), (double)((float)origin.method_10264() + class_3532.method_15362((float)angle) * 2.0f * (float)maxDistance), (double)((float)origin.method_10260() - (weirdShape ? class_3532.method_15362((float)angle) : class_3532.method_15374((float)angle)) * (float)maxDistance)).method_10087(angle > -2.0f && angle <= 2.0f && maxDistance > 4 ? 4 : 0);
            if (!level.method_8320(pos).method_45474()) continue;
            mains.add(pos);
        }
    }

    private void placeArch(Set<class_2338> mains, int radius, class_5819 random, class_5281 level, Set<class_2338> decorations, class_2338 origin) {
        mains.forEach(mainPos -> {
            for (int x = -radius; x <= radius; ++x) {
                for (int y = -radius; y <= radius; ++y) {
                    for (int z = -radius; z <= radius; ++z) {
                        class_2338 pos = mainPos.method_10069(x, y, z);
                        if (x * x + y * y + z * z > class_6019.method_35017((int)radius, (int)(radius * radius)).method_35008(random) || !level.method_8320(pos).method_45474()) continue;
                        level.method_8652(pos, EnderscapeBlocks.ALLURING_MAGNIA.method_9564(), radius);
                        decorations.add(pos);
                        this.tryReplaceFloor(level, pos, random);
                    }
                }
            }
        });
    }

    private void placeMagniaSprouts(Set<class_2338> decorations, class_5819 random, class_5281 level) {
        decorations.forEach(pos -> {
            for (class_2350 dir : class_2350.values()) {
                if (random.method_43048(15) != 0 || !level.method_8320(pos).method_27852(EnderscapeBlocks.ALLURING_MAGNIA) || !level.method_8320(pos.method_10093(dir)).method_45474()) continue;
                level.method_8652(pos.method_10093(dir), (class_2680)EnderscapeBlocks.ALLURING_MAGNIA_SPROUT.method_9564().method_11657((class_2769)MagniaSproutBlock.FACING, (Comparable)dir), 2);
            }
        });
    }

    private void tryReplaceFloor(class_5281 level, class_2338 origin, class_5819 random) {
        float radius = class_3532.method_32750((class_5819)random, (float)3.0f, (float)6.0f);
        for (float y = -radius; y <= radius; y += 1.0f) {
            for (float x = -radius; x <= radius; x += 1.0f) {
                for (float z = -radius; z <= radius; z += 1.0f) {
                    class_2338 offset = origin.method_10069((int)x, (int)y, (int)z);
                    float distance = (float)Math.sqrt(x * x + y * y + z * z);
                    if (!(distance <= radius + class_3532.method_15344((class_5819)random, (float)-2.5f, (float)0.5f)) || !level.method_8320(offset).method_26164(EnderscapeBlockTags.MAGNIA_ARCH_REPLACEABLE)) continue;
                    level.method_8652(offset, EnderscapeBlocks.ALLURING_MAGNIA.method_9564(), 2);
                }
            }
        }
    }
}

