/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.entity.rubblemite;

import com.mojang.serialization.Dynamic;
import net.bunten.enderscape.entity.ai.EnderscapeMemory;
import net.bunten.enderscape.entity.rubblemite.RubblemiteAI;
import net.bunten.enderscape.entity.rubblemite.RubblemiteVariant;
import net.bunten.enderscape.registry.EnderscapeEntitySounds;
import net.bunten.enderscape.registry.tag.EnderscapeBlockTags;
import net.bunten.enderscape.registry.tag.EnderscapeDamageTypeTags;
import net.minecraft.class_10209;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1266;
import net.minecraft.class_1267;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1315;
import net.minecraft.class_1588;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3532;
import net.minecraft.class_3695;
import net.minecraft.class_3730;
import net.minecraft.class_4095;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_7;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;

public class Rubblemite
extends class_1588 {
    private static final String RUBBLEMITE_FLAGS_KEY = "RubblemiteFlags";
    public static final int DEFAULT_FLAG = 0;
    public static final int INSIDE_SHELL_FLAG = 1;
    public static final int DASHING_FLAG = 2;
    private static final class_2940<Integer> RUBBLEMITE_FLAGS = class_2945.method_12791(Rubblemite.class, (class_2941)class_2943.field_13327);

    public Rubblemite(class_1299<? extends Rubblemite> type, class_1937 world) {
        super(type, world);
        this.method_5941(class_7.field_18, -1.0f);
        this.field_6194 = 5;
    }

    public static class_5132.class_5133 createAttributes() {
        return Rubblemite.method_26828().method_26868(class_5134.field_23724, 15.0).method_26868(class_5134.field_23721, 6.0).method_26868(class_5134.field_23716, 6.0).method_26868(class_5134.field_23719, 0.28).method_26868(class_5134.field_49079, 6.0);
    }

    protected class_4095.class_5303<Rubblemite> method_28306() {
        return class_4095.method_28311(RubblemiteAI.MEMORY_TYPES, RubblemiteAI.SENSOR_TYPES);
    }

    protected class_4095<?> method_18867(Dynamic<?> dynamic) {
        return RubblemiteAI.makeBrain((class_4095<Rubblemite>)this.method_28306().method_28335(dynamic));
    }

    public class_4095<Rubblemite> method_18868() {
        return super.method_18868();
    }

    protected void method_5958(class_3218 serverLevel) {
        class_3695 profiler = class_10209.method_64146();
        profiler.method_15396("rubblemiteBrain");
        this.method_18868().method_19542(serverLevel, (class_1309)this);
        profiler.method_15407();
        profiler.method_15396("rubblemiteActivityUpdate");
        RubblemiteAI.updateActivity(this);
        profiler.method_15407();
        super.method_5958(serverLevel);
    }

    public class_1315 method_5943(class_5425 level, class_1266 difficulty, class_3730 type, @Nullable class_1315 groupData) {
        RubblemiteVariant.set(this, RubblemiteVariant.pickForSpawning(this.field_5974, (class_6880<class_1959>)level.method_23753(this.method_24515())));
        return super.method_5943(level, difficulty, type, groupData);
    }

    public static boolean canSpawn(class_1299<Rubblemite> type, class_1936 level, class_3730 reason, class_2338 pos, class_5819 random) {
        return level.method_8407() != class_1267.field_5801 && (level.method_8320(pos.method_10074()).method_26164(EnderscapeBlockTags.RUBBLEMITE_SPAWNABLE_ON) || class_3730.method_54986((class_3730)reason));
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(RUBBLEMITE_FLAGS, (Object)0);
        builder.method_56912(RubblemiteVariant.DATA, (Object)RubblemiteVariant.END_STONE.getId());
    }

    protected void method_5652(class_11372 output) {
        super.method_5652(output);
        output.method_71465(RUBBLEMITE_FLAGS_KEY, this.getFlags());
        output.method_71465("RubblemiteVariant", RubblemiteVariant.get(this).getId());
    }

    protected void method_5749(class_11368 input) {
        super.method_5749(input);
        this.setFlags(input.method_71424(RUBBLEMITE_FLAGS_KEY, 0));
        input.method_71439("RubblemiteVariant").ifPresent(id -> RubblemiteVariant.set(this, RubblemiteVariant.byId(id)));
    }

    public int getFlags() {
        return (Integer)this.field_6011.method_12789(RUBBLEMITE_FLAGS);
    }

    public void setFlags(int value) {
        this.field_6011.method_12778(RUBBLEMITE_FLAGS, (Object)value);
    }

    public boolean isInsideShell() {
        return this.getFlags() == 1 || this.field_18321.method_18896(EnderscapeMemory.RUBBLEMITE_HIDING_DURATION);
    }

    public boolean isDashing() {
        return this.getFlags() == 2 && !this.field_18321.method_18896(EnderscapeMemory.RUBBLEMITE_DASH_ON_COOLDOWN);
    }

    public void enterShell(int value) {
        this.setFlags(1);
        if (value > 0) {
            this.field_18321.method_18878(EnderscapeMemory.RUBBLEMITE_HIDING_DURATION, (Object)value);
        }
    }

    public void exitShell() {
        this.setFlags(0);
        this.field_18321.method_18875(EnderscapeMemory.RUBBLEMITE_HIDING_DURATION);
        this.field_18321.method_24525(EnderscapeMemory.RUBBLEMITE_HIDING_ON_COOLDOWN, (Object)true, 100L);
        this.field_18321.method_24525(EnderscapeMemory.RUBBLEMITE_DASH_ON_COOLDOWN, (Object)true, 20L);
    }

    public boolean canHideInShell() {
        return this.getFlags() == 0 && !RubblemiteAI.isShellCoolingDown(this);
    }

    public boolean shouldStopDashing() {
        return this.method_24828() || this.method_5721() || this.method_5854() != null;
    }

    public void dash() {
        class_243 vec = this.method_5720();
        vec = vec.method_18805(1.4, 0.0, 1.4).method_1031(0.0, (double)0.33f, 0.0);
        this.method_18799(vec);
        this.method_5783(EnderscapeEntitySounds.RUBBLEMITE_HOP, 1.0f, 1.0f);
        class_1937 class_19372 = this.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 server = (class_3218)class_19372;
            class_243 pos = this.method_19538();
            server.method_65096((class_2394)class_2398.field_11203, pos.field_1352, pos.field_1351 + 0.5, pos.field_1350, 5, 0.0, 0.0, 0.0, 0.1);
        }
        this.setFlags(2);
    }

    protected void onDamageBlocked(class_1282 source) {
        if (source.method_5526() != null) {
            float knockback = 1.0f;
            class_1297 class_12972 = source.method_5526();
            if (class_12972 instanceof class_1309) {
                class_1309 living = (class_1309)class_12972;
                class_2378 enchantments = this.method_37908().method_30349().method_30530(class_7924.field_41265);
                knockback += (float)class_1890.method_8203((class_6880)enchantments.method_46747(class_1893.field_9121), (class_1309)living);
            }
            double x = source.method_5526().method_23317() - this.method_23317();
            double z = source.method_5526().method_23321() - this.method_23321();
            while (x * x + z * z < 1.0E-4) {
                x = (Math.random() - Math.random()) * 0.01;
                z = (Math.random() - Math.random()) * 0.01;
            }
            this.method_6005(knockback * 0.5f, x, z);
        }
        this.method_5783(EnderscapeEntitySounds.RUBBLEMITE_SHIELD, 1.0f, 1.0f);
    }

    public boolean method_64397(class_3218 level, class_1282 source, float amount) {
        if (this.method_5805() && source.method_48789(EnderscapeDamageTypeTags.RUBBLEMITES_CAN_BLOCK)) {
            if (amount >= 12.0f && super.method_64397(level, source, amount)) {
                return true;
            }
            if (this.isDashing() || this.isInsideShell()) {
                this.onDamageBlocked(source);
                return false;
            }
            if (this.canHideInShell() && super.method_64397(level, source, amount)) {
                this.enterShell(40);
                return true;
            }
        }
        return super.method_64397(level, source, amount);
    }

    public void method_6078(class_1282 source) {
        super.method_6078(source);
        this.enterShell(0);
    }

    public void method_6091(class_243 vec) {
        if (this.isInsideShell()) {
            if (this.method_5942().method_6345() != null) {
                this.method_5942().method_6340();
            }
            vec = class_243.field_1353;
        }
        super.method_6091(vec);
    }

    public void method_5951(class_1297 entity, float f, float g) {
        if (this.isInsideShell() || this.isDashing()) {
            return;
        }
        super.method_5951(entity, f, g);
    }

    public boolean method_6121(class_3218 serverLevel, class_1297 entity) {
        return !this.isInsideShell() && super.method_6121(serverLevel, entity);
    }

    protected class_3414 method_5994() {
        return this.isInsideShell() ? null : EnderscapeEntitySounds.RUBBLEMITE_AMBIENT;
    }

    protected class_3414 method_6011(class_1282 source) {
        return EnderscapeEntitySounds.RUBBLEMITE_HURT;
    }

    protected class_3414 method_6002() {
        return EnderscapeEntitySounds.RUBBLEMITE_DEATH;
    }

    protected class_3414 getStepSound() {
        return EnderscapeEntitySounds.RUBBLEMITE_STEP;
    }

    protected void method_5712(class_2338 pos, class_2680 state) {
        this.method_5783(this.getStepSound(), 0.15f, class_3532.method_15344((class_5819)this.field_5974, (float)0.9f, (float)1.1f));
    }
}

