/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.entity.magnia;

import java.util.function.Predicate;
import net.bunten.enderscape.Enderscape;
import net.bunten.enderscape.entity.magnia.MagniaProperties;
import net.bunten.enderscape.registry.tag.EnderscapeEntityTags;
import net.bunten.enderscape.registry.tag.EnderscapeItemTags;
import net.minecraft.class_1297;
import net.minecraft.class_1301;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1322;
import net.minecraft.class_1799;
import net.minecraft.class_2940;
import net.minecraft.class_2945;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;

public interface MagniaMoveable {
    public static final Predicate<class_1297> DEFAULT_MAGNIA_PREDICATE = entity -> (entity.method_5864().method_20210(EnderscapeEntityTags.AFFECTED_BY_MAGNIA) || MagniaMoveable.getMagnetismFactor(entity) > 0.0f) && class_1301.field_6155.test(entity);
    public static final class_1322 MAGNIA_GRAVITY_MODIFIER = new class_1322(Enderscape.id("magnia_gravity"), 0.1, class_1322.class_1323.field_6331);

    public MagniaProperties createMagniaProperties();

    @Nullable
    public static MagniaProperties getMagniaProperties(class_1297 entity) {
        if (entity instanceof MagniaMoveable) {
            MagniaMoveable moveable = (MagniaMoveable)entity;
            return moveable.createMagniaProperties();
        }
        return null;
    }

    public static boolean canMagniaAffect(class_1297 entity) {
        if (!(entity instanceof MagniaMoveable)) {
            return false;
        }
        MagniaProperties properties = MagniaMoveable.getMagniaProperties(entity);
        if (properties != null) {
            Predicate<class_1297> predicate = properties.isAllowed();
            return predicate.test(entity);
        }
        return false;
    }

    public class_2940<Integer> Enderscape$magniaCooldownData();

    public static boolean is(class_1297 entity) {
        return entity instanceof MagniaMoveable;
    }

    public static float getMagnetismFactor(class_1297 entity) {
        float factor = 0.0f;
        if (entity instanceof class_1309) {
            class_1309 mob = (class_1309)entity;
            int weak = 0;
            int average = 0;
            int strong = 0;
            for (class_1304 slot : class_1304.field_54086) {
                class_1799 stack = mob.method_6118(slot);
                if (!stack.method_57826(class_9334.field_54196)) continue;
                if (stack.method_31573(EnderscapeItemTags.WEAK_MAGNETISM_WHEN_WORN)) {
                    ++weak;
                    continue;
                }
                if (stack.method_31573(EnderscapeItemTags.AVERAGE_MAGNETISM_WHEN_WORN)) {
                    ++average;
                    continue;
                }
                if (!stack.method_31573(EnderscapeItemTags.STRONG_MAGNETISM_WHEN_WORN)) continue;
                ++strong;
            }
            factor += (float)weak * 0.5f + (float)average + (float)strong * 1.5f;
        }
        return factor;
    }

    default public void defineMagniaData(class_2945.class_9222 builder) {
        builder.method_56912(this.Enderscape$magniaCooldownData(), (Object)0);
    }

    public static int getMagniaCooldown(class_1297 entity) {
        if (entity instanceof MagniaMoveable) {
            MagniaMoveable moveable = (MagniaMoveable)entity;
            return (Integer)entity.method_5841().method_12789(moveable.Enderscape$magniaCooldownData());
        }
        return -1;
    }

    public static void setMagniaCooldown(class_1297 entity, int value) {
        if (!MagniaMoveable.canMagniaAffect(entity)) {
            return;
        }
        entity.method_5841().method_12778(((MagniaMoveable)entity).Enderscape$magniaCooldownData(), (Object)value);
        if (MagniaMoveable.getMagniaCooldown(entity) == 0) {
            MagniaMoveable.getMagniaProperties(entity).onStopMoving().apply(entity);
        }
    }

    public static boolean wasMovedByMagnia(class_1297 entity) {
        if (entity instanceof MagniaMoveable) {
            return MagniaMoveable.getMagniaCooldown(entity) > 0;
        }
        return false;
    }

    public static void setMovedByMagnia(class_1297 entity, boolean value) {
        if (entity instanceof MagniaMoveable) {
            MagniaMoveable moveable = (MagniaMoveable)entity;
            entity.method_5841().method_12778(moveable.Enderscape$magniaCooldownData(), (Object)(value ? 20 : 0));
        }
    }

    public static void tickMagniaCooldown(class_1297 entity) {
        int cooldown = MagniaMoveable.getMagniaCooldown(entity);
        if (cooldown > 0) {
            MagniaMoveable.setMagniaCooldown(entity, cooldown - 1);
        }
    }
}

