/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.bunten.enderscape.entity.ai.EnderscapeMemory;
import net.bunten.enderscape.entity.drifter.AbstractDrifter;
import net.bunten.enderscape.entity.drifter.DrifterAI;
import net.bunten.enderscape.registry.tag.EnderscapePoiTags;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_3218;
import net.minecraft.class_4097;
import net.minecraft.class_4141;
import net.minecraft.class_4153;
import net.minecraft.class_4156;
import net.minecraft.class_4208;
import net.minecraft.class_5321;
import net.minecraft.class_6019;

public class DrifterRefreshHomePosition
extends class_4097<AbstractDrifter> {
    private static final class_6019 NEXT_COOLDOWN_RANGE = class_6019.method_35017((int)60, (int)120);
    private static final int MAX_HOME_SEARCH_DISTANCE = 128;
    private static final int HORIZONTAL_UPDATE_RANGE = 8;
    private static final int VERTICAL_UPDATE_RANGE = 64;

    public DrifterRefreshHomePosition() {
        super((Map)ImmutableMap.of(EnderscapeMemory.DRIFTER_FIND_HOME_COOLDOWN, (Object)class_4141.field_18457));
    }

    protected int sampleNextCooldown(AbstractDrifter mob) {
        return NEXT_COOLDOWN_RANGE.method_35008(mob.method_59922()) * 20;
    }

    protected void updateOtherDrifters(class_3218 level, AbstractDrifter mob) {
        level.method_18467(AbstractDrifter.class, new class_238(mob.method_24515()).method_1009(8.0, 64.0, 8.0)).forEach(other -> {
            DrifterAI.setHome(other, DrifterAI.getHome(mob));
            other.method_18868().method_18878(EnderscapeMemory.DRIFTER_FIND_HOME_COOLDOWN, (Object)this.sampleNextCooldown(mob));
        });
    }

    protected List<class_2338> findPossibleHomes(class_3218 level, AbstractDrifter mob) {
        Stream stream = level.method_19494().method_19125(holder -> holder.method_40220(EnderscapePoiTags.DRIFTER_HOME), mob.method_24515(), 128, class_4153.class_4155.field_18489);
        return stream.map(class_4156::method_19141).collect(Collectors.toList());
    }

    protected Optional<class_2338> findNewHome(class_3218 level, AbstractDrifter mob) {
        List<class_2338> possibles = this.findPossibleHomes(level, mob);
        return possibles.isEmpty() ? Optional.empty() : possibles.stream().findAny();
    }

    protected void start(class_3218 level, AbstractDrifter mob, long l) {
        Optional<class_2338> newHome = this.findNewHome(level, mob);
        if (newHome.isPresent()) {
            DrifterAI.setHome(mob, class_4208.method_19443((class_5321)level.method_27983(), (class_2338)newHome.get()));
            this.updateOtherDrifters(level, mob);
        }
        mob.method_18868().method_18878(EnderscapeMemory.DRIFTER_FIND_HOME_COOLDOWN, (Object)this.sampleNextCooldown(mob));
    }
}

