/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.block;

import net.bunten.enderscape.block.DirectionalPlantBlock;
import net.bunten.enderscape.block.MagniaSproutBlockEntity;
import net.bunten.enderscape.block.properties.DirectionProperties;
import net.bunten.enderscape.block.properties.MagniaType;
import net.bunten.enderscape.block.properties.StateProperties;
import net.bunten.enderscape.registry.EnderscapeBlockEntities;
import net.bunten.enderscape.registry.tag.EnderscapeBlockTags;
import net.bunten.enderscape.registry.tag.EnderscapeItemTags;
import net.bunten.enderscape.util.BlockUtil;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10225;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1676;
import net.minecraft.class_1750;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import net.minecraft.class_5712;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_8235;
import net.minecraft.class_9904;
import org.jetbrains.annotations.Nullable;

public abstract class MagniaSproutBlock
extends DirectionalPlantBlock
implements class_3737,
class_2343 {
    public static final class_2746 POWERED = StateProperties.field_12484;
    public static final class_2746 OVERHEATED = StateProperties.OVERHEATED;
    public static final class_2746 WATERLOGGED = StateProperties.field_12508;
    public final MagniaType magniaType;

    public MagniaSproutBlock(MagniaType magniaType, class_4970.class_2251 settings) {
        super(DirectionProperties.create().all(), settings);
        this.method_9590((class_2680)((class_2680)((class_2680)this.method_9564().method_11657((class_2769)POWERED, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)OVERHEATED, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        this.magniaType = magniaType;
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new MagniaSproutBlockEntity(pos, state);
    }

    @Nullable
    protected static <E extends class_2586, A extends class_2586> class_5558<A> createTickerHelper(class_2591<A> type1, class_2591<E> type2, class_5558<? super E> ticker) {
        return type2 == type1 ? ticker : null;
    }

    public static MagniaType getMagniaType(class_2680 state) {
        MagniaType magniaType;
        class_2248 class_22482 = state.method_26204();
        if (class_22482 instanceof MagniaSproutBlock) {
            MagniaSproutBlock sprout = (MagniaSproutBlock)class_22482;
            magniaType = sprout.magniaType;
        } else {
            magniaType = null;
        }
        return magniaType;
    }

    public static boolean isPowered(class_2680 state) {
        return state.method_26204() instanceof MagniaSproutBlock && (Boolean)state.method_11654((class_2769)POWERED) != false;
    }

    public static boolean isOverheated(class_2680 state) {
        return state.method_26204() instanceof MagniaSproutBlock && (Boolean)state.method_11654((class_2769)OVERHEATED) != false;
    }

    public static boolean shouldOverheat(class_1937 world, class_2338 origin) {
        for (class_2350 dir : class_2350.values()) {
            class_2338 pos = origin.method_10093(dir);
            if (!world.method_8320(pos).method_26164(EnderscapeBlockTags.OVERHEATS_MAGNIA_SPROUTS)) continue;
            return true;
        }
        return false;
    }

    public static boolean canPullEntities(class_2680 state) {
        return MagniaSproutBlock.isPowered(state) && !MagniaSproutBlock.isOverheated(state);
    }

    public static boolean isRepulsive(class_2680 state) {
        return MagniaSproutBlock.getMagniaType(state) == MagniaType.REPULSIVE;
    }

    private boolean trySetPowered(class_2680 state, class_1937 level, class_2338 pos) {
        if (MagniaSproutBlock.isOverheated(state) || MagniaSproutBlock.shouldOverheat(level, pos) || !this.getNeighborSignal((class_8235)level, pos, (class_2350)state.method_11654((class_2769)FACING))) {
            return false;
        }
        return this.setPowered(state, level, pos, true);
    }

    private boolean setPowered(class_2680 state, class_1937 level, class_2338 pos, boolean powered) {
        class_243 vec = class_243.method_24953((class_2382)pos);
        level.method_8652(pos, (class_2680)state.method_11657((class_2769)POWERED, (Comparable)Boolean.valueOf(powered)), 3);
        level.method_43128(null, vec.field_1352, vec.field_1351, vec.field_1350, powered ? this.magniaType.getPowerOnSound() : this.magniaType.getPowerOffSound(), class_3419.field_15245, 1.0f, 1.0f);
        level.method_33596(null, (class_6880)(powered ? class_5712.field_28174 : class_5712.field_28175), pos);
        return true;
    }

    private void setOverheated(class_2680 state, class_1937 level, class_2338 pos, boolean value) {
        if (value) {
            class_243 vec = class_243.method_24953((class_2382)pos);
            class_2680 updatedState = state;
            if (MagniaSproutBlock.isPowered(state)) {
                updatedState = (class_2680)updatedState.method_28493((class_2769)POWERED);
                level.method_43128(null, vec.field_1352, vec.field_1351, vec.field_1350, this.magniaType.getOverheatSound(), class_3419.field_15245, 1.0f, 1.0f);
            }
            level.method_8652(pos, (class_2680)updatedState.method_11657((class_2769)OVERHEATED, (Comparable)Boolean.valueOf(value)), 3);
            level.method_33596(null, (class_6880)class_5712.field_28733, pos);
        } else {
            level.method_8652(pos, (class_2680)state.method_11657((class_2769)OVERHEATED, (Comparable)Boolean.valueOf(value)), 3);
            level.method_33596(null, (class_6880)class_5712.field_28733, pos);
        }
    }

    @Nullable
    public <T extends class_2586> class_5558<T> method_31645(class_1937 level, class_2680 state, class_2591<T> type) {
        return !level.method_8608() ? MagniaSproutBlock.createTickerHelper(type, EnderscapeBlockEntities.MAGNIA_SPROUT, MagniaSproutBlockEntity::tick) : null;
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{FACING, POWERED, OVERHEATED, WATERLOGGED});
    }

    @Override
    public boolean canPlantOn(class_2680 state, class_2680 floor, class_1922 level, class_2338 pos, class_2350 facing) {
        return floor.method_26206(level, pos, facing) && floor.method_26216();
    }

    public class_265 method_9530(class_2680 state, class_1922 level, class_2338 pos, class_3726 context) {
        return BlockUtil.createRotatedShape(3.0, 0.0, 3.0, 13.0, 13.0, 13.0, (class_2350)state.method_11654((class_2769)FACING));
    }

    @Override
    @Nullable
    public class_2680 method_9605(class_1750 context) {
        class_2680 state = super.method_9605(context);
        if (state == null) {
            return null;
        }
        class_2338 pos = context.method_8037();
        class_1937 level = context.method_8045();
        class_3610 fluid = level.method_8316(pos);
        boolean shouldOverheat = MagniaSproutBlock.shouldOverheat(level, pos);
        return (class_2680)((class_2680)((class_2680)state.method_11657((class_2769)POWERED, (Comparable)Boolean.valueOf(this.getNeighborSignal((class_8235)level, pos, (class_2350)state.method_11654((class_2769)FACING)) && !shouldOverheat))).method_11657((class_2769)OVERHEATED, (Comparable)Boolean.valueOf(shouldOverheat))).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(fluid.method_15772() == class_3612.field_15910));
    }

    public class_2680 method_9559(class_2680 state, class_4538 world, class_10225 access, class_2338 pos, class_2350 direction, class_2338 pos2, class_2680 state2, class_5819 random) {
        if (((Boolean)state.method_11654((class_2769)WATERLOGGED)).booleanValue()) {
            access.method_64312(pos, (class_3611)class_3612.field_15910, class_3612.field_15910.method_15789(world));
        }
        return super.method_9559(state, world, access, pos, direction, pos2, state2, random);
    }

    public class_3610 method_9545(class_2680 state) {
        if (((Boolean)state.method_11654((class_2769)WATERLOGGED)).booleanValue()) {
            return class_3612.field_15910.method_15729(false);
        }
        return super.method_9545(state);
    }

    private boolean getNeighborSignal(class_8235 getter, class_2338 pos, class_2350 facing) {
        for (class_2350 direction : class_2350.values()) {
            if (direction == facing || !getter.method_49807(pos.method_10093(direction), direction)) continue;
            return true;
        }
        if (getter.method_49807(pos, class_2350.field_11033)) {
            return true;
        }
        class_2338 abovePos = pos.method_10084();
        for (class_2350 direction : class_2350.values()) {
            if (direction == class_2350.field_11033 || !getter.method_49807(abovePos.method_10093(direction), direction)) continue;
            return true;
        }
        return false;
    }

    private void updateState(class_2680 state, class_1937 level, class_2338 pos, boolean schedule) {
        if (level.method_8608()) {
            return;
        }
        boolean hasSignal = this.getNeighborSignal((class_8235)level, pos, (class_2350)state.method_11654((class_2769)FACING));
        boolean shouldOverheat = MagniaSproutBlock.shouldOverheat(level, pos);
        boolean overheated = MagniaSproutBlock.isOverheated(state);
        boolean powered = MagniaSproutBlock.isPowered(state);
        if (overheated != shouldOverheat) {
            this.setOverheated(state, level, pos, shouldOverheat);
        }
        if (powered != hasSignal) {
            if (hasSignal) {
                this.trySetPowered(state, level, pos);
            } else if (schedule) {
                level.method_64310(pos, (class_2248)this, 5);
            } else {
                this.setPowered(state, level, pos, false);
            }
        }
    }

    protected void method_9612(class_2680 state, class_1937 level, class_2338 pos, class_2248 block, @Nullable class_9904 orientation, boolean bl) {
        this.updateState(state, level, pos, true);
    }

    public void method_9588(class_2680 state, class_3218 level, class_2338 pos, class_5819 random) {
        this.updateState(state, (class_1937)level, pos, false);
    }

    protected void method_9606(class_2680 state, class_1937 level, class_2338 pos, class_1657 player) {
        if (!MagniaSproutBlock.isPowered(state) && player.method_5998(class_1268.field_5808).method_31573(EnderscapeItemTags.POWERS_MAGNIA_WHEN_MINED_WITH) && this.trySetPowered(state, level, pos)) {
            level.method_64310(pos, (class_2248)this, 30);
        }
        super.method_9606(state, level, pos, player);
    }

    public void method_19286(class_1937 level, class_2680 state, class_3965 hit, class_1676 projectile) {
        class_2338 pos = hit.method_17777();
        if (!MagniaSproutBlock.isPowered(state) && !MagniaSproutBlock.isOverheated(state) && this.trySetPowered(state, level, pos)) {
            level.method_64310(pos, (class_2248)this, 20);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public void method_9496(class_2680 state, class_1937 level, class_2338 pos, class_5819 random) {
        if (MagniaSproutBlock.canPullEntities(state)) {
            class_243 midair;
            class_243 center = class_243.method_24953((class_2382)pos);
            class_243 origin = midair = class_243.method_24953((class_2382)pos.method_10079(MagniaSproutBlock.getFacing(state), 6));
            double xs = (center.method_10216() - midair.method_10216()) * (double)0.2f;
            double ys = (center.method_10214() - midair.method_10214()) * (double)0.2f;
            double zs = (center.method_10215() - midair.method_10215()) * (double)0.2f;
            if (MagniaSproutBlock.isRepulsive(state)) {
                xs = -xs;
                ys = -ys;
                zs = -zs;
                origin = center;
            }
            level.method_8406(this.magniaType.getParticle(), origin.method_10216() + random.method_43059() / 4.0, origin.method_10214() + random.method_43059() / 3.0, origin.method_10215() + random.method_43059() / 4.0, xs, ys, zs);
        }
    }
}

