/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.biome.util;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.bunten.enderscape.registry.EnderscapeRegistries;
import net.bunten.enderscape.util.RGBA;
import net.minecraft.class_1959;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_5321;
import net.minecraft.class_6880;

public record SkyParameters(class_2960 location, int nebulaColor, float nebulaAlpha, int starColor, float starAlpha, float fogStartDensity, float fogEndDensity) {
    public static final RGBA DEFAULT_NEBULA_COLOR = new RGBA(8084382, 0.05f);
    public static final RGBA DEFAULT_STAR_COLOR = new RGBA(15305215, 0.12f);
    public static final float DEFAULT_FOG_START_DENSITY = 1.0f;
    public static final float DEFAULT_FOG_END_DENSITY = 1.0f;
    public static final Codec<SkyParameters> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_2960.field_25139.fieldOf("biome").forGetter(config -> config.location), (App)Codec.intRange((int)0, (int)0xFFFFFF).fieldOf("nebula_color").forGetter(config -> config.nebulaColor), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("nebula_alpha").forGetter(config -> Float.valueOf(config.nebulaAlpha)), (App)Codec.intRange((int)0, (int)0xFFFFFF).fieldOf("star_color").forGetter(config -> config.starColor), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("star_alpha").forGetter(config -> Float.valueOf(config.starAlpha)), (App)Codec.floatRange((float)1.0f, (float)4.0f).fieldOf("fog_start_density").forGetter(config -> Float.valueOf(config.fogStartDensity)), (App)Codec.floatRange((float)1.0f, (float)4.0f).fieldOf("fog_end_density").forGetter(config -> Float.valueOf(config.fogEndDensity))).apply((Applicative)instance, SkyParameters::new));

    public RGBA nebulaRGBA() {
        return new RGBA(this.nebulaColor, this.nebulaAlpha);
    }

    public RGBA starRGBA() {
        return new RGBA(this.starColor, this.starAlpha);
    }

    public static Optional<SkyParameters> getSkyParametersFor(class_6880<class_1959> biomeHolder) {
        if (biomeHolder == null) {
            return Optional.empty();
        }
        return class_310.method_1551().field_1687.method_30349().method_46759(EnderscapeRegistries.SKY_PARAMETERS_KEY).flatMap(registry -> biomeHolder.method_40230().map(class_5321::method_29177).map(arg_0 -> ((class_2378)registry).method_63535(arg_0)).map(Optional::ofNullable).orElse(Optional.empty()));
    }
}

